/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.util;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;

public class Bits {
    public static byte short1(short s) {
        return (byte)(s >> 8);
    }

    public static byte short0(short s) {
        return (byte)(s >> 0);
    }

    public static byte int3(int n) {
        return (byte)(n >> 24);
    }

    public static byte int2(int n) {
        return (byte)(n >> 16);
    }

    public static byte int1(int n) {
        return (byte)(n >> 8);
    }

    public static byte int0(int n) {
        return (byte)(n >> 0);
    }

    public static byte long7(long l) {
        return (byte)(l >> 56);
    }

    public static byte long6(long l) {
        return (byte)(l >> 48);
    }

    public static byte long5(long l) {
        return (byte)(l >> 40);
    }

    public static byte long4(long l) {
        return (byte)(l >> 32);
    }

    public static byte long3(long l) {
        return (byte)(l >> 24);
    }

    public static byte long2(long l) {
        return (byte)(l >> 16);
    }

    public static byte long1(long l) {
        return (byte)(l >> 8);
    }

    public static byte long0(long l) {
        return (byte)(l >> 0);
    }

    public static short makeShort(byte by, byte by2) {
        return (short)(by << 8 | by2 & 0xFF);
    }

    public static int makeInt(byte by, byte by2, byte by3, byte by4) {
        return (by & 0xFF) << 24 | (by2 & 0xFF) << 16 | (by3 & 0xFF) << 8 | (by4 & 0xFF) << 0;
    }

    private static long makeLong(byte by, byte by2, byte by3, byte by4, byte by5, byte by6, byte by7, byte by8) {
        return ((long)by & 0xFFL) << 56 | ((long)by2 & 0xFFL) << 48 | ((long)by3 & 0xFFL) << 40 | ((long)by4 & 0xFFL) << 32 | ((long)by5 & 0xFFL) << 24 | ((long)by6 & 0xFFL) << 16 | ((long)by7 & 0xFFL) << 8 | ((long)by8 & 0xFFL) << 0;
    }

    public static int put(byte[] byArray, int n, short s) {
        byArray[n++] = Bits.short1(s);
        byArray[n++] = Bits.short0(s);
        return n;
    }

    public static int put(byte[] byArray, int n, int n2) {
        byArray[n++] = Bits.int3(n2);
        byArray[n++] = Bits.int2(n2);
        byArray[n++] = Bits.int1(n2);
        byArray[n++] = Bits.int0(n2);
        return n;
    }

    public static int put(byte[] byArray, int n, long l) {
        byArray[n++] = Bits.long7(l);
        byArray[n++] = Bits.long6(l);
        byArray[n++] = Bits.long5(l);
        byArray[n++] = Bits.long4(l);
        byArray[n++] = Bits.long3(l);
        byArray[n++] = Bits.long2(l);
        byArray[n++] = Bits.long1(l);
        byArray[n++] = Bits.long0(l);
        return n;
    }

    public static int put(byte[] byArray, int n, byte[] byArray2) {
        System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
        return n + byArray2.length;
    }

    public static short getShort(byte[] byArray, int n) {
        return Bits.makeShort(byArray[n + 0], byArray[n + 1]);
    }

    public static int getInt(byte[] byArray, int n) {
        return Bits.makeInt(byArray[n + 0], byArray[n + 1], byArray[n + 2], byArray[n + 3]);
    }

    public static long getLong(byte[] byArray, int n) {
        return Bits.makeLong(byArray[n + 0], byArray[n + 1], byArray[n + 2], byArray[n + 3], byArray[n + 4], byArray[n + 5], byArray[n + 6], byArray[n + 7]);
    }

    public static byte[] randomBits(int n) {
        int n2;
        long[] lArray = new long[]{System.currentTimeMillis(), new Object().hashCode(), Runtime.getRuntime().freeMemory(), Runtime.getRuntime().totalMemory()};
        byte[] byArray = new byte[lArray.length * 8];
        int n3 = 0;
        for (int i = 0; i < lArray.length; ++i) {
            n3 = Bits.put(byArray, n3, lArray[i]);
        }
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
        byte[] byArray2 = messageDigest.digest(byArray);
        byte[] byArray3 = new byte[n];
        for (n2 = 0; n2 < byArray3.length && n2 < byArray3.length; ++n2) {
            byArray3[n2] = byArray2[n2];
        }
        if (n2 < byArray3.length) {
            Random random = new Random();
            while (n2 < byArray3.length) {
                byArray3[n2] = (byte)random.nextInt(127);
                ++n2;
            }
        }
        return byArray3;
    }

    public static String toHexString(byte[] byArray, boolean bl) {
        if (byArray.length % 2 != 0) {
            throw new IllegalArgumentException();
        }
        String string = ":";
        StringBuffer stringBuffer = new StringBuffer(3 * byArray.length);
        int n = 0;
        while (n < byArray.length) {
            int n2 = byArray[n + 1] & 0xFF;
            stringBuffer.append(Integer.toHexString(n2 |= byArray[n] << 8 & 0xFF00));
            if ((n += 2) >= byArray.length || !bl) continue;
            stringBuffer.append(":");
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        long l;
        int n;
        short s = Short.MAX_VALUE;
        short s2 = Short.MIN_VALUE;
        int n2 = Integer.MAX_VALUE;
        int n3 = Integer.MIN_VALUE;
        long l2 = Long.MAX_VALUE;
        long l3 = Long.MIN_VALUE;
        int n4 = 28;
        byte[] byArray = new byte[n4];
        int n5 = 0;
        n5 = Bits.put(byArray, n5, s);
        n5 = Bits.put(byArray, n5, n2);
        n5 = Bits.put(byArray, n5, l2);
        n5 = Bits.put(byArray, n5, s2);
        n5 = Bits.put(byArray, n5, n3);
        n5 = Bits.put(byArray, n5, l3);
        System.out.println("Data: " + s + " " + n2 + " " + l2 + " " + s2 + " " + n3 + " " + l3 + " " + "\n" + "Buf: " + Bits.toHexString(byArray, true));
        n5 = 0;
        short s3 = Bits.getShort(byArray, n5);
        if (s3 != s) {
            System.err.println("ERROR1 short " + s3 + "!=" + s);
        }
        if ((n = Bits.getInt(byArray, n5 += 2)) != n2) {
            System.err.println("ERROR2 int " + n + "!=" + n2);
        }
        if ((l = Bits.getLong(byArray, n5 += 4)) != l2) {
            System.err.println("ERROR3 long " + l + "!=" + l2);
        }
        if ((s3 = Bits.getShort(byArray, n5 += 8)) != s2) {
            System.err.println("ERROR4 short " + s3 + "!=" + s2);
        }
        if ((n = Bits.getInt(byArray, n5 += 2)) != n3) {
            System.err.println("ERROR5 int " + n + "!=" + n3);
        }
        if ((l = Bits.getLong(byArray, n5 += 4)) != l3) {
            System.err.println("ERROR6 long " + l + "!=" + l3);
        }
        n5 += 8;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        try {
            s3 = dataInputStream.readShort();
            if (s3 != s) {
                System.err.println("ERROR7 short " + s3 + "!=" + s);
            }
            if ((n = dataInputStream.readInt()) != n2) {
                System.err.println("ERROR8 int " + n + "!=" + n2);
            }
            if ((l = dataInputStream.readLong()) != l2) {
                System.err.println("ERROR9 long " + l + "!=" + l2);
            }
            if ((s3 = dataInputStream.readShort()) != s2) {
                System.err.println("ERROR10 short " + s3 + "!=" + s2);
            }
            if ((n = dataInputStream.readInt()) != n3) {
                System.err.println("ERROR11 int " + n + "!=" + n3);
            }
            if ((l = dataInputStream.readLong()) != l3) {
                System.err.println("ERROR12 long " + l + "!=" + l3);
            }
        }
        catch (Exception exception) {
            System.err.println("ERROR13 " + exception);
        }
    }
}

