// ident "@(#)wizard.js 1.14 04/09/13 SMI"
// 
// Copyright 2004 by Sun Microsystems, Inc. All rights reserved.
// Use is subject to license terms.
//
// This Javascript file should be included in any page that uses the
// ui:wizard tag. It is included automatically by 
// com.sun.web.ui.renderer.WizardRenderer.
//
// A javascript object is created with a global identifier
// that is equivalent to the fully qualified DOM id of the 'ui:wizard'
// tag, where ":" is replaced with "_", and prefix "Wizard_".
// For example, if the fully qualified id is "form1:wizard1", then the
// identifer will be 'Wizard_wizardform_wizard1'. Methods defined on that
// javascript object instance maybe called using that identifier.
// For example, the following javascript could be used to close and forward
// to a page when the wizard closes.
//
//   <ui:wizard ...other attributes... 
//	onPopupDismiss="javascript: Wizard_wizardform_wizard1.closeAndForward('launchform', '/faces/wizardData.jsp', true);" >
//
//	...wizard step tags...
//
//   </ui:wizard>
//

function sjwuic_wizard_nextClicked() {
    return true;
}

function sjwuic_wizard_previousClicked() {
    return true;
}

function sjwuic_wizard_cancelClicked() {
    return true;
}

function sjwuic_wizard_closeClicked() {
    return true;
}

function sjwuic_wizard_finishClicked() {
    return true;
}

function sjwuic_wizard_gotoStepClicked() {
    return true;
}

function sjwuic_wizard_closePopup() {
    window.close();
}

// Close the wizard popup and forward to "submitPage" by submitting
// "submitForm".
//
// When the wizard closes it is often necessary to send
// a request to a page that will make use of the data collected
// during a wizard session. This method does this by obtaining the
// form element "submitForm" from the page that launched the
// the wizard. This means that the page that launched the wizard
// popup must still be visible in a browser window. If that form
// is found, the "action" property is set to "submitPage" and the
// "submit" method of that "submitForm" is executed.
// The popup window is then closed. 
//
// However due to JSF's client side state saving mode an extra step
// must be taken. If the application is operating with client side
// state saving, JSF will ignore the "submitPage" value of the
// submitted form's "action" property and will send the request to the
// view defined in the saved state, saved in an element in "submitForm".
//
// If the application is configured for client side state saving and
// the "submitPage" is different from the page that lauched the wizard,
// set "cleartState" to true. This method will clear the saved state 
// before submitting the form. The "clearState" default value is false
// and the saved state will not be cleared.
// 
// The "clearState" functionality only works with Sun's RI.
//
function sjwuic_wizard_closeAndForward(submitForm, submitPage, clearState) {

    var f = window.opener.document.getElementById(submitForm);
    if (f == null) {
	alert("Can't find form " + submitForm);
	window.close();
    }

    if (clearState != null && clearState == true) {
	var elements = f.elements;
	var clientstate = null;
	for (var i = 0; i < elements.length; ++i) {
	    // This only works for the Sun RI and is
	    // dependent on the RIConstants.FACES_VIEW value
	    // of "com.sun.faces.VIEW"
	    //
	    if (elements[i].name == "com.sun.faces.VIEW") {
		clientstate = elements[i];
		break;
	    }
	}
	if (clientstate != null) {
	    f.removeChild(clientstate);
	}
    }

    f.action = submitPage;
    f.submit();
    window.close();
}

// The Wizard javascript object protoype
//
function WizardBase() {
    this.nextClicked = sjwuic_wizard_nextClicked;
    this.previousClicked = sjwuic_wizard_previousClicked;
    this.cancelClicked = sjwuic_wizard_cancelClicked;
    this.finishClicked = sjwuic_wizard_finishClicked;
    this.closeClicked = sjwuic_wizard_closeClicked;
    this.gotoStepClicked = sjwuic_wizard_gotoStepClicked;
    this.closePopup = sjwuic_wizard_closePopup;
    this.closeAndForward = sjwuic_wizard_closeAndForward;
}

// The Wizard javascript object prototype created by the 
// WizardRenderer, when renderering ui:wizard.
//
function Wizard(jsWizardId, formId) {

    this.formName = formId;
    this.jsWizardId = jsWizardId;

}

Wizard.prototype = new WizardBase;

// This method must be assigned to the onload handler of the onLoad
// attribute of the ui:body tag if the wizard is to operate properly on IE.
//
function wizOnLoad(wizardId) {
    var stepsid = wizardId + "_stepspane";
    var helpid = wizardId + "_helppane";
    var wizbdyid = wizardId + "_WizBdy";
    resize_hack(helpid,stepsid,wizbdyid);
}

// used only for popup window and IE, and called by wizOnLoad.
//
function resize_hack(helpid, stepsid, wizbdyid) {

    if (public_browserVersion.is_ie5up) {
	var bdy = document.getElementById(wizbdyid);

	if (bdy != null) {

	    bdy.style.height = document.body.clientHeight - 145;

	    if (helpid != null && helpid != '') {
                var help = document.getElementById(helpid);
                if (help != null) {
		    help.style.height = document.body.clientHeight - 90;
                 }
	    }
	    if (stepsid != null && stepsid != '') {
               var steps = document.getElementById(stepsid);
               if (steps != null) {
		    steps.style.height = document.body.clientHeight - 90;
                }
	    }
	}
    }
}
