/*
 * EnvironmentFactory.java
 *
 * Created on December 15, 2003, 10:33 PM
 */

package com.sun.enterprise.config.backup;

import com.sun.enterprise.config.backup.utils.LoggerHelper;
import java.util.logging.Logger;
import com.sun.enterprise.config.backup.status.StatusConstants;
import com.sun.enterprise.config.backup.BackupStorageMonitor;
import com.sun.enterprise.config.backup.HistoryManager;

import com.sun.enterprise.config.backup.EnvironmentConstants;


/**
 * provides a basic implementation of factory. Users can
 * extend this class and implement required methods and set their
 * class in environment variable ENVIRONMENT_FACTORY_CLASS. The
 * statis create method in this class reads the variable and
 * instantiates the class. Note that the implemented factory
 * needs a no arg constructor.
 *
 * @author  sridatta
 */
public class FeatureFactory implements StatusConstants, EnvironmentConstants {
    
    private static HistoryManager _HM = null;
    private static BackupStorageMonitor _MBM = null;
    private static SnapShotStorageMonitor _MSM = null; 
    
    public static synchronized HistoryManager getHistoryManager() 
                                    throws BackupException {
        if(_HM == null)
            _HM = createHistoryManager();
        
        return _HM;
    }
    private static HistoryManager createHistoryManager() 
                                throws BackupException {
        return new HistoryManager();
    }
    
    public static synchronized BackupStorageMonitor getBackupStorageMonitor() 
                                        throws BackupException {
        
        if(_MBM == null)
            _MBM = createBackupStorageMonitor();
        
        return _MBM;
    }
    
    private static BackupStorageMonitor createBackupStorageMonitor() 
                                throws BackupException {
        return new BackupStorageMonitor();
    }
    
    public static synchronized SnapShotStorageMonitor getSnapShotStorageMonitor() 
                                        throws BackupException {
        
        if(_MSM == null)
            _MSM = createSnapShotStorageMonitor();
        
        return _MSM;
    }
    
    private static SnapShotStorageMonitor createSnapShotStorageMonitor() 
                                throws BackupException {
        return new SnapShotStorageMonitor();
    }
    
    /*
    public static synchronized BackupDeleteHandler getBackupDeleteHandler() 
                                        {
        
        if(_DH == null)
            _DH = createBackupDeleteHandler();
        
        return _DH;
    }
     */
    
    /*private static BackupDeleteHandler createBackupDeleteHandler() 
                                {
        return new BackupDeleteHandler();
    }  
     */ 
}