/*
 * BackupHelper.java
 *
 * Created on December 22, 2003, 10:04 PM
 */

package com.sun.enterprise.config.backup.utils;

//remove dependency
import com.sun.enterprise.config.backup.status.BackupStatus;


import com.sun.enterprise.config.backup.status.Status;
import com.sun.enterprise.config.backup.status.StatusConstants;
import com.sun.enterprise.config.backup.pluggable.BackupEnvironment;
import com.sun.enterprise.config.backup.pluggable.ActiveAssistance;
import com.sun.enterprise.config.backup.pluggable.EnvironmentFactory;
import com.sun.enterprise.config.backup.pluggable.BackupSynchronizer;
import com.sun.enterprise.config.backup.pluggable.BackupStorage;
import com.sun.enterprise.config.backup.HistoryManager;
import com.sun.enterprise.config.backup.EnvironmentConstants;
import com.sun.enterprise.config.backup.DefaultConstants;
import com.sun.enterprise.config.backup.BackupException;
import com.sun.enterprise.config.backup.BackupStorageMonitor;
import com.sun.enterprise.config.backup.StorageMonitor;
import com.sun.enterprise.config.backup.SnapShotStorageMonitor;
import com.sun.enterprise.config.backup.FeatureFactory;
import java.io.File;
/**
 *
 * @author  sridatta
 */
public class FactoryHelper implements EnvironmentConstants {
    
    /** Creates a new instance of BackupHelper */
    public FactoryHelper() {
    }
     
    public static BackupEnvironment getEnv() {
        return getFactory().getBackupEnvironment();
    }
    
     public static ActiveAssistance getAssistance() {
        return getFactory().getActiveAssistance();
    }
    
    public static EnvironmentFactory getFactory() {
        return EnvironmentFactory.getEnvironmentFactory();
    }
 
    public static BackupSynchronizer getSynchronizer() {
        return getFactory().getBackupSynchronizer();
    }
    public static BackupStorage getStorage() {
        return getFactory().getBackupStorage();
    }
    public static HistoryManager getHistoryManager()
                                    throws BackupException {
        return FeatureFactory.getHistoryManager();
    }
/*    public static BackupDeleteHandler getBackupDeleteHandler() {
        return FeatureFactory.getBackupDeleteHandler();
    }
 */
    public static BackupStorageMonitor getBackupStorageMonitor() 
                                throws BackupException {
        return FeatureFactory.getBackupStorageMonitor();
    }
    public static SnapShotStorageMonitor getSnapShotStorageMonitor() throws BackupException {
        return FeatureFactory.getSnapShotStorageMonitor();
    }
}
