/*
 * SystemPropsHelper.java
 *
 * Created on January 15, 2004, 9:24 PM
 */

package com.sun.enterprise.config.backup.utils;

import com.sun.enterprise.config.backup.utils.LoggerHelper;
import com.sun.enterprise.config.backup.DefaultConstants;

/**
 *
 * @author  bnevins
 */
public class SystemPropsHelper
{
	public SystemPropsHelper()
	{
	}

	public static String getProperty(String what)
	{
		String value = System.getProperty(what);
		
		if(DefaultConstants.debug)
		{
			// this code will not be compiled if debug is false
			LoggerHelper.fine("READ ENV: " + what + "=" + value);
			//System.out.println("ENV: " + what + "=" + value);
		}
		return value;
	}

	public static String setProperty(String what, String value)
	{
		System.setProperty(what, value);
		
		if(DefaultConstants.debug)
		{
			// this code will not be compiled if debug is false
			LoggerHelper.fine("WRITE ENV: " + what + "=" + value);
			//System.out.println("ENV: " + what + "=" + value);
		}
		return value;
	}
}
