/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.ui.ant;

import com.sun.jbi.ui.ant.JbiTargetTask;
import java.io.File;
import org.apache.tools.ant.BuildException;

public class JbiDeployServiceAssemblyTask
extends JbiTargetTask {
    private static final String PARTIAL_SUCCESS_STATUS_KEY = "jbi.ui.ant.deploy.partial.success";
    private static final String SUCCESS_STATUS_KEY = "jbi.ui.ant.deploy.successful";
    private static final String FAILED_STATUS_KEY = "jbi.ui.ant.deploy.failed";
    private File mDeployFile;
    private String mSAName = null;

    public String getName() {
        return this.mSAName;
    }

    public void setName(String name) {
        this.mSAName = name;
    }

    public File getFile() {
        return this.mDeployFile;
    }

    public void setFile(File file) {
        this.mDeployFile = file;
    }

    protected void validateDeployFile(File deployFile) throws BuildException {
        if (deployFile == null) {
            this.throwTaskBuildException("jbi.ui.ant.deploy.error.sa.archive.file.path.null");
        }
        if (deployFile.getPath().trim().length() <= 0) {
            this.throwTaskBuildException("jbi.ui.ant.deploy.error.sa.archive.file.path.required");
        }
        if (!deployFile.exists()) {
            this.throwTaskBuildException("jbi.ui.ant.deploy.error.sa.archive.file.not.exist", deployFile.getName());
        }
        if (deployFile.isDirectory()) {
            this.throwTaskBuildException("jbi.ui.ant.deploy.error.sa.archive.file.is.directory");
        }
    }

    protected void validateDeployFromDomainAttributes(String saName, String target) throws BuildException {
        if (saName.trim().length() == 0) {
            this.throwTaskBuildException("jbi.ui.ant.deploy.from.domain.error.sa.name.required");
        }
        if ("domain".equals(target)) {
            this.throwTaskBuildException("jbi.ui.ant.deploy.error.sa.invalid.target.with.name.attrib");
        }
    }

    public void executeTask() throws BuildException {
        String deployFileAbsolutePath = null;
        boolean deployFromDoamin = false;
        String saName = this.getName();
        File deployFile = this.getFile();
        String target = this.getValidTarget();
        if (saName == null && deployFile == null) {
            this.throwTaskBuildException("jbi.ui.ant.deploy.error.sa.name.or.file.required");
        }
        if (saName != null && deployFile != null) {
            this.throwTaskBuildException("jbi.ui.ant.deploy.error.sa.name.and.file.set");
        }
        if (saName != null) {
            this.validateDeployFromDomainAttributes(saName, target);
            deployFromDoamin = true;
        } else {
            this.validateDeployFile(deployFile);
            deployFileAbsolutePath = deployFile.getAbsolutePath();
        }
        String result = null;
        try {
            result = deployFromDoamin ? this.getJBIAdminCommands().deployServiceAssemblyFromDomain(saName, target) : this.getJBIAdminCommands().deployServiceAssembly(deployFileAbsolutePath, target);
        }
        catch (Exception ex) {
            this.processTaskException(ex);
        }
        this.processTaskResult(result);
    }

    protected String getTaskFailedStatusI18NKey() {
        return FAILED_STATUS_KEY;
    }

    protected String getTaskSuccessStatusI18NKey() {
        return SUCCESS_STATUS_KEY;
    }

    protected String getTaskPartialSuccessStatusI18NKey() {
        return PARTIAL_SUCCESS_STATUS_KEY;
    }
}

