/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.ui.ant;

import com.sun.jbi.ui.ant.JbiTargetTask;
import com.sun.jbi.ui.common.JBIComponentInfo;
import com.sun.jbi.ui.common.ServiceAssemblyInfo;
import com.sun.jbi.ui.common.ServiceUnitInfo;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import org.apache.tools.ant.BuildException;

public abstract class JbiQueryTask
extends JbiTargetTask {
    protected static final int LIST_QUERY_RESULT_TYPE = 1;
    protected static final int SINGLE_QUERY_RESULT_TYPE = 2;
    protected static final String STARTED_STATE = "started";
    protected static final String STOPPED_STATE = "stopped";
    protected static final String SHUTDOWN_STATE = "shutdown";
    protected static final String UNKNOWN_STATE = "unknown";
    protected static final String ANY_STATE = "any";
    private static String sDisplayInstalledState = null;
    private static String sDisplayStartedState = null;
    private static String sDisplayStoppedState = null;
    private static String sDisplayShutdownState = null;
    private static String sDisplayUnknownState = null;
    private int mQueryResultType = 1;
    private String mXmlOutput = null;

    public JbiQueryTask() {
        this.initStateDisplayValues();
    }

    private void initStateDisplayValues() {
        if (sDisplayInstalledState == null) {
            sDisplayInstalledState = this.getI18NBundle().getMessage("jbi.ui.ant.print.state.installed");
        }
        if (sDisplayStartedState == null) {
            sDisplayStartedState = this.getI18NBundle().getMessage("jbi.ui.ant.print.state.started");
        }
        if (sDisplayStoppedState == null) {
            sDisplayStoppedState = this.getI18NBundle().getMessage("jbi.ui.ant.print.state.stopped");
        }
        if (sDisplayShutdownState == null) {
            sDisplayShutdownState = this.getI18NBundle().getMessage("jbi.ui.ant.print.state.shutdown");
        }
        if (sDisplayUnknownState == null) {
            sDisplayUnknownState = this.getI18NBundle().getMessage("jbi.ui.ant.print.state.unknown");
        }
    }

    public String getXmlOutput() {
        return this.mXmlOutput;
    }

    public void setXmlOutput(String xmlOutput) {
        this.mXmlOutput = xmlOutput;
    }

    protected int getQueryResultType() {
        return this.mQueryResultType;
    }

    protected void setListQueryResultType() {
        this.mQueryResultType = 1;
    }

    protected void setSingleQueryResultType() {
        this.mQueryResultType = 2;
    }

    protected abstract String getQueryResultHeaderI18NKey();

    protected abstract String getQueryResultHeaderSeparatorI18NKey();

    protected abstract String getQueryResultPageSeparatorI18NKey();

    protected abstract String getEmptyQueryResultI18NKey();

    protected abstract String getEmptyQueryResultI18NMessage();

    private String toComponentInfoStateDisplayValue(String stateValue, String compType) {
        String stateDisplay = sDisplayUnknownState;
        stateDisplay = STARTED_STATE.equalsIgnoreCase(stateValue) ? sDisplayStartedState : (STOPPED_STATE.equalsIgnoreCase(stateValue) ? sDisplayStoppedState : (SHUTDOWN_STATE.equalsIgnoreCase(stateValue) ? ("shared-library".equalsIgnoreCase(compType) ? sDisplayInstalledState : sDisplayShutdownState) : sDisplayUnknownState));
        return stateDisplay;
    }

    protected String toJbiComponentInfoState(String taskPropState) {
        String compInfoState = "Unknown";
        if (taskPropState == null || taskPropState.length() == 0) {
            return compInfoState;
        }
        if (STARTED_STATE.equalsIgnoreCase(taskPropState)) {
            compInfoState = "Started";
        } else if (STOPPED_STATE.equalsIgnoreCase(taskPropState)) {
            compInfoState = "Stopped";
        } else if (SHUTDOWN_STATE.equalsIgnoreCase(taskPropState)) {
            compInfoState = "Shutdown";
        }
        return compInfoState;
    }

    private String toServiceAssemblyInfoStateDisplayValue(String stateValue) {
        String stateDisplay = sDisplayUnknownState;
        stateDisplay = STARTED_STATE.equalsIgnoreCase(stateValue) ? sDisplayStartedState : (STOPPED_STATE.equalsIgnoreCase(stateValue) ? sDisplayStoppedState : (SHUTDOWN_STATE.equalsIgnoreCase(stateValue) ? sDisplayShutdownState : sDisplayUnknownState));
        return stateDisplay;
    }

    private String toServiceUnitInfoStateDisplayValue(String stateValue) {
        String stateDisplay = sDisplayUnknownState;
        stateDisplay = STARTED_STATE.equalsIgnoreCase(stateValue) ? sDisplayStartedState : (STOPPED_STATE.equalsIgnoreCase(stateValue) ? sDisplayStoppedState : (SHUTDOWN_STATE.equalsIgnoreCase(stateValue) ? sDisplayShutdownState : sDisplayUnknownState));
        return stateDisplay;
    }

    protected String toServiceAssemblyInfoState(String taskPropState) {
        String compInfoState = "Unknown";
        if (taskPropState == null || taskPropState.length() == 0) {
            return compInfoState;
        }
        if (STARTED_STATE.equalsIgnoreCase(taskPropState)) {
            compInfoState = "Started";
        } else if (STOPPED_STATE.equalsIgnoreCase(taskPropState)) {
            compInfoState = "Stopped";
        } else if (SHUTDOWN_STATE.equalsIgnoreCase(taskPropState)) {
            compInfoState = "Shutdown";
        }
        return compInfoState;
    }

    protected void validateTaskPropertyForStateValue(String state) throws BuildException {
        if (state == null || state.length() == 0) {
            return;
        }
        String stateValue = state;
        if (!(STARTED_STATE.equalsIgnoreCase(stateValue) || STOPPED_STATE.equalsIgnoreCase(stateValue) || SHUTDOWN_STATE.equalsIgnoreCase(stateValue))) {
            this.throwTaskBuildException("jbi.ui.ant.task.error.invalid.state", state);
        }
    }

    protected void initXmlOutput(String xmlText) {
        this.printResultsToXmlOutput(xmlText);
    }

    protected boolean printResultsToXmlOutput(String xmlResult) {
        String xmlOutputProp = this.getXmlOutput();
        if (xmlOutputProp != null) {
            this.getProject().setProperty(xmlOutputProp, xmlResult);
            return true;
        }
        return false;
    }

    protected void printComponentQueryResults(String aResult) {
        if (this.printResultsToXmlOutput(aResult)) {
            return;
        }
        String header = this.getI18NBundle().getMessage(this.getQueryResultHeaderI18NKey(), this.getValidTarget());
        String headerSeparator = this.getI18NBundle().getMessage(this.getQueryResultHeaderSeparatorI18NKey());
        String pageSeparator = this.getI18NBundle().getMessage(this.getQueryResultPageSeparatorI18NKey());
        String emptyResult = this.getEmptyQueryResultI18NMessage();
        List list = JBIComponentInfo.readFromXmlText(aResult);
        StringWriter stringWriter = new StringWriter();
        PrintWriter msgWriter = new PrintWriter(stringWriter);
        msgWriter.println(headerSeparator);
        msgWriter.println(header);
        msgWriter.println(headerSeparator);
        if (list.size() <= 0) {
            msgWriter.println(emptyResult);
            msgWriter.println(pageSeparator);
        } else {
            for (JBIComponentInfo info : list) {
                String status = this.getI18NBundle().getMessage("jbi.ui.ant.print.comp.info.state", this.toComponentInfoStateDisplayValue(info.getState(), info.getType()));
                String name = this.getI18NBundle().getMessage("jbi.ui.ant.print.comp.info.name", info.getName());
                String desc = this.getI18NBundle().getMessage("jbi.ui.ant.print.comp.info.desc", info.getDescription());
                msgWriter.println(name);
                msgWriter.println(status);
                msgWriter.println(desc);
                msgWriter.println(pageSeparator);
            }
        }
        msgWriter.close();
        this.printMessage(stringWriter.toString());
    }

    protected void printDeploymentQueryResults(String aResult) {
        if (this.printResultsToXmlOutput(aResult)) {
            return;
        }
        String header = this.getI18NBundle().getMessage(this.getQueryResultHeaderI18NKey(), this.getValidTarget());
        String headerSeparator = this.getI18NBundle().getMessage(this.getQueryResultHeaderSeparatorI18NKey());
        String pageSeparator = this.getI18NBundle().getMessage(this.getQueryResultPageSeparatorI18NKey());
        String emptyResult = this.getEmptyQueryResultI18NMessage();
        List list = ServiceAssemblyInfo.readFromXmlTextWithProlog(aResult);
        StringWriter stringWriter = new StringWriter();
        PrintWriter msgWriter = new PrintWriter(stringWriter);
        msgWriter.println(headerSeparator);
        msgWriter.println(header);
        msgWriter.println(headerSeparator);
        if (list.size() <= 0) {
            msgWriter.println(emptyResult);
            msgWriter.println(pageSeparator);
        } else {
            for (ServiceAssemblyInfo saInfo : list) {
                List suInfoList = saInfo.getServiceUnitInfoList();
                String saName = this.getI18NBundle().getMessage("jbi.ui.ant.print.sasm.info.name", saInfo.getName());
                String saState = this.getI18NBundle().getMessage("jbi.ui.ant.print.sasm.info.state", this.toServiceAssemblyInfoStateDisplayValue(saInfo.getState()));
                String saDesc = this.getI18NBundle().getMessage("jbi.ui.ant.print.sasm.info.desc", saInfo.getDescription());
                String suInfoListDesc = this.getI18NBundle().getMessage("jbi.ui.ant.print.sasm.info.sunit.list.size", Integer.toString(suInfoList.size()));
                msgWriter.println(saName);
                msgWriter.println(saState);
                msgWriter.println(saDesc);
                msgWriter.println(suInfoListDesc);
                for (ServiceUnitInfo suInfo : suInfoList) {
                    String suState = this.getI18NBundle().getMessage("jbi.ui.ant.print.sunit.info.state", this.toServiceUnitInfoStateDisplayValue(suInfo.getState()));
                    String deployedOn = this.getI18NBundle().getMessage("jbi.ui.ant.print.sunit.info.deployed.on", suInfo.getDeployedOn());
                    String suName = this.getI18NBundle().getMessage("jbi.ui.ant.print.sunit.info.name", suInfo.getName());
                    String suDesc = this.getI18NBundle().getMessage("jbi.ui.ant.print.sunit.info.desc", suInfo.getDescription());
                    msgWriter.println(suName);
                    msgWriter.println(suState);
                    msgWriter.println(deployedOn);
                    msgWriter.println(suDesc);
                }
                msgWriter.println(pageSeparator);
            }
        }
        msgWriter.close();
        this.printMessage(stringWriter.toString());
    }

    public static abstract class JbiComponentQueryTask
    extends JbiQueryTask {
        private String mState;
        private String mSharedLibraryName;
        private String mServiceAssemblyName;

        public String getState() {
            return this.mState;
        }

        public void setState(String state) {
            this.mState = state;
        }

        public String getSharedLibraryName() {
            return this.mSharedLibraryName;
        }

        public void setSharedLibraryName(String sharedLibraryName) {
            this.mSharedLibraryName = sharedLibraryName;
        }

        public String getServiceAssemblyName() {
            return this.mServiceAssemblyName;
        }

        public void setServiceAssemblyName(String serviceAssemblyName) {
            this.mServiceAssemblyName = serviceAssemblyName;
        }
    }
}

