/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.cms.core;

import com.sun.enterprise.ee.cms.core.GMSException;
import com.sun.enterprise.ee.cms.core.GMSNotEnabledException;
import com.sun.enterprise.ee.cms.core.GMSNotInitializedException;
import com.sun.enterprise.ee.cms.core.GroupManagementService;
import com.sun.enterprise.ee.cms.impl.common.GroupManagementServiceImpl;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;

public class GMSFactory {
    private static Hashtable<String, Runnable> groups = new Hashtable();
    private static Map<String, Boolean> gmsEnabledMap = new HashMap<String, Boolean>();
    private static String memberToken;

    private GMSFactory() {
    }

    public static Runnable startGMSModule(String serverToken, String groupName, GroupManagementService.MemberType memberType, Properties properties) {
        Runnable gms;
        gmsEnabledMap.put(groupName, Boolean.TRUE);
        try {
            gms = (Runnable)((Object)GMSFactory.getGMSModule(groupName));
        }
        catch (GMSException e) {
            gms = new GroupManagementServiceImpl(serverToken, groupName, memberType, properties);
            memberToken = serverToken;
            groups.put(GMSFactory.getCompositeKey(groupName), gms);
        }
        return gms;
    }

    public static GroupManagementService getGMSModule(String groupName) throws GMSNotEnabledException, GMSException, GMSNotInitializedException {
        if (groupName == null) {
            throw new GMSException("Group Name was not specified and cannot be null");
        }
        String key = GMSFactory.getCompositeKey(groupName);
        if (groups.containsKey(key)) {
            return (GroupManagementService)((Object)groups.get(key));
        }
        if (!GMSFactory.isGMSEnabled(groupName)) {
            throw new GMSNotEnabledException(new StringBuffer().append("Group Management Service is not ").append("enabled for group").append(groupName).toString());
        }
        throw new GMSNotInitializedException(new StringBuffer().append("Group Management Service is not ").append("initialized for group ").append(groupName).toString());
    }

    public static GroupManagementService getGMSModule() throws GMSException {
        Collection instances = GMSFactory.getAllGMSInstancesForMember();
        if (instances.size() == 0) {
            throw new GMSNotInitializedException(new StringBuffer().append("Group Management Service is not ").append("initialized for any group ").toString());
        }
        GroupManagementService gms = (GroupManagementService)instances.toArray()[0];
        return gms;
    }

    public static Collection getAllGMSInstancesForMember() {
        return groups.values();
    }

    private static String getCompositeKey(String groupName) {
        return memberToken + "::" + groupName;
    }

    public static boolean isGMSEnabled(String groupName) {
        Boolean val = gmsEnabledMap.get(groupName);
        return val != null && !val.equals(Boolean.FALSE);
    }

    public static void setGMSEnabledState(String groupName, Boolean value) {
        gmsEnabledMap.put(groupName, value);
    }

    public static void removeGMSModule(String groupName) {
        String key;
        if (groupName != null && groups.containsKey(key = GMSFactory.getCompositeKey(groupName))) {
            groups.remove(key);
        }
    }
}

