/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.cms.impl.common;

import com.sun.enterprise.ee.cms.core.FailureNotificationSignal;
import com.sun.enterprise.ee.cms.core.SignalAcquireException;
import com.sun.enterprise.ee.cms.core.SignalReleaseException;
import com.sun.enterprise.ee.cms.impl.common.GMSContext;
import com.sun.enterprise.ee.cms.impl.common.GMSContextFactory;
import com.sun.enterprise.ee.cms.logging.GMSLogDomain;
import java.io.Serializable;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FailureNotificationSignalImpl
implements FailureNotificationSignal {
    protected String failedMember = null;
    protected String groupName = null;
    protected static final String MEMBER_DETAILS = "MEMBERDETAILS";
    protected GMSContext ctx;
    protected static final Logger logger = GMSLogDomain.getLogger("ShoalLogger");
    protected long startTime;

    FailureNotificationSignalImpl() {
    }

    public FailureNotificationSignalImpl(String failedMember, String groupName, long startTime) {
        this.failedMember = failedMember;
        this.groupName = groupName;
        this.startTime = startTime;
        this.ctx = GMSContextFactory.getGMSContext(groupName);
    }

    FailureNotificationSignalImpl(FailureNotificationSignal signal) {
        this.failedMember = signal.getMemberToken();
        this.groupName = signal.getGroupName();
        this.startTime = signal.getStartTime();
        this.ctx = GMSContextFactory.getGMSContext(this.groupName);
    }

    @Override
    public void acquire() throws SignalAcquireException {
        logger.log(Level.FINE, "FailureNotificationSignal Acquired...");
    }

    @Override
    public void release() throws SignalReleaseException {
        this.failedMember = null;
        logger.log(Level.FINE, "FailureNotificationSignal Released...");
    }

    @Override
    public String getMemberToken() {
        return this.failedMember;
    }

    @Override
    public String getFailedMemberToken() {
        return this.failedMember;
    }

    @Override
    public Map<Serializable, Serializable> getMemberDetails() {
        return this.ctx.getDistributedStateCache().getFromCacheForPattern(MEMBER_DETAILS, this.failedMember);
    }

    @Override
    public String getGroupName() {
        return this.groupName;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }
}

