/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.html;

import com.sun.webui.jsf.component.Hyperlink;
import com.sun.webui.jsf.component.IconHyperlink;
import com.sun.webui.jsf.component.ImageComponent;
import com.sun.webui.jsf.component.ImageHyperlink;
import com.sun.webui.jsf.component.Tree;
import com.sun.webui.jsf.component.TreeNode;
import com.sun.webui.jsf.util.ComponentUtilities;
import com.sun.webui.jsf.util.JavaScriptUtilities;
import com.sun.webui.jsf.util.RenderingUtilities;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.theme.Theme;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.el.MethodExpression;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionListener;
import javax.faces.render.Renderer;

public class TreeNodeRenderer
extends Renderer {
    public void decode(FacesContext context, UIComponent component) {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (!component.isRendered()) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        TreeNode node = (TreeNode)component;
        Theme theme = ThemeUtilities.getTheme(context);
        Tree root = TreeNode.getAbsoluteRoot((UIComponent)node);
        boolean csFlag = root.isClientSide();
        writer.startElement("div", (UIComponent)node);
        writer.writeAttribute("id", (Object)node.getClientId(context), null);
        String nodeStyleClass = theme.getStyleClass("TREE_ROW");
        if (!node.isVisible()) {
            nodeStyleClass = theme.getStyleClass("HIDDEN");
        } else if (node.getStyleClass() != null) {
            nodeStyleClass = node.getStyleClass();
        }
        writer.writeAttribute("class", (Object)nodeStyleClass, null);
        if (node.getStyle() != null) {
            writer.writeAttribute("style", (Object)node.getStyle(), null);
        }
        Iterator imageIter = node.getImageKeys().iterator();
        IconHyperlink ihl = node.getTurnerImageHyperlink();
        ImageComponent imageFacet = null;
        if (ihl != null) {
            imageFacet = ihl.getImageFacet();
        }
        StringBuffer buff = new StringBuffer();
        buff.append(JavaScriptUtilities.getDomNode(context, (UIComponent)root)).append(".onTreeNodeClick(this, '");
        if (imageFacet != null) {
            buff.append(imageFacet.getClientId(context));
        } else {
            buff.append("null");
        }
        buff.append("', event);");
        writer.writeAttribute("onclick", (Object)buff.toString(), null);
        this.renderTreeRow(node, imageIter, context, writer);
        writer.endElement("div");
        List children = node.getChildren();
        if (node.isExpanded() || csFlag) {
            writer.startElement("div", (UIComponent)node);
            writer.writeAttribute("id", (Object)(node.getClientId(context) + "_children"), null);
            if (!node.isVisible()) {
                writer.writeAttribute("class", (Object)theme.getStyleClass("HIDDEN"), null);
            }
            if (!node.isExpanded()) {
                writer.writeAttribute("style", (Object)"display:none", null);
            }
            for (UIComponent comp : children) {
                if (!(comp instanceof TreeNode)) continue;
                RenderingUtilities.renderComponent(comp, context);
            }
            writer.endElement("div");
        }
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
    }

    protected void renderTreeRow(TreeNode node, Iterator imageIter, FacesContext context, ResponseWriter writer) throws IOException {
        Tree root = TreeNode.getAbsoluteRoot((UIComponent)node);
        Theme theme = ThemeUtilities.getTheme(context);
        writer.startElement("div", (UIComponent)node);
        String lineimagesID = node.getClientId(context) + "LineImages";
        writer.writeAttribute("id", (Object)lineimagesID, null);
        writer.writeAttribute("class", (Object)theme.getStyleClass("FLOAT"), null);
        boolean count = false;
        while (imageIter.hasNext()) {
            UIComponent imageComp = (UIComponent)imageIter.next();
            RenderingUtilities.renderComponent(imageComp, context);
        }
        UIComponent imageFacet = node.getFacet("image");
        if (imageFacet != null) {
            RenderingUtilities.renderComponent(imageFacet, context);
        } else {
            String imageURL = node.getImageURL();
            if (imageURL != null && imageURL.length() > 0) {
                ImageHyperlink ihl = node.getNodeImageHyperlink();
                this.renderImageOrText(node, ihl, context);
            }
        }
        writer.endElement("div");
        UIComponent contentFacet = node.getFacet("content");
        writer.startElement("div", (UIComponent)node);
        writer.writeAttribute("id", (Object)(node.getClientId(context) + "Text"), null);
        String textStyle = theme.getStyleClass("TREE_CONTENT") + " " + theme.getStyleClass("TREE_NODE_IMAGE_HEIGHT");
        writer.writeAttribute("class", (Object)textStyle, null);
        if (contentFacet != null) {
            RenderingUtilities.renderComponent(contentFacet, context);
        } else {
            boolean hasAction;
            String treeText = node.getText();
            String nodeURL = node.getUrl();
            boolean hasText = treeText != null && treeText.length() > 0;
            boolean hasURL = nodeURL != null && nodeURL.length() > 0;
            MethodExpression mex = node.getActionExpression();
            boolean bl = hasAction = mex != null;
            if (hasURL || hasAction) {
                Hyperlink link = node.getContentHyperlink();
                this.renderImageOrText(node, link, context);
            } else if (treeText != null && treeText.length() > 0) {
                writer.write(treeText);
            }
        }
        writer.endElement("div");
    }

    private void renderImageOrText(TreeNode node, Hyperlink link, FacesContext context) throws IOException {
        boolean hasAction;
        Tree root = TreeNode.getAbsoluteRoot((UIComponent)node);
        boolean csFlag = root.isClientSide();
        boolean esFlag = root.isExpandOnSelect();
        String nodeURL = node.getUrl();
        MethodExpression mex = node.getActionExpression();
        ActionListener[] nodeListeners = node.getActionListeners();
        boolean hasURL = nodeURL != null && nodeURL.length() > 0;
        boolean bl = hasAction = mex != null;
        if (hasURL || hasAction) {
            String jsObject = JavaScriptUtilities.getDomNode(context, (UIComponent)root);
            if (hasAction || nodeListeners != null && nodeListeners.length > 0) {
                link.setOnClick(jsObject + ".treecontent_submit('" + node.getClientId(context) + "');");
            } else if (esFlag) {
                IconHyperlink ihl = (IconHyperlink)ComponentUtilities.getPrivateFacet((UIComponent)node, "turner", true);
                ImageComponent iconImage = null;
                StringBuffer buff = new StringBuffer();
                buff.append(jsObject).append(".selectTreeNode(").append(jsObject).append(".findContainingTreeNode(this).id);").append(jsObject).append(".expandTurner(this, '");
                if (ihl != null) {
                    buff.append(ihl.getClientId(context));
                    iconImage = ihl.getImageFacet();
                } else {
                    buff.append("null");
                }
                buff.append("', '");
                if (iconImage != null) {
                    buff.append(iconImage.getClientId(context));
                } else {
                    buff.append("null");
                }
                buff.append("', ").append(csFlag).append(", event);");
                link.setOnClick(buff.toString());
            }
            RenderingUtilities.renderComponent((UIComponent)link, context);
        }
    }
}

