/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.jsf.bean;

import com.sun.jbi.jsf.util.ConnectionUtilities;
import com.sun.jbi.jsf.util.JBILogger;
import com.sun.jbi.ui.common.JBIAdminCommands;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.context.FacesContext;

public class JBIConfigBean {
    private static Logger sLog = JBILogger.getInstance();
    private static final String[][] EXTENSION_MANAGED_BEANS = new String[][]{{"ArchiveBean", "com.sun.jbi.jsf.bean.ArchiveBean"}, {"AlertBean", "com.sun.jbi.jsf.bean.AlertBean"}, {"ConfigurationBean", "com.sun.jbi.jsf.configuration.beans.ConfigurationBean"}, {"DeletionBean", "com.sun.jbi.jsf.bean.DeletionBean"}, {"InstallationBean", "com.sun.jbi.jsf.bean.InstallationBean"}, {"JBIComponentConfigBean", "com.sun.jbi.jsf.bean.JBIComponentConfigBean"}, {"ListBean", "com.sun.jbi.jsf.bean.ListBean"}, {"LoggingBean", "com.sun.jbi.jsf.bean.LoggingBean"}, {"OperationBean", "com.sun.jbi.jsf.bean.OperationBean"}, {"RuntimeConfigurationBean", "com.sun.jbi.jsf.bean.RuntimeConfigurationBean"}, {"ServiceUnitBean", "com.sun.jbi.jsf.bean.ServiceUnitBean"}, {"ShowBean", "com.sun.jbi.jsf.bean.ShowBean"}, {"StatisticsBean", "com.sun.jbi.jsf.statistics.StatisticsBean"}, {"TargetBean", "com.sun.jbi.jsf.bean.TargetBean"}, {"UploadCopyRadioBean", "com.sun.jbi.jsf.bean.UploadCopyRadioBean"}};
    private static final int INDEX_BEAN_NAME = 0;
    private static final int INDEX_CLASS_NAME = 1;
    private JBIAdminCommands mCachedClient;
    private boolean mIsJbiEnabled = false;

    public JBIConfigBean() {
        boolean isJbiRuntimeEnabled = false;
        try {
            boolean isExtensionInitialized;
            this.mCachedClient = new ConnectionUtilities().getClient();
            isJbiRuntimeEnabled = this.mCachedClient.isJBIRuntimeEnabled();
            sLog.fine("JBIConfigBean.<init>(): isJbiRuntimeEnabled=" + isJbiRuntimeEnabled + ", mCachedClient=" + this.mCachedClient);
            if (isJbiRuntimeEnabled && (isExtensionInitialized = this.initExtensionManagedBeans())) {
                this.mIsJbiEnabled = true;
            }
        }
        catch (Exception ex) {
            sLog.log(Level.FINE, "JBIConfigBean.isJbiEnabled() caught exception", ex);
        }
        sLog.fine("JBIConfigBean.<init>(): mIsJbiEnabled=" + this.mIsJbiEnabled);
    }

    public JBIAdminCommands getClient() {
        sLog.fine("JBIConfigBean.getClient() result=" + this.mCachedClient);
        return this.mCachedClient;
    }

    public boolean isJbiEnabled() {
        boolean result = this.mIsJbiEnabled;
        sLog.fine("JBIConfigBean.isJbiEnabled(): result=" + result);
        return result;
    }

    private boolean initExtensionManagedBeans() {
        boolean result = true;
        try {
            for (int i = 0; i < EXTENSION_MANAGED_BEANS.length; ++i) {
                String beanName = EXTENSION_MANAGED_BEANS[i][0];
                String className = EXTENSION_MANAGED_BEANS[i][1];
                Class<?> beanClass = Class.forName(className);
                Object bean = beanClass.newInstance();
                sLog.fine("JBIConfigBean.initExensionManagedBeans() beanName=" + beanName + ", className=" + className + ", bean=" + bean);
                FacesContext facesContext = FacesContext.getCurrentInstance();
                facesContext.getExternalContext().getSessionMap().put(beanName, bean);
            }
        }
        catch (Exception ex) {
            result = false;
            sLog.log(Level.FINE, "JBIConfigBean.initExtensionManagedBeans() caught Exception", ex);
        }
        sLog.fine("JBIConfigBean.initExensionManagedBeans() result=" + result);
        return result;
    }
}

