/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.jsf.configuration.beans;

import com.sun.jbi.jsf.configuration.xml.ConfigurationParser;
import com.sun.jbi.jsf.configuration.xml.model.Configuration;
import com.sun.jbi.jsf.configuration.xml.model.DisplayInformation;
import com.sun.jbi.jsf.configuration.xml.schema.SchemaInstanceParser;
import com.sun.jbi.jsf.framework.common.BaseBean;
import com.sun.jbi.jsf.framework.common.Util;
import com.sun.jbi.jsf.framework.common.resources.Messages;
import com.sun.jbi.jsf.framework.services.configuration.ConfigurationService;
import com.sun.jbi.jsf.framework.services.management.ManagementService;
import com.sun.jbi.jsf.util.JBILogger;
import com.sun.webui.jsf.component.Alert;
import com.sun.webui.jsf.component.Checkbox;
import com.sun.webui.jsf.component.DropDown;
import com.sun.webui.jsf.component.PasswordField;
import com.sun.webui.jsf.component.Property;
import com.sun.webui.jsf.component.PropertySheet;
import com.sun.webui.jsf.component.PropertySheetSection;
import com.sun.webui.jsf.component.TextField;
import com.sun.webui.jsf.model.Option;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.el.ELContext;
import javax.el.MethodExpression;
import javax.faces.application.Application;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.validator.ValidatorException;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.TabularData;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.SchemaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationBean
extends BaseBean
implements Serializable {
    private ConfigurationService configService = null;
    protected ManagementService managementService = null;
    private static String FIELD_VALUE_NAME = "propValue";
    private static String TABULAR_DATA_TYPE = "TabularData";
    private static String COMP_LIST = "compList";
    private static String LABEL_LIST = "labelList";
    private static int INVALID_VALUE = -1;
    private static String TARGET_LIST_KEY = "jbiConfigUpdateSelectedInstances";
    private static String INSTANCES_LIST_KEY = "instanceList";
    private static String SELECTED_INSTANCE_KEY = "jbiConfigViewSelectedInstance";
    private Option[] targetOptions = null;
    private String[] selectedTargetOptions = null;
    private PropertySheet propertySheet;
    private Map<String, Object> configData;
    private static String ALERT_TYPE_ERROR = "error";
    private static String ALERT_TYPE_SUCCESS = "success";
    private static String ALERT_TYPE_WARNING = "warning";
    private static String ALERT_TYPE_INFO = "info";
    private transient String alertMessage = null;
    private transient boolean renderAlertMessage = false;
    private transient boolean mSaveButtonDisabled = false;
    private transient String alertType = null;
    private transient String alertSummary;
    protected String serviceUnitName;
    private String schema = null;
    private String xmlData = null;
    private String[] attrNames = null;
    transient Map<String, UIInput> webUIMap = new HashMap<String, UIInput>();
    private transient Map<String, DisplayInformation> displayMap = new HashMap<String, DisplayInformation>();
    private transient Map<String, DisplayInformation> labelDisplayMap = new HashMap<String, DisplayInformation>();
    transient Map<String, SchemaType> coreTypeMap = new HashMap<String, SchemaType>();
    private static String STRING_TYPE = "STRING";
    private static String BOOLEAN_TYPE = "BOOLEAN";
    private static String NUMBER_TYPE = "NUMBER";
    private static String PASSWORD_TYPE = "PASSWORD";
    private static Logger sLog = JBILogger.getInstance();
    private Alert alert = new Alert();
    private String mAlertMessage = "";

    private void setBooleanProperty(Map.Entry prop, Boolean value) {
        prop.setValue(value);
    }

    private void setTextProperty(Map.Entry prop, String value) {
        prop.setValue(value);
    }

    private void setProperty(Map.Entry prop, Object value) {
        prop.setValue(value);
    }

    private Map findValues(Map map, String key) {
        Map m = null;
        for (Map.Entry entry : map.entrySet()) {
            String ekey = (String)entry.getKey();
            Map m1 = (Map)entry.getValue();
            if (!ekey.equalsIgnoreCase(key)) continue;
            m = m1;
            break;
        }
        return m;
    }

    private Object findValue(Map map, String key) {
        Object value = null;
        for (Map.Entry entry : map.entrySet()) {
            String ekey = (String)entry.getKey();
            Map m1 = (Map)entry.getValue();
            value = m1.get(key);
            if (value == null) continue;
            break;
        }
        return value;
    }

    public String reset() {
        sLog.fine("reset called...");
        this.alertMessage = null;
        this.schema = null;
        this.xmlData = null;
        this.attrNames = null;
        this.configData = null;
        this.targetOptions = null;
        this.selectedTargetOptions = null;
        this.mSaveButtonDisabled = false;
        return "success";
    }

    public String getLabel() {
        String label = "";
        if ("binding-component".equals(this.componentType)) {
            label = Messages.getString("jbi.configuration.bc.label");
        } else if ("service-engine".equals(this.componentType)) {
            label = Messages.getString("jbi.configuration.se.label");
        }
        return label;
    }

    public String getTitle() {
        return this.getTitle("jbi.configuration.title");
    }

    private List createConfigProperties(Map<String, Object> props, List propertyList) {
        sLog.fine("createConfigProperties...");
        int id = 0;
        for (Map.Entry<String, Object> entry : props.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            UIComponent component = null;
            if (value instanceof Boolean) {
                component = this.createBooleanProperty(id, value.toString());
            } else if (value instanceof TabularData) {
                Map map = this.createTabularDataProperty(id, (TabularData)value);
                List propList = this.createPropertySheetSection(key, id);
                List compList = (List)map.get(COMP_LIST);
                List labelList = (List)map.get(LABEL_LIST);
                if (compList != null) {
                    propList.addAll(this.createProperties(id, compList, labelList));
                    id += compList.size();
                }
            } else {
                component = this.createStringProperty(id, key, value.toString(), null);
            }
            if (component == null) continue;
            propertyList.add(this.createProperty(id, key, component));
            ++id;
        }
        sLog.fine("propertyList: " + propertyList);
        return propertyList;
    }

    private Property createProperty(int id, String label, UIComponent comp) {
        Property property = new Property();
        property.setId("property" + id);
        property.setLabel(label);
        property.getChildren().add(comp);
        return property;
    }

    private List createProperties(int id, List compList, List labelList) {
        ArrayList<Property> propList = new ArrayList<Property>();
        Iterator iter2 = labelList.iterator();
        for (UIComponent comp : compList) {
            String label = (String)iter2.next();
            Property property = this.createProperty(id, label, comp);
            propList.add(property);
            ++id;
        }
        return propList;
    }

    private void setTabularDataProperty(TabularData tabularData, Map propValues) {
        Iterator iter2 = propValues.entrySet().iterator();
        ArrayList<CompositeDataSupport> cList = new ArrayList<CompositeDataSupport>();
        for (CompositeData compData : tabularData.values()) {
            CompositeType compType = compData.getCompositeType();
            String name = null;
            String value = null;
            Iterator<String> itemIt = compType.keySet().iterator();
            while (itemIt.hasNext()) {
                String keyName = itemIt.next();
                String keyValue = itemIt.next();
                name = (String)compData.get(keyName);
                value = (String)compData.get(keyValue);
                Map.Entry entry = iter2.next();
                String pKey = (String)entry.getKey();
                Object pVal = entry.getValue();
                String[] itemNames = compType.keySet().toArray(new String[1]);
                Object[] itemValues = new Object[]{name, pVal};
                try {
                    CompositeDataSupport compDataSupport = new CompositeDataSupport(compType, itemNames, itemValues);
                    cList.add(compDataSupport);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        tabularData.clear();
        for (CompositeDataSupport compDataSupport : cList) {
            tabularData.put(compDataSupport);
        }
    }

    private Map createTabularDataProperty(int id, TabularData tabularData) {
        sLog.fine("createTabularDataProperty...");
        HashMap map = new HashMap();
        ArrayList<UIComponent> compList = new ArrayList<UIComponent>();
        ArrayList<String> labelList = new ArrayList<String>();
        for (CompositeData compData : tabularData.values()) {
            CompositeType compType = compData.getCompositeType();
            compType.keySet().iterator();
            sLog.fine("compData:" + compData);
            sLog.fine("compType: " + compType);
            sLog.fine("compType.keySet: " + compType.keySet());
            String name = null;
            String type = null;
            String value = null;
            UIComponent component = null;
            int itemCount = compType.keySet().size();
            Iterator<String> itemIt = compType.keySet().iterator();
            while (itemIt.hasNext()) {
                String keyName = itemIt.next();
                String keyType = null;
                if (itemCount > 2) {
                    keyType = itemIt.next();
                    type = (String)compData.get(keyName);
                }
                String keyValue = itemIt.next();
                name = (String)compData.get(keyName);
                value = (String)compData.get(keyValue);
                component = this.createProperty(id, name, value, type);
                compList.add(component);
                labelList.add(name);
                ++id;
            }
        }
        map.put(COMP_LIST, compList);
        map.put(LABEL_LIST, labelList);
        return map;
    }

    private UIComponent createProperty(int id, String label, String value, String type) {
        UIComponent component = null;
        component = PASSWORD_TYPE.equals(type) ? this.createStringProperty(id, label, value, type) : (BOOLEAN_TYPE.equals(type) ? this.createBooleanProperty(id, value) : (NUMBER_TYPE.equals(type) ? this.createStringProperty(id, label, value, null) : this.createStringProperty(id, label, value, null)));
        return component;
    }

    private UIComponent createBooleanProperty(int id, String value) {
        Checkbox checkbox = new Checkbox();
        checkbox.setId("propb" + id);
        checkbox.setValue((Object)value);
        checkbox.setLabel(" ");
        return checkbox;
    }

    private UIComponent createStringProperty(int id, String label, String value, String type) {
        if (label.indexOf("password") != -1 || label.indexOf("Password") != -1 || PASSWORD_TYPE.equalsIgnoreCase(type)) {
            PasswordField password = new PasswordField();
            password.setId("prop" + id);
            password.setText((Object)value);
            password.setColumns(60);
            return password;
        }
        TextField text = new TextField();
        text.setId("prop" + id);
        text.setText((Object)value);
        text.setColumns(60);
        return text;
    }

    private ConfigurationService getConfigurationService(String targetName) {
        ConfigurationService configService = null;
        configService = this.serviceManager.getConfigurationService(targetName);
        return configService;
    }

    protected ManagementService getManagementService(String targetName) {
        ManagementService managementService = null;
        managementService = this.serviceManager.getManagementService(targetName);
        return managementService;
    }

    private Map<String, Object> getConfigData() {
        sLog.fine("getConfigData...");
        this.configService = this.getConfigurationService(this.tName);
        this.managementService = this.getManagementService(this.tName);
        String name = Util.mapComponentValue(this.cName, this.componentName);
        String type = Util.mapComponentValue(this.cType, this.componentType);
        String state = this.managementService.getState(name, type);
        if ("Shutdown".equalsIgnoreCase(state)) {
            this.mSaveButtonDisabled = true;
            this.displayStatusAlertMessage();
        } else {
            if (this.componentType.equals("service-unit")) {
                String suid = this.pName + "-" + this.cName;
                this.configData = this.configService.getSUConfigurationProperties(name, type, suid);
            } else {
                this.configData = this.configService.getConfigurationProperties(name, type);
            }
            sLog.fine("configData=" + this.configData);
            this.schema = this.configService.getSchema(name, type);
            this.xmlData = this.configService.getXmlData(name, type);
            this.attrNames = this.configService.getAttributeNames(name, type);
        }
        return this.configData;
    }

    private List createPropertySheetSection(String propertySheetSectionName, int id) {
        PropertySheetSection propertySheetSection = new PropertySheetSection();
        propertySheetSection.setId(TABULAR_DATA_TYPE + id);
        propertySheetSection.setLabel(propertySheetSectionName);
        this.propertySheet.getChildren().add(propertySheetSection);
        return propertySheetSection.getChildren();
    }

    public void setRenderAlertOff() {
        this.renderAlertMessage = false;
    }

    public PropertySheet getPropertySheet() {
        sLog.fine("getPropertySheet...");
        this.setup();
        this.reset();
        this.propertySheet = new PropertySheet();
        this.propertySheet.setId("propertySheet");
        List propertySectionList = this.propertySheet.getChildren();
        PropertySheetSection propertySheetSection = new PropertySheetSection();
        propertySheetSection.setId("propertySheetSection");
        propertySheetSection.setLabel(Messages.getString("jbi.configuration.propertysection.runtime.configuration"));
        propertySectionList.add(propertySheetSection);
        List propertyList = propertySheetSection.getChildren();
        this.configData = this.getConfigData();
        if (this.configData != null) {
            if (this.schema != null) {
                this.createConfigPropertiesValidation(this.configData, propertyList);
            } else {
                this.createConfigProperties(this.configData, propertyList);
            }
        }
        return this.propertySheet;
    }

    public void setPropertySheet(PropertySheet propSheet) {
        this.propertySheet = propSheet;
    }

    public String getLabelSave() {
        return Messages.getString("jbi.configuration.label.save");
    }

    public String getLabelReset() {
        return Messages.getString("jbi.configuration.label.reset");
    }

    public String getHelpInline() {
        return Messages.getString("jbi.configuration.helpInline");
    }

    public Alert getConfigurationAlert() {
        this.alert.setId("configure-alert");
        this.alert.setType("success");
        this.alert.setDetail(this.getAlertMessage());
        this.alert.setSummary(this.getAlertSummary());
        this.alert.setRendered(this.getAlertMessageRendered());
        this.renderAlertMessage = false;
        this.setAlertMessage("");
        return this.alert;
    }

    public void setConfigurationAlert(Alert aAlert) {
        this.renderAlertMessage = false;
        this.alert = aAlert;
        this.mAlertMessage = "";
    }

    private void setConfigurationAlert() {
        this.alert.setId("configure-alert");
        this.alert.setType(this.getAlertMessage());
        this.alert.setDetail(this.getAlertMessage());
        this.alert.setSummary(this.getAlertSummary());
        this.alert.setRendered(true);
    }

    public String getAlertMessage() {
        return this.alertMessage;
    }

    public void setAlertMessage(String msg) {
        this.alertMessage = msg;
    }

    public boolean getAlertMessageRendered() {
        return this.renderAlertMessage;
    }

    public void setRenderAlertMessage(boolean value) {
        this.renderAlertMessage = value;
    }

    public String getAlertSummary() {
        return this.alertSummary;
    }

    public void setAlertSummary(String summary) {
        this.alertSummary = summary;
    }

    public String getAlertType() {
        return this.alertType;
    }

    public void setAlertType(String type) {
        this.alertType = type;
    }

    public boolean getRenderButtons() {
        return this.configData != null && !this.configData.isEmpty();
    }

    private void resetAlerts() {
        this.alertMessage = null;
        this.renderAlertMessage = false;
        this.setAlertType(ALERT_TYPE_ERROR);
        this.setAlertSummary(Messages.getString("jbi.configuration.alert"));
    }

    private List createConfigPropertiesValidation(Map<String, Object> props, List propertyList) {
        Application application = FacesContext.getCurrentInstance().getApplication();
        this.initialize(application, this.attrNames, new String[]{this.schema}, this.xmlData, this.configData);
        int id = 0;
        for (Map.Entry<String, Object> entry : props.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            UIComponent component = null;
            if (value instanceof TabularData) {
                Map map = this.createTabularDataProperty(id, (TabularData)value);
                List propList = this.createPropertySheetSection(key, id);
                List compList = (List)map.get(COMP_LIST);
                List labelList = (List)map.get(LABEL_LIST);
                if (compList != null) {
                    propList.addAll(this.createProperties(id, compList, labelList));
                    id += compList.size();
                }
            } else {
                component = (UIComponent)this.webUIMap.get(key);
                if (component != null) {
                    DisplayInformation display = this.displayMap.get(key);
                    key = display.getDisplayName();
                }
            }
            if (component == null) continue;
            if (key != null) {
                propertyList.add(this.createProperty(id, key, component));
            }
            ++id;
        }
        return propertyList;
    }

    private Option getOptionFromValue(String value, Option[] options) {
        Option returnValue = null;
        if (value != null && options != null && options.length > 0) {
            for (int index = 0; index < options.length; ++index) {
                if (!value.equals(options[index].getValue())) continue;
                returnValue = options[index];
                break;
            }
        }
        if (value == null && options != null && options.length > 0) {
            returnValue = options[0];
        }
        return returnValue;
    }

    private Configuration parseConfigurationXML(String[] attributeNames, String actualXMLConfigData) {
        Configuration componentConfiguration = null;
        try {
            ConfigurationParser parser = ConfigurationParser.parseFromString(actualXMLConfigData, attributeNames);
            componentConfiguration = parser.getComponentConfiguration();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return componentConfiguration;
    }

    public void validateEnumeratedString(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        FacesMessage msg = null;
        String localPart = component.getId();
        if (value != null) {
            String[] enumeratedValues;
            int index;
            SchemaType coreType = this.coreTypeMap.get(localPart);
            SchemaType baseType = null;
            baseType = !coreType.isPrimitiveType() ? coreType.getBaseType() : coreType;
            if (coreType != null && baseType != null && baseType.getBuiltinTypeCode() == 12 && (index = this.findStringInArray((String)value, enumeratedValues = SchemaInstanceParser.getEnumeratedStringValues(coreType))) == INVALID_VALUE) {
                String msgString = Messages.getString("jbi.configuration.msgInvalidString");
                msg = new FacesMessage(msgString);
                msg.setSeverity(FacesMessage.SEVERITY_ERROR);
                this.alertMessage = msgString;
                this.renderAlertMessage = true;
                this.displayValidationAlertMessage(this.alertMessage);
                throw new ValidatorException(msg);
            }
        } else {
            String msgString = Messages.getString("jbi.configuration.msgNullString");
            msg = new FacesMessage(msgString);
            msg.setSeverity(FacesMessage.SEVERITY_ERROR);
            this.alertMessage = msgString;
            this.renderAlertMessage = true;
            this.displayValidationAlertMessage(this.alertMessage);
            throw new ValidatorException(msg);
        }
        if (this.alertMessage == null || !this.renderAlertMessage) {
            this.resetAlerts();
        }
    }

    private int findStringInArray(String stringObject, String[] stringArray) {
        int returnValue = INVALID_VALUE;
        if (stringObject != null && stringArray != null && stringArray.length > 0) {
            for (int index = 0; index < stringArray.length; ++index) {
                if (!stringObject.equals(stringArray[index])) continue;
                returnValue = index;
                break;
            }
        }
        return returnValue;
    }

    void initialize(Application application, String[] attributeNames, String[] actualSchemas, String actualXMLConfigData, Map<String, Object> configurationData) {
        SchemaInstanceParser parser = null;
        boolean allowNetworkDownloadsFlag = false;
        boolean disableParticleValidRestrictionFlag = false;
        boolean diableUniqueParticleAttributionFlag = false;
        if (actualSchemas != null) {
            parser = new SchemaInstanceParser(actualSchemas, allowNetworkDownloadsFlag, disableParticleValidRestrictionFlag, diableUniqueParticleAttributionFlag);
        }
        SchemaType[] types = parser.getGlobalElements();
        this.initialize(application, attributeNames, types[0], actualXMLConfigData, configurationData);
    }

    void initialize(Application application, String[] attributeNames, SchemaType root, String actualXMLConfigData, Map<String, Object> configurationData) {
        Configuration componentConfiguration = this.parseConfigurationXML(attributeNames, actualXMLConfigData);
        DisplayInformation display = null;
        if (componentConfiguration != null) {
            this.displayMap = componentConfiguration.getDisplayDetailsMap();
            this.labelDisplayMap = componentConfiguration.getLabelDisplayDetailsMap();
        }
        QName qName = null;
        String prefix = root.getDocumentElementName().getPrefix();
        String namespaceURI = root.getDocumentElementName().getNamespaceURI();
        SchemaType coreType = null;
        SchemaType baseType = null;
        Object enumValues = null;
        for (int count = 0; count < attributeNames.length; ++count) {
            Object objectValue;
            Integer integer;
            TextField input;
            String value;
            qName = new QName(namespaceURI, attributeNames[count], prefix);
            coreType = SchemaInstanceParser.getCoreType(qName, root);
            if (coreType == null) {
                coreType = root;
            }
            baseType = !coreType.isPrimitiveType() ? coreType.getBaseType() : coreType;
            if (qName != null && coreType != null) {
                this.coreTypeMap.put(attributeNames[count], coreType);
                if (this.displayMap != null) {
                    display = this.displayMap.get(attributeNames[count]);
                }
            }
            if (baseType == null) continue;
            if (baseType.getBuiltinTypeCode() == 3) {
                Checkbox input2 = new Checkbox();
                input2.setId(attributeNames[count]);
                if (display != null) {
                    input2.setToolTip(display.getDisplayDescription());
                    String value2 = configurationData.get(attributeNames[count]) + "";
                    input2.setValue((Object)value2);
                }
                input2.setStyle("margin-top:10px;margin-bottom:10px;vertical-align:middle");
                this.webUIMap.put(attributeNames[count], (UIInput)input2);
            }
            if (baseType.getBuiltinTypeCode() == 12) {
                String[] enumeratedValues = SchemaInstanceParser.getEnumeratedStringValues(coreType);
                if (enumeratedValues != null && enumeratedValues.length > 0) {
                    Option[] options = new Option[enumeratedValues.length];
                    for (int index = 0; index < enumeratedValues.length; ++index) {
                        options[index] = new Option((Object)enumeratedValues[index], enumeratedValues[index]);
                    }
                    DropDown input3 = new DropDown();
                    input3.setId(attributeNames[count]);
                    input3.setDisabled(false);
                    input3.setSelected((Object)options[0]);
                    FacesContext facesContext = FacesContext.getCurrentInstance();
                    ELContext elcontext = facesContext.getELContext();
                    MethodExpression methodExpression = facesContext.getApplication().getExpressionFactory().createMethodExpression(elcontext, "#{ConfigurationBean.validateEnumeratedString}", null, new Class[]{FacesContext.class, UIComponent.class, Object.class});
                    input3.setValidatorExpression(methodExpression);
                    input3.setItems((Object)options);
                    if (display != null) {
                        input3.setToolTip(display.getDisplayDescription());
                        value = (String)configurationData.get(attributeNames[count]);
                        Option option = this.getOptionFromValue(value, options);
                        input3.resetValue();
                        input3.setSelected((Object)option);
                        input3.setValue((Object)value);
                    }
                    this.webUIMap.put(attributeNames[count], (UIInput)input3);
                } else if (display != null) {
                    PasswordField input4;
                    if (display.isPasswordField()) {
                        input4 = new PasswordField();
                        input4.setId(attributeNames[count]);
                        input4.setDisabled(false);
                        if (display != null) {
                            input4.setToolTip(display.getDisplayDescription());
                            String value3 = (String)configurationData.get(attributeNames[count]);
                            input4.setText((Object)value3);
                        }
                        input4.setColumns(60);
                        this.webUIMap.put(attributeNames[count], (UIInput)input4);
                    } else {
                        input4 = new TextField();
                        input4.setId(attributeNames[count]);
                        input4.setDisabled(false);
                        if (display != null) {
                            input4.setToolTip(display.getDisplayDescription());
                            String value4 = (String)configurationData.get(attributeNames[count]);
                            input4.setText((Object)value4);
                        }
                        input4.setColumns(60);
                        this.webUIMap.put(attributeNames[count], (UIInput)input4);
                    }
                }
            }
            if (baseType.getBuiltinTypeCode() != 30 && baseType.getBuiltinTypeCode() != 24 && baseType.getBuiltinTypeCode() != 29 && baseType.getBuiltinTypeCode() != 22) continue;
            int totalDigits = 0;
            int minInclusive = 0;
            int maxInclusive = 0;
            totalDigits = SchemaInstanceParser.getDecimalFacet(coreType, 7);
            minInclusive = SchemaInstanceParser.getDecimalFacet(coreType, 4);
            maxInclusive = SchemaInstanceParser.getDecimalFacet(coreType, 5);
            if (totalDigits != INVALID_VALUE || minInclusive != INVALID_VALUE || maxInclusive != INVALID_VALUE) {
                input = new TextField();
                input.setId(attributeNames[count]);
                input.setDisabled(false);
                if (display != null) {
                    input.setToolTip(display.getDisplayDescription());
                    integer = null;
                    objectValue = null;
                    try {
                        objectValue = configurationData.get(attributeNames[count]);
                        if (objectValue != null && objectValue instanceof Integer) {
                            integer = (Integer)objectValue;
                            input.setText((Object)integer.toString());
                        }
                    }
                    catch (NumberFormatException e) {
                        sLog.fine(Messages.getString("jbi.configuration.msgInvalidXmlData") + attributeNames[count] + " " + Messages.getString("jbi.configuration.msgInvalidXmlData2") + objectValue);
                    }
                }
                FacesContext facesContext = FacesContext.getCurrentInstance();
                ELContext elcontext = facesContext.getELContext();
                MethodExpression methodExpression = facesContext.getApplication().getExpressionFactory().createMethodExpression(elcontext, "#{ConfigurationBean.validateInteger}", null, new Class[]{FacesContext.class, UIComponent.class, Object.class});
                input.setValidatorExpression(methodExpression);
                input.setColumns(60);
                this.webUIMap.put(attributeNames[count], (UIInput)input);
                continue;
            }
            input = new TextField();
            input.setId(attributeNames[count]);
            input.setDisabled(false);
            if (display != null) {
                input.setToolTip(display.getDisplayDescription());
                integer = null;
                objectValue = null;
                objectValue = configurationData.get(qName.getLocalPart());
                value = objectValue + "";
                input.setText((Object)value);
            }
            input.setColumns(60);
            this.webUIMap.put(attributeNames[count], (UIInput)input);
        }
    }

    public void validateInteger(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        String msgString = null;
        FacesMessage msg = null;
        String localPart = component.getId();
        if (value != null) {
            SchemaType coreType = this.coreTypeMap.get(localPart);
            SchemaType baseType = null;
            baseType = !coreType.isPrimitiveType() ? coreType.getBaseType() : coreType;
            if (coreType != null && baseType != null && baseType.getBuiltinTypeCode() == 30 || baseType.getBuiltinTypeCode() == 24 || baseType.getBuiltinTypeCode() == 29 || baseType.getBuiltinTypeCode() == 22) {
                int totalDigits = 0;
                int minInclusive = 0;
                int maxInclusive = 0;
                totalDigits = SchemaInstanceParser.getDecimalFacet(coreType, 7);
                minInclusive = SchemaInstanceParser.getDecimalFacet(coreType, 4);
                maxInclusive = SchemaInstanceParser.getDecimalFacet(coreType, 5);
                String stringObject = (String)value;
                Integer integer = null;
                try {
                    integer = Integer.valueOf(stringObject);
                }
                catch (NumberFormatException e) {
                    msgString = value + Messages.getString("jbi.configuration.msgNotNumber");
                    msg = new FacesMessage(msgString);
                    msg.setSeverity(FacesMessage.SEVERITY_ERROR);
                    this.alertMessage = msgString;
                    this.renderAlertMessage = true;
                    this.displayValidationAlertMessage(this.alertMessage);
                    throw new ValidatorException(msg);
                }
                if (totalDigits != INVALID_VALUE && integer.toString().length() > totalDigits) {
                    msgString = integer.toString() + Messages.getString("jbi.configuration.msgValueExceedMax") + totalDigits;
                }
                int positiveInteger = integer;
                if (minInclusive != INVALID_VALUE && positiveInteger < minInclusive) {
                    msgString = integer.toString() + Messages.getString("jbi.configuration.msgMinValueAllowed") + minInclusive;
                }
                if (maxInclusive != INVALID_VALUE && positiveInteger > maxInclusive) {
                    msgString = integer.toString() + Messages.getString("jbi.configuration.msgMaxValueAllowed") + maxInclusive;
                }
                if (msgString != null) {
                    msg = new FacesMessage(msgString);
                    msg.setSeverity(FacesMessage.SEVERITY_ERROR);
                    this.alertMessage = msgString;
                    this.renderAlertMessage = true;
                    this.displayValidationAlertMessage(this.alertMessage);
                    throw new ValidatorException(msg);
                }
            }
        } else {
            msgString = Messages.getString("jbi.configuration.msgIntegerNull");
            msg = new FacesMessage(msgString);
            msg.setSeverity(FacesMessage.SEVERITY_ERROR);
            this.alertMessage = msgString;
            this.renderAlertMessage = true;
            this.displayValidationAlertMessage(this.alertMessage);
            throw new ValidatorException(msg);
        }
        if (this.alertMessage == null || !this.renderAlertMessage) {
            this.resetAlerts();
        }
    }

    public String save(String[] targets) {
        sLog.fine("save to targets...");
        if (this.alertMessage != null && this.renderAlertMessage) {
            this.resetAlerts();
            return null;
        }
        if (targets == null || targets.length == 0) {
            sLog.fine("No targets specified.");
            return null;
        }
        this.saveConfigData();
        for (int i = 0; i < targets.length; ++i) {
            sLog.fine("saving to target: " + targets[i]);
            ConfigurationService service = this.getConfigurationService(targets[i]);
            this.saveConfigService(service);
        }
        this.displaySavedAlertMessage();
        return "success";
    }

    public boolean getSaveButtonDisabled() {
        return this.mSaveButtonDisabled;
    }

    public void setSaveButtonDisabled(boolean mState) {
        this.mSaveButtonDisabled = mState;
    }

    private void displayAlertMessage(String type, String summary, String msg) {
        this.setAlertType(type);
        this.setAlertSummary(summary);
        this.setRenderAlertMessage(true);
        this.mAlertMessage = this.mAlertMessage.length() > 0 ? this.mAlertMessage + "<br>" + msg : msg;
        this.setAlertMessage(this.mAlertMessage);
        this.setConfigurationAlert();
    }

    private void displayValidationAlertMessage(String msg) {
        this.displayAlertMessage(ALERT_TYPE_ERROR, Messages.getString("jbi.configuration.alert.validation"), msg);
    }

    private void displayStatusAlertMessage() {
        this.displayAlertMessage(ALERT_TYPE_ERROR, Messages.getString("jbi.configuration.alert"), Messages.getString("jbi.configuration.msgComponentDown"));
    }

    private void displaySavedAlertMessage() {
        this.displayAlertMessage(ALERT_TYPE_SUCCESS, Messages.getString("jbi.configuration.alert.save.success"), "");
    }

    public String save() {
        sLog.fine("save...");
        if (this.alertMessage != null && this.renderAlertMessage) {
            this.resetAlerts();
            return null;
        }
        this.saveConfigData();
        this.saveConfigService(this.configService);
        this.displaySavedAlertMessage();
        return "success";
    }

    public void saveConfigData() {
        HashMap map = new HashMap();
        if (this.propertySheet != null) {
            List propSheetSectionList = this.propertySheet.getChildren();
            for (PropertySheetSection propSheetSection : propSheetSectionList) {
                LinkedHashMap<String, Object> pmap = new LinkedHashMap<String, Object>();
                map.put(propSheetSection.getLabel(), pmap);
                List propList = propSheetSection.getChildren();
                for (Property property : propList) {
                    String name = property.getLabel();
                    DisplayInformation info = null;
                    if (name != null) {
                        info = this.labelDisplayMap.get(name);
                    }
                    if (info != null) {
                        name = info.getAttributeName();
                    }
                    for (UIInput comp : property.getChildren()) {
                        Object value = comp.getValue();
                        pmap.put(name, value);
                    }
                }
            }
        }
        if (this.configData != null) {
            for (Map.Entry<String, Object> prop : this.configData.entrySet()) {
                String propKey = prop.getKey();
                Object propValue = prop.getValue();
                Object value = null;
                if (propValue instanceof Boolean) {
                    value = this.findValue(map, propKey);
                } else if (propValue instanceof TabularData) {
                    Map m = this.findValues(map, propKey);
                    if (m != null) {
                        this.setTabularDataProperty((TabularData)propValue, m);
                    }
                } else {
                    value = this.findValue(map, propKey);
                }
                if (value == null) continue;
                prop.setValue(value);
            }
        }
    }

    public void saveConfigService(ConfigurationService configService) {
        if (this.configData != null) {
            sLog.fine("updating config service...");
            String name = Util.mapComponentValue(this.cName, this.componentName);
            String type = Util.mapComponentValue(this.cType, this.componentType);
            configService.setConfigurationProperties(name, type, this.configData);
        }
    }

    public String saveConfigs() {
        sLog.fine("saveConfigs....");
        String[] targets = this.selectedTargetOptions;
        this.save(targets);
        return "";
    }

    public Option[] getTargetOptions() {
        Option[] targetOptions = (Option[])this.getParameter(INSTANCES_LIST_KEY);
        sLog.fine("targetOptions: " + targetOptions);
        return targetOptions;
    }

    public void setTargetOptions(Option[] options) {
        sLog.fine("setting target options: " + options);
        this.targetOptions = options;
    }

    public void setSelectedTargetOptions(String[] selections) {
        sLog.fine("selections: " + selections);
        this.selectedTargetOptions = selections;
    }

    public String[] getSelectedTargetOptions() {
        if (this.selectedTargetOptions == null) {
            this.selectedTargetOptions = new String[]{(String)this.getParameter(SELECTED_INSTANCE_KEY)};
        }
        sLog.fine("get selections: " + this.selectedTargetOptions);
        return this.selectedTargetOptions;
    }

    public void setParameterValue(String aKey, String aValue) {
        this.setParameter(aKey, aValue);
    }
}

