/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.jsf.framework.services.management.providers;

import com.sun.jbi.jsf.framework.common.Util;
import com.sun.jbi.jsf.framework.connectors.ServerConnector;
import com.sun.jbi.jsf.framework.services.BaseServiceProvider;
import com.sun.jbi.jsf.framework.services.management.ManagementService;
import java.io.Serializable;
import java.util.logging.Logger;
import javax.management.ObjectName;

public class SunManagementService
extends BaseServiceProvider
implements Serializable,
ManagementService {
    private static final String DOMAIN_NAME_PREFIX = "com.sun.jbi:";
    private static final String DOMAIN_NAME_SUFFIX = "JbiName=";
    private static final String CONTROL_TYPE_PREFIX = "ControlType=Lifecycle";
    private static final String INSTALLED_TYPE_PREFIX = "InstalledType=";
    private static final String COMPONENT_TYPE_PREFIX = "ComponentType=Installed";
    private static final String COMPONENT_NAME_PREFIX = "ComponentName=";
    private static final String ADMIN_SERVICE_OBJECTNAME = "com.sun.jbi:ServiceName=JbiReferenceAdminUiService,ComponentType=System";
    private Logger logger = Logger.getLogger(SunManagementService.class.getName());

    public SunManagementService(ServerConnector connector, String targetName) {
        super(connector, targetName);
    }

    public String getState(String componentName, String componentType) {
        String state = "Shutdown";
        try {
            String name = this.getObjectName(componentName, componentType);
            ObjectName objName = new ObjectName(name);
            state = (String)this.getAttribute(objName, "CurrentState");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return state;
    }

    private String getObjectName(String componentName, String componentType) {
        String name = "com.sun.jbi:JbiName=" + this.targetName + "," + COMPONENT_NAME_PREFIX + componentName + "," + CONTROL_TYPE_PREFIX + "," + COMPONENT_TYPE_PREFIX + "," + INSTALLED_TYPE_PREFIX + Util.mapInstalledType(componentType);
        return name;
    }

    public String start(String componentName, String componentType) {
        String result = "";
        if (componentType.equals("service-assembly")) {
            result = this.startServiceAssembly(componentName);
        } else {
            try {
                String name = this.getObjectName(componentName, componentType);
                ObjectName objName = new ObjectName(name);
                this.invoke(objName, "start");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public String stop(String componentName, String componentType) {
        String result = "";
        if (componentType.equals("service-assembly")) {
            result = this.stopServiceAssembly(componentName);
        } else {
            try {
                String name = this.getObjectName(componentName, componentType);
                ObjectName objName = new ObjectName(name);
                this.invoke(objName, "stop");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public String shutdown(String componentName, String componentType) {
        String result = "";
        if (componentType.equals("service-assembly")) {
            result = this.shutdownServiceAssembly(componentName);
        } else {
            try {
                String name = this.getObjectName(componentName, componentType);
                ObjectName objName = new ObjectName(name);
                this.invoke(objName, "shutDown");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public String shutdownForce(String componentName, String componentType) {
        String result = "";
        try {
            String name = this.getObjectName(componentName, componentType);
            ObjectName objName = new ObjectName(name);
            this.invoke(objName, "shutDownForce");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public String suspend(String componentName, String componentType) {
        String result = "";
        return result;
    }

    public String resume(String componentName, String componentType) {
        String result = "";
        return result;
    }

    private String startServiceAssembly(String componentName) {
        String result = "";
        try {
            ObjectName objName = new ObjectName(ADMIN_SERVICE_OBJECTNAME);
            this.invoke(objName, "startServiceAssembly", new Object[]{componentName, this.targetName});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private String stopServiceAssembly(String componentName) {
        String result = "";
        try {
            ObjectName objName = new ObjectName(ADMIN_SERVICE_OBJECTNAME);
            this.invoke(objName, "stopServiceAssembly", new Object[]{componentName, this.targetName});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private String shutdownServiceAssembly(String componentName) {
        String result = "";
        try {
            ObjectName objName = new ObjectName(ADMIN_SERVICE_OBJECTNAME);
            this.invoke(objName, "shutdownServiceAssembly", new Object[]{componentName, this.targetName});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }
}

