/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.jsf.framework.services.statistics.providers;

import com.sun.jbi.jsf.framework.common.Util;
import com.sun.jbi.jsf.framework.connectors.ServerConnector;
import com.sun.jbi.jsf.framework.model.JBIServiceUnitDescriptor;
import com.sun.jbi.jsf.framework.services.BaseServiceProvider;
import com.sun.jbi.jsf.framework.services.statistics.StatisticsService;
import com.sun.jbi.jsf.statistics.Statistics;
import com.sun.jbi.ui.client.JBIAdminCommandsClientFactory;
import com.sun.jbi.ui.common.JBIAdminCommands;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SunStatisticsService
extends BaseServiceProvider
implements Serializable,
StatisticsService {
    private static final String DOMAIN_NAME_PREFIX = "com.sun.ebi:";
    private static final String SERVICE_TYPE_PREFIX = "ServiceType=Status";
    private static final String INSTALLATION_TYPE_PREFIX = "InstallationType=";
    private static final String IDENTIFICATION_NAME_PREFIX = "IdentificationName=";
    private long sentRequests;
    private long sentReplies;
    private long sentErrors;
    private long sentDones;
    private long receivedRequests;
    private long receivedReplies;
    private long receivedErrors;
    private long receivedDones;
    private JBIAdminCommands commands;

    public SunStatisticsService(ServerConnector connector, String targetName) {
        super(connector, targetName);
        this.init();
    }

    private void init() {
        try {
            if (null == this.serverConnection) {
                this.serverConnection = this.serverConnector.getConnection();
            }
            this.commands = JBIAdminCommandsClientFactory.getInstance((MBeanServerConnection)this.serverConnection, (boolean)false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public long getReceivedDones() {
        return this.receivedDones;
    }

    @Override
    public long getReceivedErrors() {
        return this.receivedErrors;
    }

    @Override
    public long getReceivedReplies() {
        return this.receivedReplies;
    }

    @Override
    public long getReceivedRequests() {
        return this.receivedRequests;
    }

    @Override
    public long getSentDones() {
        return this.sentDones;
    }

    @Override
    public long getSentErrors() {
        return this.sentErrors;
    }

    @Override
    public long getSentReplies() {
        return this.sentReplies;
    }

    @Override
    public long getSentRequests() {
        return this.sentRequests;
    }

    private void reset() {
        this.sentRequests = 0L;
        this.sentReplies = 0L;
        this.sentErrors = 0L;
        this.sentDones = 0L;
        this.receivedRequests = 0L;
        this.receivedReplies = 0L;
        this.receivedErrors = 0L;
        this.receivedDones = 0L;
    }

    private String getObjectName(String componentName, String componentType) {
        String name = "com.sun.ebi:ServiceType=Status,InstallationType=" + Util.mapType(componentType) + "," + IDENTIFICATION_NAME_PREFIX + componentName;
        return name;
    }

    @Override
    public String[] getProvisioningEndpoints(String componentName, String componentType) {
        String[] result = null;
        try {
            String name = this.getObjectName(componentName, componentType);
            ObjectName objectName = new ObjectName(name);
            result = (String[])this.invoke(objectName, "getProvisioningEndpoints", null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public String[] getConsumingEndpoints(String componentName, String componentType) {
        String[] result = null;
        try {
            String name = this.getObjectName(componentName, componentType);
            ObjectName objectName = new ObjectName(name);
            result = (String[])this.invoke(objectName, "getConsumingEndpoints", null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public Statistics getStatisticsEndpoint(String endpoint, String componentName, String componentType) {
        this.reset();
        String name = this.getObjectName(componentName, componentType);
        try {
            ObjectName objectName = new ObjectName(name);
            if (this.serverConnection != null && this.serverConnection.isRegistered(objectName)) {
                Object[] params = new Object[]{endpoint};
                this.receivedErrors = this.invokeLong(objectName, "getReceivedErrors", params);
                this.receivedDones = this.invokeLong(objectName, "getReceivedDones", params);
                this.receivedReplies = this.invokeLong(objectName, "getReceivedReplies", params);
                this.receivedRequests = this.invokeLong(objectName, "getReceivedRequests", params);
                this.sentDones = this.invokeLong(objectName, "getSentDones", params);
                this.sentErrors = this.invokeLong(objectName, "getSentErrors", params);
                this.sentReplies = this.invokeLong(objectName, "getSentReplies", params);
                this.sentRequests = this.invokeLong(objectName, "getSentRequests", params);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Statistics stats = new Statistics(endpoint, this.sentRequests, this.sentReplies, this.sentErrors, this.sentDones, this.receivedRequests, this.receivedReplies, this.receivedErrors, this.receivedDones);
        return stats;
    }

    @Override
    public List<Statistics> getProvisioningStatistics(String componentName, String componentType, String cType, String cName, String saName) {
        String type;
        ArrayList<Statistics> list = new ArrayList<Statistics>();
        String name = Util.mapComponentValue(cName, componentName);
        String[] endpoints = this.getProvisioningEndpoints(name, type = Util.mapComponentValue(cType, componentType));
        if (endpoints != null && endpoints.length > 0) {
            boolean isSU = "service-unit".equals(componentType);
            Map<String, String> suList = null;
            if (isSU) {
                suList = this.getSuEndpoints(EndpointType.PROVIDER, saName, componentName, this.targetName);
            }
            for (int i = 0; i < endpoints.length; ++i) {
                String endpoint = endpoints[i];
                Statistics stats = null;
                if (isSU) {
                    if (this.isSuEndpoint(endpoint, suList)) {
                        stats = this.getStatisticsEndpoint(endpoint, cName, cType);
                    }
                } else {
                    stats = this.getStatisticsEndpoint(endpoint, componentName, componentType);
                }
                if (stats == null) continue;
                list.add(stats);
            }
        }
        return list;
    }

    @Override
    public List<Statistics> getConsumingStatistics(String componentName, String componentType, String cType, String cName, String saName) {
        String type;
        ArrayList<Statistics> list = new ArrayList<Statistics>();
        String name = Util.mapComponentValue(cName, componentName);
        String[] endpoints = this.getConsumingEndpoints(name, type = Util.mapComponentValue(cType, componentType));
        if (endpoints != null && endpoints.length > 0) {
            boolean isSU = "service-unit".equals(componentType);
            Map<String, String> suList = null;
            if (isSU) {
                suList = this.getSuEndpoints(EndpointType.CONSUMER, saName, componentName, this.targetName);
            }
            for (int i = 0; i < endpoints.length; ++i) {
                String endpoint = endpoints[i];
                Statistics stats = null;
                if (isSU) {
                    if (this.isSuEndpoint(endpoint, suList)) {
                        stats = this.getStatisticsEndpoint(endpoint, cName, cType);
                    }
                } else {
                    stats = this.getStatisticsEndpoint(endpoint, componentName, componentType);
                }
                if (stats == null) continue;
                list.add(stats);
            }
        }
        return list;
    }

    @Override
    public Statistics getTotalStatistics(List<Statistics> provisioningStats, List<Statistics> consumingStats) {
        Statistics totalStats = new Statistics();
        if (provisioningStats != null) {
            for (Statistics stats : provisioningStats) {
                totalStats.add(stats.getSentRequests(), stats.getSentReplies(), stats.getSentErrors(), stats.getSentDones(), stats.getReceivedRequests(), stats.getReceivedReplies(), stats.getReceivedErrors(), stats.getReceivedDones());
            }
        }
        if (consumingStats != null) {
            for (Statistics stats : consumingStats) {
                totalStats.add(stats.getSentRequests(), stats.getSentReplies(), stats.getSentErrors(), stats.getSentDones(), stats.getReceivedRequests(), stats.getReceivedReplies(), stats.getReceivedErrors(), stats.getReceivedDones());
            }
        }
        return totalStats;
    }

    private Map<String, String> getSuEndpoints(EndpointType type, String saName, String suName, String targetName) {
        Map map = null;
        if (this.commands != null) {
            try {
                String fqSUName = saName + "-" + suName;
                String xmlText = this.commands.getServiceUnitDeploymentDescriptor(saName, fqSUName);
                JBIServiceUnitDescriptor suDescriptor = new JBIServiceUnitDescriptor(xmlText);
                suDescriptor.parse();
                map = type == EndpointType.CONSUMER ? suDescriptor.getEndpoints(true) : suDescriptor.getEndpoints(false);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return map;
    }

    private boolean isSuEndpoint(String endpoint, Map<String, String> suList) {
        String endpt;
        boolean valid = false;
        if (suList != null && suList.get(endpt = Util.trimRight(endpoint, ",")) != null) {
            valid = true;
        }
        return valid;
    }

    @Override
    public Statistics getStatistics(String componentName, String componentType) {
        this.reset();
        String name = this.getObjectName(componentName, componentType);
        try {
            ObjectName objectName = new ObjectName(name);
            if (this.serverConnection != null && this.serverConnection.isRegistered(objectName)) {
                Object[] params = new Object[]{""};
                this.receivedErrors = this.invokeLong(objectName, "getReceivedErrors", params);
                this.receivedDones = this.invokeLong(objectName, "getReceivedDones", params);
                this.receivedReplies = this.invokeLong(objectName, "getReceivedReplies", params);
                this.receivedRequests = this.invokeLong(objectName, "getReceivedRequests", params);
                this.sentDones = this.invokeLong(objectName, "getSentDones", params);
                this.sentErrors = this.invokeLong(objectName, "getSentErrors", params);
                this.sentReplies = this.invokeLong(objectName, "getSentReplies", params);
                this.sentRequests = this.invokeLong(objectName, "getSentRequests", params);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Statistics stats = new Statistics(this.sentRequests, this.sentReplies, this.sentErrors, this.sentDones, this.receivedRequests, this.receivedReplies, this.receivedErrors, this.receivedDones);
        return stats;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum EndpointType {
        CONSUMER,
        PROVIDER;

    }
}

