/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.jsf.statistics;

import com.sun.data.provider.TableDataProvider;
import com.sun.data.provider.impl.ObjectListDataProvider;
import com.sun.jbi.jsf.framework.common.BaseBean;
import com.sun.jbi.jsf.framework.common.Util;
import com.sun.jbi.jsf.framework.common.resources.Messages;
import com.sun.jbi.jsf.framework.services.statistics.StatisticsService;
import com.sun.jbi.jsf.statistics.DisplayStatistics;
import com.sun.jbi.jsf.statistics.Statistics;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatisticsBean
extends BaseBean
implements Serializable {
    private StatisticsService statsService = null;
    private Logger logger = Logger.getLogger(StatisticsBean.class.getName());
    private List<Statistics> pStats;
    private List<Statistics> cStats;

    protected void getStatisticsService() {
        this.setup();
        this.statsService = this.serviceManager.getStatisticsService(this.tName);
    }

    public TableDataProvider getStatistics() {
        Statistics stats = this.getStatisticsInstance();
        List<DisplayStatistics> list = stats.generateDisplayStatistics();
        this.provider = new ObjectListDataProvider(list);
        return this.provider;
    }

    public TableDataProvider getProvisioningStatistics() {
        this.getStatisticsService();
        this.pStats = this.statsService.getProvisioningStatistics(this.componentName, this.componentType, this.cType, this.cName, this.pName);
        ArrayList<DisplayStatistics> list = new ArrayList<DisplayStatistics>();
        if (this.pStats != null) {
            for (Statistics stats : this.pStats) {
                list.addAll(stats.generateDisplayStatistics());
            }
        }
        this.provider = new ObjectListDataProvider(list);
        return this.provider;
    }

    public TableDataProvider getConsumingStatistics() {
        this.getStatisticsService();
        this.cStats = this.statsService.getConsumingStatistics(this.componentName, this.componentType, this.cType, this.cName, this.pName);
        ArrayList<DisplayStatistics> list = new ArrayList<DisplayStatistics>();
        if (this.cStats != null) {
            for (Statistics stats : this.cStats) {
                list.addAll(stats.generateDisplayStatistics());
            }
        }
        this.provider = new ObjectListDataProvider(list);
        return this.provider;
    }

    public TableDataProvider getTotalsStatistics() {
        this.getStatisticsService();
        Statistics stats = this.statsService.getTotalStatistics(this.pStats, this.cStats);
        List<DisplayStatistics> list = stats.generateDisplayStatistics();
        this.provider = new ObjectListDataProvider(list);
        return this.provider;
    }

    public Statistics getStatisticsInstance() {
        this.setup();
        this.statsService = this.serviceManager.getStatisticsService(this.tName);
        String name = Util.mapComponentValue(this.cName, this.componentName);
        String type = Util.mapComponentValue(this.cType, this.componentType);
        Statistics stats = this.statsService.getStatistics(name, type);
        return stats;
    }

    public String getLabel() {
        String label = "";
        if ("binding-component".equals(this.componentType)) {
            label = Messages.getString("jbi.statistics.bc.label");
        } else if ("service-engine".equals(this.componentType)) {
            label = Messages.getString("jbi.statistics.se.label");
        } else if ("service-unit".equals(this.componentType)) {
            label = Messages.getString("jbi.statistics.su.label");
        }
        return label;
    }

    public String getTitle() {
        return this.getTitle("jbi.statistics.title");
    }

    public String getTableTitle() {
        return this.getTableTitle("jbi.statistics.bc.tabletitle", "jbi.statistics.se.tabletitle", "jbi.statistics.su.tabletitle");
    }

    public String showGraph() {
        return "success";
    }

    public List<DisplayStatistics> getProvisioningStatisticsList() {
        this.getStatisticsService();
        this.pStats = this.statsService.getProvisioningStatistics(this.componentName, this.componentType, this.cType, this.cName, this.pName);
        ArrayList<DisplayStatistics> list = new ArrayList<DisplayStatistics>();
        if (this.pStats != null) {
            for (Statistics stats : this.pStats) {
                list.addAll(stats.generateDisplayStatistics());
            }
        }
        return list;
    }

    public List<DisplayStatistics> getConsumingStatisticsList() {
        this.getStatisticsService();
        this.cStats = this.statsService.getConsumingStatistics(this.componentName, this.componentType, this.cType, this.cName, this.pName);
        ArrayList<DisplayStatistics> list = new ArrayList<DisplayStatistics>();
        if (this.cStats != null) {
            for (Statistics stats : this.cStats) {
                list.addAll(stats.generateDisplayStatistics());
            }
        }
        return list;
    }

    public Map<String, Double> getConsumingTotalsList() {
        HashMap<String, Double> consumingTotalsMap = new HashMap<String, Double>();
        double totalReceivedRequests = 0.0;
        double totalReceivedReplies = 0.0;
        double totalReceivedErrors = 0.0;
        double totalReceivedDones = 0.0;
        double totalSentRequests = 0.0;
        double totalSentReplies = 0.0;
        double totalSentErrors = 0.0;
        double totalSentDones = 0.0;
        this.getStatisticsService();
        this.cStats = this.statsService.getConsumingStatistics(this.componentName, this.componentType, this.cType, this.cName, this.pName);
        if (this.cStats != null) {
            for (Statistics stats : this.cStats) {
                totalReceivedRequests += (double)stats.getReceivedRequests();
                totalReceivedReplies += (double)stats.getReceivedReplies();
                totalReceivedErrors += (double)stats.getReceivedErrors();
                totalReceivedDones += (double)stats.getReceivedDones();
                totalSentRequests += (double)stats.getSentRequests();
                totalSentReplies += (double)stats.getSentReplies();
                totalSentErrors += (double)stats.getSentErrors();
                totalSentDones += (double)stats.getSentDones();
            }
        }
        consumingTotalsMap.put(Messages.getString("statistics_receivedRequests"), new Double(totalReceivedRequests));
        consumingTotalsMap.put(Messages.getString("statistics_receivedReplies"), new Double(totalReceivedReplies));
        consumingTotalsMap.put(Messages.getString("statistics_receivedErrors"), new Double(totalReceivedErrors));
        consumingTotalsMap.put(Messages.getString("statistics_receivedDones"), new Double(totalReceivedDones));
        consumingTotalsMap.put(Messages.getString("statistics_sentRequests"), new Double(totalSentRequests));
        consumingTotalsMap.put(Messages.getString("statistics_sentReplies"), new Double(totalSentReplies));
        consumingTotalsMap.put(Messages.getString("statistics_sentErrors"), new Double(totalSentErrors));
        consumingTotalsMap.put(Messages.getString("statistics_sentDones"), new Double(totalSentDones));
        return consumingTotalsMap;
    }

    public Map<String, Double> getProvisioningTotalsList() {
        HashMap<String, Double> provisioningTotalsMap = new HashMap<String, Double>();
        double totalReceivedRequests = 0.0;
        double totalReceivedReplies = 0.0;
        double totalReceivedErrors = 0.0;
        double totalReceivedDones = 0.0;
        double totalSentRequests = 0.0;
        double totalSentReplies = 0.0;
        double totalSentErrors = 0.0;
        double totalSentDones = 0.0;
        this.getStatisticsService();
        this.cStats = this.statsService.getProvisioningStatistics(this.componentName, this.componentType, this.cType, this.cName, this.pName);
        if (this.cStats != null) {
            for (Statistics stats : this.cStats) {
                totalReceivedRequests += (double)stats.getReceivedRequests();
                totalReceivedReplies += (double)stats.getReceivedReplies();
                totalReceivedErrors += (double)stats.getReceivedErrors();
                totalReceivedDones += (double)stats.getReceivedDones();
                totalSentRequests += (double)stats.getSentRequests();
                totalSentReplies += (double)stats.getSentReplies();
                totalSentErrors += (double)stats.getSentErrors();
                totalSentDones += (double)stats.getSentDones();
            }
        }
        provisioningTotalsMap.put(Messages.getString("statistics_receivedRequests"), new Double(totalReceivedRequests));
        provisioningTotalsMap.put(Messages.getString("statistics_receivedReplies"), new Double(totalReceivedReplies));
        provisioningTotalsMap.put(Messages.getString("statistics_receivedErrors"), new Double(totalReceivedErrors));
        provisioningTotalsMap.put(Messages.getString("statistics_receivedDones"), new Double(totalReceivedDones));
        provisioningTotalsMap.put(Messages.getString("statistics_sentRequests"), new Double(totalSentRequests));
        provisioningTotalsMap.put(Messages.getString("statistics_sentReplies"), new Double(totalSentReplies));
        provisioningTotalsMap.put(Messages.getString("statistics_sentErrors"), new Double(totalSentErrors));
        provisioningTotalsMap.put(Messages.getString("statistics_sentDones"), new Double(totalSentDones));
        return provisioningTotalsMap;
    }
}

