/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.jsf.util;

import com.sun.enterprise.tools.admingui.util.GuiUtil;
import com.sun.jbi.jsf.bean.LoggingBean;
import com.sun.jbi.jsf.factory.PropertySheetAdaptorBase;
import com.sun.jbi.jsf.util.BeanUtilities;
import com.sun.jbi.jsf.util.I18nUtilities;
import com.sun.jbi.jsf.util.JBILogger;
import com.sun.jbi.jsf.util.SystemLoggerUtilities;
import com.sun.jbi.ui.common.JBIAdminCommands;
import com.sun.jbi.ui.common.JBIRemoteException;
import com.sun.jsftemplating.layout.descriptors.LayoutComponent;
import com.sun.webui.jsf.component.DropDown;
import com.sun.webui.jsf.component.HiddenField;
import com.sun.webui.jsf.component.Property;
import com.sun.webui.jsf.component.StaticText;
import com.sun.webui.jsf.model.Option;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBILogLevelsPropertySheetAdaptor
extends PropertySheetAdaptorBase {
    private static Logger sLog;
    private JBIAdminCommands mJac = BeanUtilities.getClient();
    private static final Option[] mLogLevelOptions;

    private JBILogLevelsPropertySheetAdaptor() {
    }

    protected JBILogLevelsPropertySheetAdaptor(LayoutComponent desc, UIComponent parent) {
        super(desc, parent);
    }

    public static JBILogLevelsPropertySheetAdaptor getInstance(FacesContext ctx, LayoutComponent desc, UIComponent parent) {
        return new JBILogLevelsPropertySheetAdaptor(desc, parent);
    }

    @Override
    public void init() {
        sLog = JBILogger.getInstance();
        UIComponent parent = this.getParentUIComponent();
        this.mPropertySheetId = this.getRequiredOptionValue("propertySheetId", parent);
        this.mPropertySheetSectionIdTag = this.getRequiredOptionValue("propertySheetSectionIdTag", parent);
        this.mPropertyIdTag = this.getRequiredOptionValue("propertyIdTag", parent);
        this.mStaticTextIdTag = this.getRequiredOptionValue("staticTextIdTag", parent);
        this.mDropDownIdTag = this.getRequiredOptionValue("dropDownIdTag", parent);
        this.mHiddenFieldIdTag = this.getRequiredOptionValue("hiddenFieldIdTag", parent);
    }

    @Override
    public UIComponent getPropertySheet(UIComponent parent) {
        this.constructPropertySheet(parent);
        return parent;
    }

    private UIComponent constructPropertySheet(UIComponent parent) {
        Map logLevels;
        String componentName = this.getRequiredOptionValue("componentName", parent);
        String instanceName = this.getRequiredOptionValue("instanceName", parent);
        String targetName = (String)this.getOptionValue("targetName", parent);
        String additionalFile = (String)this.getOptionValue("additionalLoggerFile", parent);
        LoggingBean loggingBean = BeanUtilities.getLoggingBean();
        loggingBean.setSaveButtonDisabled(false);
        String defaultLevel = (String)this.getOptionValue("dropDownDefaultLevel", parent);
        boolean PE_Flag = false;
        if (targetName == null) {
            PE_Flag = true;
            targetName = instanceName;
        }
        if ((logLevels = this.getLoggerLevels(componentName, targetName, instanceName)) == null) {
            logLevels = new HashMap();
        }
        if (additionalFile != null) {
            logLevels = SystemLoggerUtilities.addAdditionalSystemLoggers(logLevels, componentName, targetName, additionalFile);
        }
        UIComponent propertySheetSection = this.getPropertySheetSectionComponent(parent);
        if (logLevels.size() == 0) {
            UIComponent propertyComponent = this.getPropertyComponent(propertySheetSection);
            if (PE_Flag) {
                Object[] args = new Object[]{componentName};
                String msg = GuiUtil.getMessage((String)I18nUtilities.getResourceString("jbi.configure.loggers.pe.page.no.loggers"), (Object[])args);
                ((Property)propertyComponent).setLabel(msg);
            } else {
                Object[] args = new Object[]{componentName, instanceName};
                String msg = GuiUtil.getMessage((String)I18nUtilities.getResourceString("jbi.configure.loggers.page.no.loggers"), (Object[])args);
                ((Property)propertyComponent).setLabel(msg);
            }
            loggingBean.setSaveButtonDisabled(true);
        } else {
            Set logLevelSet = null;
            Level level = null;
            logLevelSet = logLevels.keySet();
            for (String name : logLevelSet) {
                String label = null;
                String loggerTagName = (String)SystemLoggerUtilities.loggerNames.get(name);
                label = loggerTagName != null ? (String)SystemLoggerUtilities.loggerLabels.get(loggerTagName.toLowerCase()) : this.extractLoggerDisplayName(name);
                level = (Level)logLevels.get(name);
                String displayName = "(" + name + ")";
                if (defaultLevel != null) {
                    level = Level.parse(defaultLevel);
                }
                UIComponent propertyComponent = this.getPropertyComponent(propertySheetSection);
                UIComponent dropDownComponent = this.getDropDownComponent(propertyComponent);
                UIComponent staticTextComponent = this.getStaticTextComponent(propertyComponent);
                UIComponent hiddenFieldComponent = this.getHiddenFieldComponent(propertyComponent);
                ((Property)propertyComponent).setLabelAlign("left");
                ((Property)propertyComponent).setNoWrap(true);
                ((Property)propertyComponent).setOverlapLabel(false);
                ((Property)propertyComponent).setLabel(label);
                ((DropDown)dropDownComponent).setItems((Object)mLogLevelOptions);
                ((DropDown)dropDownComponent).setSelected((Object)level.getName());
                ((StaticText)staticTextComponent).setText((Object)displayName);
                ((HiddenField)hiddenFieldComponent).setText((Object)name);
            }
        }
        return parent;
    }

    private String extractLoggerDisplayName(String aFullname) {
        String displayName = aFullname;
        int index = displayName.lastIndexOf(".");
        if (index > 0 && (displayName = aFullname.substring(index + 1)).length() > 0) {
            displayName = JBILogLevelsPropertySheetAdaptor.capitalize(displayName);
        }
        return displayName;
    }

    private static String capitalize(String s) {
        char[] chars = s.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }

    @Override
    public Map<String, Object> getFactoryOptions() {
        HashMap<String, Object> result = null;
        LayoutComponent desc = this.getLayoutComponent();
        result = new HashMap<String, Object>();
        this.setProperty(result, "propertySheetId", desc.getOption("propertySheetId"));
        this.setProperty(result, "propertySheetSectionIdTag", desc.getOption("propertySheetSectionIdTag"));
        this.setProperty(result, "propertyIdTag", desc.getOption("propertyIdTag"));
        this.setProperty(result, "staticTextIdTag", desc.getOption("staticTextIdTag"));
        this.setProperty(result, "dropDownIdTag", desc.getOption("dropDownIdTag"));
        this.setProperty(result, "dropDownDefaultLevel", desc.getOption("dropDownDefaultLevel"));
        this.setProperty(result, "hiddenFieldIdTag", desc.getOption("hiddenFieldIdTag"));
        this.setProperty(result, "componentName", desc.getOption("componentName"));
        this.setProperty(result, "targetName", desc.getOption("targetName"));
        this.setProperty(result, "instanceName", desc.getOption("instanceName"));
        this.setProperty(result, "propertySheetAdaptorClass", desc.getOption("propertySheetAdaptorClass"));
        return result;
    }

    private void setProperty(Map props, String key, Object value) {
        if (value != null) {
            props.put(key, value);
        }
    }

    @Override
    public Map<String, UIComponent> getFacets(UIComponent comp, Object nodeObject) {
        return null;
    }

    public Map getHandlersByType(UIComponent comp, Object nodeObject) {
        return null;
    }

    private Map getLoggerLevels(String componentName, String targetName, String instanceName) {
        Map result = null;
        try {
            if (null != this.mJac) {
                sLog.fine("JBILogLevelsPropertySheetAdaptor - getLoggerLevels: componentName=" + componentName + ", targetName=" + targetName + ", instanceName=" + instanceName);
                result = this.mJac.getComponentLoggerLevels(componentName, targetName, instanceName);
            }
        }
        catch (JBIRemoteException jbiRemoteEx) {
            sLog.fine("JBILogLevelsPropertySheetAdaptor(): caught jbiRemoteEx=" + (Object)((Object)jbiRemoteEx));
        }
        return result;
    }

    static {
        mLogLevelOptions = new Option[]{new Option((Object)Level.parse("FINEST").getName(), GuiUtil.getMessage((String)I18nUtilities.getResourceString("loglevel.FINEST"))), new Option((Object)Level.parse("FINER").getName(), GuiUtil.getMessage((String)I18nUtilities.getResourceString("loglevel.FINER"))), new Option((Object)Level.parse("FINE").getName(), GuiUtil.getMessage((String)I18nUtilities.getResourceString("loglevel.FINE"))), new Option((Object)Level.parse("CONFIG").getName(), GuiUtil.getMessage((String)I18nUtilities.getResourceString("loglevel.CONFIG"))), new Option((Object)Level.parse("INFO").getName(), GuiUtil.getMessage((String)I18nUtilities.getResourceString("loglevel.INFO"))), new Option((Object)Level.parse("WARNING").getName(), GuiUtil.getMessage((String)I18nUtilities.getResourceString("loglevel.WARNING"))), new Option((Object)Level.parse("SEVERE").getName(), GuiUtil.getMessage((String)I18nUtilities.getResourceString("loglevel.SEVERE"))), new Option((Object)Level.parse("OFF").getName(), GuiUtil.getMessage((String)I18nUtilities.getResourceString("loglevel.OFF"))), new Option((Object)Level.parse("INFO").getName(), GuiUtil.getMessage((String)I18nUtilities.getResourceString("loglevel.DEFAULT")))};
    }
}

