/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.jsf.util;

import com.sun.jbi.jsf.bean.ListBean;
import com.sun.jbi.jsf.util.BeanUtilities;
import com.sun.jbi.jsf.util.JBILogger;
import com.sun.jbi.jsf.util.ServiceUnitInfoWrapper;
import com.sun.jbi.ui.common.JBIAdminCommands;
import com.sun.jbi.ui.common.JBIComponentInfo;
import com.sun.jbi.ui.common.JBIRemoteException;
import com.sun.jbi.ui.common.ServiceAssemblyInfo;
import com.sun.jbi.ui.common.ServiceUnitInfo;
import com.sun.jsftemplating.component.factory.tree.TreeAdaptor;
import com.sun.jsftemplating.component.factory.tree.TreeAdaptorBase;
import com.sun.jsftemplating.layout.descriptors.LayoutComponent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBITreeAdaptorImpl
extends TreeAdaptorBase
implements TreeAdaptor {
    private static Logger sLog = JBILogger.getInstance();
    private JBIAdminCommands mJac = BeanUtilities.getClient();
    private String mAdaptorListType;
    Object[] mChildren;
    private String mNameAtt;

    public JBITreeAdaptorImpl() {
        sLog.fine("JBITreeAdaptorImpl.<init>()");
    }

    public JBITreeAdaptorImpl(LayoutComponent desc, UIComponent parent) {
        super(desc, parent);
        sLog.fine("JBITreeAdaptorImpl.<init>(" + desc + ", " + parent + "), mJac=" + this.mJac + ", this=" + (Object)((Object)this));
    }

    public static TreeAdaptor getInstance(FacesContext ctx, LayoutComponent desc, UIComponent parent) {
        JBITreeAdaptorImpl result = new JBITreeAdaptorImpl(desc, parent);
        sLog.fine("JBITreeAdaptorImpl.getInstance(" + ctx + ", " + desc + ", " + parent + "),result =" + (Object)((Object)result));
        return result;
    }

    public void init() {
        sLog.fine("JBITreeAdaptorImpl.init(), this=" + (Object)((Object)this));
        FacesContext ctx = FacesContext.getCurrentInstance();
        LayoutComponent desc = this.getLayoutComponent();
        UIComponent parent = this.getParentUIComponent();
        Object val = desc.getEvaluatedOption(ctx, "treeAdaptorListType", parent);
        if (val == null) {
            throw new IllegalArgumentException("'treeAdaptorListType' must be specified!");
        }
        this.mAdaptorListType = (String)val;
        this.setTreeNodeObject(this.mAdaptorListType);
        sLog.fine("JBITreeAdaptorImpl.init(), desc=" + desc + ", parent=" + parent + ", mAdaptorListType=" + this.mAdaptorListType + ", this=" + (Object)((Object)this));
    }

    public List getChildTreeNodeObjects(Object nodeObject) {
        sLog.fine("JBITreeAdaptorImpl getChildTreeNodeObjects(" + nodeObject + "), mAdaptorListType=" + this.mAdaptorListType + ", this=" + (Object)((Object)this));
        List<Object> result = null;
        if (null != nodeObject) {
            if (nodeObject.equals(this.mAdaptorListType)) {
                ListBean listBean = BeanUtilities.getListBean();
                if ("deployments".equals(this.mAdaptorListType)) {
                    String xmlQueryResults = listBean.getListServiceAssemblies();
                    sLog.fine("JBITreeAdaptorImpl getChildTreeNodeObjects(...), xmlQueryResults=" + xmlQueryResults);
                    List saInfoList = ServiceAssemblyInfo.readFromXmlTextWithProlog((String)xmlQueryResults);
                    this.mChildren = saInfoList.toArray();
                } else if ("bindingsEngines".equals(this.mAdaptorListType)) {
                    String xmlQueryResults = listBean.getListBindingComponents();
                    sLog.fine("JBITreeAdaptorImpl getChildTreeNodeObjects(...), xmlQueryResults=" + xmlQueryResults);
                    List bcCompInfoList = JBIComponentInfo.readFromXmlText((String)xmlQueryResults);
                    xmlQueryResults = listBean.getListServiceEngines();
                    sLog.fine("JBITreeAdaptorImpl getChildTreeNodeObjects(...), xmlQueryResults=" + xmlQueryResults);
                    List seCompInfoList = JBIComponentInfo.readFromXmlText((String)xmlQueryResults);
                    ArrayList operableComponentsList = new ArrayList();
                    operableComponentsList.addAll(bcCompInfoList);
                    operableComponentsList.addAll(seCompInfoList);
                    this.mChildren = operableComponentsList.toArray();
                } else if ("libraries".equals(this.mAdaptorListType)) {
                    String xmlQueryResults = listBean.getListSharedLibraries();
                    sLog.fine("JBITreeAdaptorImpl getChildTreeNodeObjects(...), xmlQueryResults=" + xmlQueryResults);
                    List slCompInfoList = JBIComponentInfo.readFromXmlText((String)xmlQueryResults);
                    this.mChildren = slCompInfoList.toArray();
                }
                if (this.mChildren != null) {
                    sLog.fine("JBITreeAdaptorImpl getChildTreeNodeObjects(...), mChildren.length=" + this.mChildren.length);
                    result = Arrays.asList(this.mChildren);
                }
            } else if (nodeObject instanceof ServiceAssemblyInfo) {
                String target = "server";
                ArrayList<ServiceUnitInfoWrapper> suInfoList = new ArrayList<ServiceUnitInfoWrapper>();
                ServiceAssemblyInfo saInfo = (ServiceAssemblyInfo)nodeObject;
                String saName = saInfo.getName();
                List infoList = saInfo.getServiceUnitInfoList();
                for (Object suInfoObject : infoList) {
                    String compName = ((ServiceUnitInfo)suInfoObject).getTargetName();
                    ServiceUnitInfoWrapper wrapper = new ServiceUnitInfoWrapper((ServiceUnitInfo)suInfoObject, compName, saName, target);
                    suInfoList.add(wrapper);
                    wrapper.setQueryString("sa");
                }
                result = suInfoList;
            } else if (nodeObject instanceof JBIComponentInfo) {
                JBIComponentInfo compInfo = (JBIComponentInfo)nodeObject;
                String compName = compInfo.getName();
                String target = "server";
                List saInfoList = null;
                ArrayList<ServiceUnitInfoWrapper> suInfoList = new ArrayList<ServiceUnitInfoWrapper>();
                try {
                    String xml = this.mJac.listServiceAssemblies(compName, target);
                    saInfoList = ServiceAssemblyInfo.readFromXmlTextWithProlog((String)xml);
                    if (saInfoList != null) {
                        for (Object saInfoObject : saInfoList) {
                            String saName = ((ServiceAssemblyInfo)saInfoObject).getName();
                            List infoList = ((ServiceAssemblyInfo)saInfoObject).getServiceUnitInfoList();
                            for (Object suInfoObject : infoList) {
                                String tgtName = ((ServiceUnitInfo)suInfoObject).getTargetName();
                                if (!tgtName.equals(compName)) continue;
                                ServiceUnitInfoWrapper wrapper = new ServiceUnitInfoWrapper((ServiceUnitInfo)suInfoObject, compName, saName, target);
                                wrapper.setQueryString("comp");
                                suInfoList.add(wrapper);
                            }
                        }
                    }
                }
                catch (JBIRemoteException jbiRemoteEx) {
                    sLog.fine("JBITreeAdaptorImpl.getChildTreeNodeObjects(): caught jbiRemoteEx=" + (Object)((Object)jbiRemoteEx));
                }
                result = suInfoList;
            }
        }
        sLog.fine("JBITreeAdaptorImpl getChildTreeNodeObjects, result=" + result + ", this=" + (Object)((Object)this));
        return result;
    }

    public Map<String, Object> getFactoryOptions(Object nodeObject) {
        HashMap<String, Object> result = null;
        if (null != nodeObject) {
            LayoutComponent desc = this.getLayoutComponent();
            result = new HashMap<String, Object>();
            sLog.fine("JBITreeAdaptorImpl getFactoryOptions (" + nodeObject + "), nodeObject.getClass()=" + nodeObject.getClass() + ", desc=" + desc + ", this=" + (Object)((Object)this));
            if (nodeObject instanceof String) {
                this.setProperty(result, "text", desc.getOption("text"));
                this.setProperty(result, "url", desc.getOption("url"));
                this.setProperty(result, "imageURL", desc.getOption("imageURL"));
                this.setProperty(result, "target", desc.getOption("target"));
                this.setProperty(result, "action", desc.getOption("action"));
                this.setProperty(result, "actionListener", desc.getOption("actionListener"));
                this.setProperty(result, "expanded", desc.getOption("expanded"));
                sLog.fine("JBITreeAdaptorImpl getFactoryOptions (parent), text=" + desc.getOption("text") + ", (partial)result=" + result);
            } else {
                String childName = null;
                String imageUrlSuffix = null;
                String type = null;
                String compType = null;
                String urlSuffix = "type=";
                String urlBase = (String)desc.getOption("childURLbase");
                if (nodeObject instanceof JBIComponentInfo) {
                    JBIComponentInfo compInfo = (JBIComponentInfo)nodeObject;
                    childName = compInfo.getName();
                    type = compInfo.getType();
                    sLog.fine("JBITreeAdaptorImpl getFactoryOptions (child), childName=" + childName + ", type=" + type + ", (partial)result=" + result + ", this=" + (Object)((Object)this));
                    BeanUtilities.setStringPropertyUsingExpression(childName, "#{sessionScope.serviceAssemblyName}");
                } else if (nodeObject instanceof ServiceAssemblyInfo) {
                    ServiceAssemblyInfo saInfo = (ServiceAssemblyInfo)nodeObject;
                    childName = saInfo.getName();
                    type = "service-assembly";
                } else if (nodeObject instanceof ServiceUnitInfoWrapper) {
                    ServiceUnitInfo suInfo = ((ServiceUnitInfoWrapper)nodeObject).getServiceUnitInfo();
                    childName = suInfo.getName();
                    type = "service-unit";
                    String saName = ((ServiceUnitInfoWrapper)nodeObject).getServiceAssemblyName();
                    String compName = ((ServiceUnitInfoWrapper)nodeObject).getComponentName();
                    String qs = ((ServiceUnitInfoWrapper)nodeObject).getQueryString();
                    compType = ((ServiceUnitInfoWrapper)nodeObject).getComponentType();
                    String grandChildURLBase = "/jbi/cluster/showServiceUnit.jsf?";
                    if (urlBase.indexOf("cluster") == -1) {
                        grandChildURLBase = "/jbi/pe/showServiceUnit.jsf?";
                    }
                    urlBase = grandChildURLBase + "saname=" + saName + "&" + "qs=" + qs + "&" + "compName=" + compName + "&" + "compType=" + compType + "&";
                }
                if (null != childName) {
                    this.setProperty(result, "text", childName);
                    urlSuffix = urlSuffix + type + "&name=" + childName;
                    if ("service-assembly".equals(type)) {
                        imageUrlSuffix = "JBIServiceAssembly.gif";
                    } else if ("binding-component".equals(type)) {
                        imageUrlSuffix = "JBIBindingComponent.gif";
                    } else if ("service-engine".equals(type)) {
                        imageUrlSuffix = "JBIServiceEngine.gif";
                    } else if ("shared-library".equals(type)) {
                        imageUrlSuffix = "JBISharedLibrary.gif";
                    } else if ("service-unit".equals(type)) {
                        imageUrlSuffix = "JBISU.gif";
                        if (compType.equals("binding-component") || compType.equals("service-engine")) {
                            // empty if block
                        }
                    }
                }
                String url = urlBase + urlSuffix;
                sLog.fine("JBITreeAdaptorImpl.getFactoryOptions(...), url=" + url + ", imageUrlSuffix=" + imageUrlSuffix + ", this=" + (Object)((Object)this));
                this.setProperty(result, "url", url);
                this.setProperty(result, "imageURL", desc.getOption("childImageURLbase") + imageUrlSuffix);
                this.setProperty(result, "target", desc.getOption("childTarget"));
                this.setProperty(result, "action", desc.getOption("childAction"));
                this.setProperty(result, "expanded", desc.getOption("childExpanded"));
                sLog.fine("JBITreeAdaptorImpl getFactoryOptions (child), type=" + type + ", url=" + url);
            }
        }
        sLog.fine("JBITreeAdaptorImpl getFactoryOptions, result=" + result + ", this=" + (Object)((Object)this));
        return result;
    }

    void setProperty(Map props, String key, Object value) {
        if (value != null) {
            props.put(key, value);
        }
    }

    public String getId(Object nodeObject) {
        String result = "nullNodeObject";
        if (null != nodeObject) {
            result = this.genId(nodeObject.toString());
        }
        return result;
    }

    private String genId(String uid) {
        char[] chArr = uid.toCharArray();
        int len = chArr.length;
        int newIdx = 0;
        for (int idx = 0; idx < len; ++idx) {
            char test = chArr[idx];
            if (!Character.isLetterOrDigit(test) && test != '_' && test != '-') continue;
            chArr[newIdx++] = test;
        }
        return new String(chArr, 0, newIdx);
    }

    public Map<String, UIComponent> getFacets(UIComponent comp, Object nodeObject) {
        return null;
    }

    public Map getHandlersByType(UIComponent comp, Object nodeObject) {
        return null;
    }
}

