/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.client;

import com.sun.appserv.management.client.AppserverConnectionSource;
import com.sun.appserv.management.client.ConnectionSource;
import com.sun.appserv.management.client.ProxyFactory;
import com.sun.appserv.management.client.TLSParams;
import com.sun.appserv.management.config.ClusterConfig;
import com.sun.appserv.management.config.ClusteredServerConfig;
import com.sun.appserv.management.config.DeployedItemRefConfig;
import com.sun.appserv.management.config.DomainConfig;
import com.sun.appserv.management.config.StandaloneServerConfig;
import com.sun.enterprise.deployapi.SunTarget;
import com.sun.enterprise.deployapi.SunTargetModuleID;
import com.sun.enterprise.deployment.backend.DeploymentStatus;
import com.sun.enterprise.deployment.client.ApplicationReferenceAction;
import com.sun.enterprise.deployment.client.ChangeStateAction;
import com.sun.enterprise.deployment.client.DeployAction;
import com.sun.enterprise.deployment.client.DeploymentClientUtils;
import com.sun.enterprise.deployment.client.DeploymentFacility;
import com.sun.enterprise.deployment.client.JESProgressObject;
import com.sun.enterprise.deployment.client.ServerConnectionIdentifier;
import com.sun.enterprise.deployment.client.UndeployAction;
import com.sun.enterprise.deployment.deploy.shared.Archive;
import com.sun.enterprise.deployment.util.DeploymentProperties;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.net.ssl.X509TrustManager;

public class DeploymentFacilityImpl
implements DeploymentFacility {
    protected ConnectionSource dasConnection = null;
    protected ServerConnectionIdentifier serverId = null;
    protected SunTarget domain = null;
    protected Boolean localConnection = Boolean.FALSE;
    private static final String DAS = "server";
    private static StringManager localStrings = StringManager.getManager(DeploymentFacilityImpl.class);

    public boolean connect(ServerConnectionIdentifier targetDAS) {
        try {
            TLSParams tlsParams = null;
            if (targetDAS.isSecure()) {
                X509TrustManager trustManager = (X509TrustManager)targetDAS.getConnectionEnvironment().get("TRUST_MANAGER_KEY");
                tlsParams = new TLSParams(trustManager, null);
            }
            this.dasConnection = new AppserverConnectionSource("sun-as-http", targetDAS.getHostName(), targetDAS.getHostPort(), targetDAS.getUserName(), targetDAS.getPassword(), tlsParams, null);
        }
        catch (IllegalArgumentException illEx) {
            return false;
        }
        this.serverId = targetDAS;
        this.domain = new SunTarget(targetDAS);
        this.domain.setConnectionSource(this.dasConnection);
        this.domain.setTargetType("domain");
        return true;
    }

    public boolean isConnected() {
        return this.dasConnection != null;
    }

    public boolean disconnect() {
        this.dasConnection = null;
        return true;
    }

    public JESProgressObject deploy(Target[] targets, Archive source, Archive deploymentPlan, Map deploymentOptions) {
        if (!this.isConnected()) {
            throw new IllegalStateException(localStrings.getString("enterprise.deployment.client.disconnected_state"));
        }
        SunTarget[] targetList = this.getSunTargets(targets);
        DeployAction progressObject = new DeployAction(targetList);
        Object[] args = new Object[]{this.dasConnection, source, deploymentPlan, deploymentOptions == null ? new HashMap() : DeploymentProperties.propsToMap((Properties)deploymentOptions), targetList, this.domain, this.localConnection, this.serverId};
        progressObject.setCommand(CommandType.DISTRIBUTE, args);
        Thread newThread = new Thread(progressObject);
        newThread.start();
        return progressObject;
    }

    public JESProgressObject undeploy(Target[] targets, String moduleID) {
        return this.undeploy(targets, moduleID, null);
    }

    public JESProgressObject undeploy(Target[] targets, String moduleID, Map options) {
        if (!this.isConnected()) {
            throw new IllegalStateException(localStrings.getString("enterprise.deployment.client.disconnected_state"));
        }
        SunTarget[] targetList = this.getSunTargets(targets);
        UndeployAction progressObject = new UndeployAction(targetList);
        Object[] args = new Object[]{this.dasConnection, moduleID, options == null ? new HashMap() : DeploymentProperties.propsToMap((Properties)options), targetList, this.domain, this.localConnection};
        progressObject.setCommand(CommandType.UNDEPLOY, args);
        Thread newThread = new Thread(progressObject);
        newThread.start();
        return progressObject;
    }

    public JESProgressObject enable(Target[] targets, String moduleID) {
        return this.changeState(targets, moduleID, CommandType.START);
    }

    public JESProgressObject disable(Target[] targets, String moduleID) {
        return this.changeState(targets, moduleID, CommandType.STOP);
    }

    private JESProgressObject changeState(Target[] targets, String moduleID, CommandType cmd) {
        if (!this.isConnected()) {
            throw new IllegalStateException(localStrings.getString("enterprise.deployment.client.disconnected_state"));
        }
        SunTarget[] targetList = this.getSunTargets(targets);
        ChangeStateAction progressObject = new ChangeStateAction(targetList);
        Object[] args = new Object[]{this.dasConnection, targetList, moduleID, cmd, this.domain};
        progressObject.setCommand(cmd, args);
        Thread newThread = new Thread(progressObject);
        newThread.start();
        return progressObject;
    }

    public JESProgressObject createAppRef(Target[] targets, String moduleID, Map options) {
        return this.doApplicationReferenceAction(targets, moduleID, options, CommandType.DISTRIBUTE);
    }

    public JESProgressObject deleteAppRef(Target[] targets, String moduleID, Map options) {
        return this.doApplicationReferenceAction(targets, moduleID, options, CommandType.UNDEPLOY);
    }

    private JESProgressObject doApplicationReferenceAction(Target[] targets, String moduleID, Map options, CommandType cmd) {
        if (!this.isConnected()) {
            throw new IllegalStateException(localStrings.getString("enterprise.deployment.client.disconnected_state"));
        }
        SunTarget[] targetList = this.getSunTargets(targets);
        ApplicationReferenceAction progressObject = new ApplicationReferenceAction(targetList);
        Object[] args = new Object[]{this.dasConnection, targetList, moduleID, cmd, options == null ? new HashMap() : DeploymentProperties.propsToMap((Properties)options)};
        progressObject.setCommand(cmd, args);
        Thread newThread = new Thread(progressObject);
        newThread.start();
        return progressObject;
    }

    public TargetModuleID[] listAppRefs(String[] targets) throws IOException {
        if (!this.isConnected()) {
            throw new IllegalStateException(localStrings.getString("enterprise.deployment.client.disconnected_state"));
        }
        Vector<SunTargetModuleID> tmpVector = new Vector<SunTargetModuleID>();
        DomainConfig domainCfg = ProxyFactory.getInstance((ConnectionSource)this.dasConnection).getDomainRoot().getDomainConfig();
        Map serverProxies = domainCfg.getStandaloneServerConfigMap();
        Map clusterProxies = domainCfg.getClusterConfigMap();
        Map clusteredServerProxies = domainCfg.getClusteredServerConfigMap();
        for (int i = 0; i < targets.length; ++i) {
            StandaloneServerConfig tgtProxy;
            Set proxySet = null;
            if (serverProxies.get(targets[i]) != null) {
                tgtProxy = (StandaloneServerConfig)domainCfg.getContainee("X-StandaloneServerConfig", targets[i]);
                proxySet = tgtProxy.getContaineeSet("X-DeployedItemRefConfig");
            } else if (clusterProxies.get(targets[i]) != null) {
                tgtProxy = (ClusterConfig)domainCfg.getContainee("X-ClusterConfig", targets[i]);
                proxySet = tgtProxy.getContaineeSet("X-DeployedItemRefConfig");
            } else if (clusteredServerProxies.get(targets[i]) != null) {
                tgtProxy = (ClusteredServerConfig)domainCfg.getContainee("X-ClusteredServerConfig", targets[i]);
                proxySet = tgtProxy.getContaineeSet("X-DeployedItemRefConfig");
            } else if ("domain".equals(targets[i])) {
                tgtProxy = (StandaloneServerConfig)domainCfg.getContainee("X-StandaloneServerConfig", DAS);
                proxySet = tgtProxy.getContaineeSet("X-DeployedItemRefConfig");
            } else {
                return null;
            }
            Object[] appRefs = proxySet.toArray();
            for (int k = 0; k < appRefs.length; ++k) {
                SunTarget aTarget = new SunTarget(this.serverId);
                aTarget.setAppServerInstance(targets[i]);
                aTarget.setConnectionSource(this.dasConnection);
                DeployedItemRefConfig item = (DeployedItemRefConfig)appRefs[k];
                SunTargetModuleID tgtId = new SunTargetModuleID(item.getRef(), aTarget);
                tmpVector.add(tgtId);
            }
        }
        SunTargetModuleID[] result = new SunTargetModuleID[tmpVector.size()];
        return tmpVector.toArray(result);
    }

    private SunTarget[] getSunTargets(Target[] givenTargets) throws IllegalArgumentException {
        SunTarget[] result = new SunTarget[givenTargets.length];
        for (int i = 0; i < givenTargets.length; ++i) {
            if (!(givenTargets[i] instanceof SunTarget)) {
                throw new IllegalArgumentException(localStrings.getString("enterprise.deployment.client.notASunTarget", givenTargets[i].getClass().getName()));
            }
            result[i] = new SunTarget((SunTarget)givenTargets[i]);
        }
        return result;
    }

    public String downloadFile(File location, String moduleID, String moduleURI) throws IOException {
        if (!this.isConnected()) {
            throw new IllegalStateException(localStrings.getString("enterprise.deployment.client.disconnected_state"));
        }
        return DeploymentClientUtils.downloadClientStubs(moduleID, location.getAbsolutePath(), this.dasConnection);
    }

    public DeploymentStatus waitFor(JESProgressObject po) {
        DeploymentStatus status = null;
        do {
            try {
                Thread.currentThread();
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while ((status = po.getCompletedStatus()) == null);
        return status;
    }

    public Target[] createTargets(String[] targets) {
        if (!this.isConnected()) {
            throw new IllegalStateException(localStrings.getString("enterprise.deployment.client.disconnected_state"));
        }
        Target[] targetsArray = new Target[targets.length];
        Map serverProxies = null;
        Map clusterProxies = null;
        try {
            for (int i = 0; i < targets.length; ++i) {
                SunTarget aTarget;
                if ("domain".equals(targets[i])) {
                    SunTarget dom = new SunTarget(this.serverId);
                    dom.setAppServerInstance("domain");
                    dom.setConnectionSource(this.dasConnection);
                    dom.setTargetType("domain");
                    targetsArray[i] = dom;
                    continue;
                }
                if (DAS.equals(targets[i])) {
                    SunTarget serv = new SunTarget(this.serverId);
                    serv.setAppServerInstance(DAS);
                    serv.setConnectionSource(this.dasConnection);
                    serv.setTargetType("stand_alone_server");
                    targetsArray[i] = serv;
                    continue;
                }
                if (serverProxies == null || clusterProxies == null) {
                    DomainConfig domainCfg = ProxyFactory.getInstance((ConnectionSource)this.dasConnection).getDomainRoot().getDomainConfig();
                    serverProxies = domainCfg.getStandaloneServerConfigMap();
                    clusterProxies = domainCfg.getClusterConfigMap();
                }
                if (serverProxies.get(targets[i]) != null) {
                    aTarget = new SunTarget(this.serverId);
                    aTarget.setAppServerInstance(targets[i]);
                    aTarget.setConnectionSource(this.dasConnection);
                    aTarget.setTargetType("stand_alone_server");
                    targetsArray[i] = aTarget;
                    continue;
                }
                if (clusterProxies.get(targets[i]) != null) {
                    aTarget = new SunTarget(this.serverId);
                    aTarget.setAppServerInstance(targets[i]);
                    aTarget.setConnectionSource(this.dasConnection);
                    aTarget.setTargetType("cluster");
                    targetsArray[i] = aTarget;
                    continue;
                }
                return null;
            }
        }
        catch (Throwable ex) {
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            return null;
        }
        return targetsArray;
    }
}

