/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util.i18n;

import com.sun.enterprise.util.i18n.StringManagerBase;
import com.sun.logging.LogDomains;
import java.util.Date;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StringManager
extends StringManagerBase {
    private static Logger _logger = LogDomains.getLogger("javax.enterprise.system.util");
    private ResourceBundle _resourceBundle = null;
    private static final String RES_BUNDLE_NM = ".LocalStrings";
    private static Hashtable managers = new Hashtable();

    private StringManager(String packageName) {
        super(packageName + RES_BUNDLE_NM);
    }

    public static synchronized StringManager getManager(String packageName) {
        StringManager mgr = (StringManager)managers.get(packageName);
        if (mgr == null) {
            mgr = new StringManager(packageName);
            try {
                managers.put(packageName, mgr);
            }
            catch (Exception e) {
                _logger.log(Level.SEVERE, "iplanet_util.error_while_caching", e);
            }
        }
        return mgr;
    }

    public static synchronized StringManager getManager(Class callerClass) {
        try {
            Package pkg = callerClass.getPackage();
            if (pkg != null) {
                String pkgName = pkg.getName();
                return StringManager.getManager(pkgName);
            }
            String pkgName = callerClass.getName();
            return StringManager.getManager(pkgName);
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "iplanet_util.error_in_getMgr", e);
            return StringManager.getManager("");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        long b = System.currentTimeMillis();
        try {
            StringManager sm = StringManager.getManager("com.sun.enterprise.util.i18n");
            String ls = sm.getString("test", 7, new Date(System.currentTimeMillis()), "a disturbance in the Force");
            System.out.println(ls);
            System.out.println(sm.getString("bad"));
        }
        catch (Exception e) {
            System.out.println("---- Error ---- ");
            e.printStackTrace();
        }
        finally {
            long a = System.currentTimeMillis();
            System.out.println("Time: " + (a - b));
        }
    }
}

