/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.addons;

import com.sun.appserv.addons.AddonFatalException;
import com.sun.enterprise.addons.util.JarFileFilter;
import com.sun.enterprise.util.OS;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;

class AddonClassPath {
    private static final String CONFIG = "config";
    private static final String ASENVCONF = "asenv.conf";
    private static final String ASENVBAT = "asenv.bat";
    private static final String ASANTREGEX = "(AS_ANT_LIB=)";
    private static Logger logger = null;

    AddonClassPath() {
    }

    static URL[] getClassPath(URL jar, String installRoot, Logger logr) throws AddonFatalException {
        logger = logr;
        File asLib = new File(installRoot + File.separator + "lib");
        File antLib = AddonClassPath.getAntLib(installRoot);
        File[] asLibJars = asLib.listFiles(new JarFileFilter());
        File[] antLibJars = antLib.listFiles(new JarFileFilter());
        URL[] urls = new URL[asLibJars.length + antLibJars.length + 1];
        int i = 0;
        try {
            for (File asLibJar : asLibJars) {
                urls[i] = asLibJar.toURI().toURL();
                ++i;
            }
            for (File antLibJar : antLibJars) {
                urls[i] = antLibJar.toURI().toURL();
                ++i;
            }
        }
        catch (Exception e) {
            throw new AddonFatalException(e);
        }
        urls[i] = jar;
        return urls;
    }

    private static boolean isUnix() {
        return OS.isUnix();
    }

    private static File getAntLib(String installDir) throws AddonFatalException {
        BufferedReader bf = null;
        FileInputStream in = null;
        try {
            String asenv = "";
            asenv = AddonClassPath.isUnix() ? installDir + File.separator + CONFIG + File.separator + ASENVCONF : installDir + File.separator + CONFIG + File.separator + ASENVBAT;
            logger.log(Level.FINER, asenv);
            in = new FileInputStream(asenv);
            String antLib = "";
            bf = new BufferedReader(new InputStreamReader(in));
            String line = bf.readLine();
            while (line != null) {
                logger.log(Level.FINER, line);
                String[] asantLine = line.split(ASANTREGEX);
                if (asantLine.length > 1) {
                    if (AddonClassPath.isUnix()) {
                        asantLine = asantLine[1].split("\"");
                    }
                    antLib = asantLine[1];
                    logger.log(Level.FINER, "antLib " + antLib);
                    File file = new File(antLib);
                    return file;
                }
                line = bf.readLine();
            }
            File file = null;
            return file;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            throw new AddonFatalException(e);
        }
        finally {
            try {
                if (bf != null) {
                    bf.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e) {
                logger.log(Level.WARNING, e.getMessage(), e);
            }
        }
    }
}

