/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.addons;

import com.sun.appserv.addons.AddonException;
import com.sun.appserv.addons.AddonFatalException;
import com.sun.appserv.addons.InstallationContext;
import com.sun.appserv.addons.Installer;
import com.sun.enterprise.addons.AddonController;
import com.sun.enterprise.addons.util.InstallerFileFilter;
import com.sun.enterprise.addons.util.JarFileFilter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.lang.reflect.Method;
import java.nio.channels.FileChannel;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.logging.Level;

public class AddonInstallationController
extends AddonController {
    private final String SERVICEINTERFACE = "com.sun.appserv.addons.Installer";
    private final String METAINFSERVICE = "META-INF/services/";
    private final String ADDONS = "addons";

    protected File getServiceJarLocation() {
        return new File(this.getInstallRoot(), "addons");
    }

    protected String getServiceInterface() {
        return "META-INF/services/com.sun.appserv.addons.Installer";
    }

    protected FilenameFilter getFilenameFilter() {
        return new JarFileFilter();
    }

    protected String getName(File f) throws AddonFatalException {
        String regex = "(_installer)\\.([j|J][a|A][r|R])";
        String name = f.getName();
        if (name.matches(".*" + regex)) {
            return name.split(regex)[0];
        }
        throw new AddonFatalException(localStrings.getString("addon.notinstaller", (Object)name));
    }

    public void install(File installRoot) throws AddonFatalException {
        this.setInstallRoot(installRoot);
        this.loadServices(this.getServiceJarLocation());
        Set apiBasedServices = this.getApiBasedServices().entrySet();
        for (Map.Entry entry : apiBasedServices) {
            this._install(entry.getKey(), (String)entry.getValue());
        }
        Set mainClassBasedServices = this.getMainClassBasedServices().entrySet();
        for (Map.Entry entry : apiBasedServices) {
            if (this.getLogger().isLoggable(Level.FINER)) {
                this.getLogger().finer("Installing " + (String)entry.getValue());
            }
            Object obj = entry.getKey();
            String addonName = (String)entry.getValue();
            try {
                Method m = obj.getClass().getMethod("main", String[].class);
                String[] args = new String[]{this.getInstallRoot().getCanonicalPath()};
                m.invoke(obj, new Object[]{args});
                String addonInstalled = localStrings.getString("addon.installed", (Object)addonName);
                if (!this.getLogger().isLoggable(Level.INFO)) continue;
                this.getLogger().info(addonInstalled);
            }
            catch (Exception e) {
                this.getLogger().log(Level.FINE, "Fatal Exception while configuring the addon " + addonName, e);
                throw new AddonFatalException(e);
            }
        }
    }

    private void _install(Object obj, String addonName) throws AddonFatalException {
        Installer inst = (Installer)Installer.class.cast(obj);
        InstallationContext ic = new InstallationContext();
        ic.setInstallationDirectory(this.getInstallRoot());
        try {
            inst.install(ic);
            String addonInstalled = localStrings.getString("addon.installed", (Object)addonName);
            if (this.getLogger().isLoggable(Level.INFO)) {
                this.getLogger().info(addonInstalled);
            }
        }
        catch (AddonFatalException afe) {
            this.getLogger().log(Level.FINE, "Fatal Exception while installing the addon " + addonName, afe);
            throw afe;
        }
        catch (AddonException ae) {
            String msg = localStrings.getString("addon.installationcomplete.error", (Object)addonName, (Object)ae.getLocalizedMessage());
            this.getLogger().warning(msg);
        }
        catch (Exception e) {
            this.getLogger().log(Level.FINE, "Fatal Exception while installing the addon " + addonName, e);
            throw new AddonFatalException(e);
        }
    }

    private void _uninstall(Object obj, String addonName) throws AddonFatalException {
        Installer inst = (Installer)Installer.class.cast(obj);
        InstallationContext ic = new InstallationContext();
        ic.setInstallationDirectory(this.getInstallRoot());
        try {
            inst.uninstall(ic);
            if (this.getLogger().isLoggable(Level.INFO)) {
                this.getLogger().info(localStrings.getString("addon.uninstalled", (Object)addonName));
            }
        }
        catch (AddonFatalException afe) {
            this.getLogger().log(Level.FINE, "Fatal Exception while uninstalling the addon " + addonName, afe);
            throw afe;
        }
        catch (AddonException ae) {
            String msg = localStrings.getString("addon.uninstallationcomplete.error", (Object)addonName, (Object)ae.getLocalizedMessage());
            this.getLogger().warning(msg);
        }
        catch (Exception e) {
            this.getLogger().log(Level.FINE, "Fatal Exception while uninstalling the addon " + addonName, e);
            throw new AddonFatalException(e);
        }
    }

    public void uninstall(File installRoot, String addonName) throws AddonFatalException {
        try {
            this.setInstallRoot(installRoot);
            File addonDir = new File(installRoot, "addons");
            File[] files = addonDir.listFiles(new InstallerFileFilter(addonName));
            if (files == null || files.length == 0) {
                throw new AddonFatalException(localStrings.getString("addon.installernotfound", (Object)addonName));
            }
            if (files.length > 1) {
                throw new AddonFatalException(localStrings.getString("addon.morethanoneinstaller", (Object)addonName));
            }
            String service = this.findApiBasedService(new JarFile(files[0]));
            if (service == null) {
                throw new AddonFatalException(localStrings.getString("addon.servicenotfound", (Object)addonName, (Object)this.getServiceInterface()));
            }
            Object obj = this.createClassLoader(files[0].toURI().toURL()).loadClass(service).newInstance();
            this._uninstall(obj, addonName);
        }
        catch (Exception e) {
            throw new AddonFatalException(e);
        }
    }

    public void install(File installRoot, File jarFile) throws AddonFatalException {
        try {
            this.setInstallRoot(installRoot);
            String addonName = this.getName(jarFile);
            String service = this.findApiBasedService(new JarFile(jarFile));
            if (service != null) {
                String fileName = jarFile.getName();
                File addonDir = new File(installRoot, "addons");
                if (this.getLogger().isLoggable(Level.FINER)) {
                    this.getLogger().log(Level.FINER, "Addon Directory is :" + addonDir);
                }
                if (!addonDir.exists()) {
                    addonDir.mkdir();
                }
                if (!addonDir.equals(jarFile.getParentFile())) {
                    FileOutputStream destFile = new FileOutputStream(new File(addonDir, fileName));
                    FileChannel dstChannel = destFile.getChannel();
                    FileChannel srcChannel = new FileInputStream(jarFile).getChannel();
                    dstChannel.transferFrom(srcChannel, 0L, srcChannel.size());
                    srcChannel.close();
                    dstChannel.close();
                }
            } else {
                throw new AddonFatalException(localStrings.getString("addon.servicenotfound", (Object)addonName, (Object)this.getServiceInterface()));
            }
            Object obj = this.createClassLoader(jarFile.toURI().toURL()).loadClass(service).newInstance();
            this._install(obj, addonName);
        }
        catch (Exception e) {
            throw new AddonFatalException(e);
        }
    }

    public void uninstall(File installRoot) throws AddonFatalException {
        this.setInstallRoot(installRoot);
        this.loadServices(this.getServiceJarLocation());
        Set apiBasedServices = this.getApiBasedServices().entrySet();
        for (Map.Entry entry : apiBasedServices) {
            this._uninstall(entry.getKey(), (String)entry.getValue());
        }
    }
}

