/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.monitor.callflow;

import com.sun.enterprise.admin.monitor.callflow.AsyncHandlerIntf;
import com.sun.enterprise.admin.monitor.callflow.CallflowProducerQueue;
import com.sun.enterprise.admin.monitor.callflow.ComponentType;
import com.sun.enterprise.admin.monitor.callflow.ConsumerQProcessor;
import com.sun.enterprise.admin.monitor.callflow.ContainerTypeOrApplicationType;
import com.sun.enterprise.admin.monitor.callflow.DbAccessObjectImpl;
import com.sun.enterprise.admin.monitor.callflow.DbHandler;
import com.sun.enterprise.admin.monitor.callflow.EndTimeTO;
import com.sun.enterprise.admin.monitor.callflow.Handler;
import com.sun.enterprise.admin.monitor.callflow.HandlerChain;
import com.sun.enterprise.admin.monitor.callflow.MethodEndTO;
import com.sun.enterprise.admin.monitor.callflow.MethodStartTO;
import com.sun.enterprise.admin.monitor.callflow.RequestEndTO;
import com.sun.enterprise.admin.monitor.callflow.RequestStartTO;
import com.sun.enterprise.admin.monitor.callflow.RequestType;
import com.sun.enterprise.admin.monitor.callflow.StartTimeTO;
import com.sun.enterprise.admin.monitor.callflow.TraceOnHelper;
import com.sun.enterprise.admin.monitor.callflow.TransferObject;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AsyncHandlerProducer
implements AsyncHandlerIntf {
    private static final Logger logger = Logger.getLogger("javax.enterprise.system.tools.admin");
    public static final String Q_SIZE_PROPERTY = "com.sun.enterprise.callflow.qsize";
    private int qSize = 1000;
    public static final String CONTAINER_TIME_Q_SIZE_PROPERTY = "com.sun.enterprise.callflow.containertime.qsize";
    private int containerQSize = 1500;
    public static AsyncHandlerProducer _singleton;
    CallflowProducerQueue rsq;
    CallflowProducerQueue req;
    CallflowProducerQueue msq;
    CallflowProducerQueue meq;
    CallflowProducerQueue stq;
    CallflowProducerQueue etq;
    boolean traceOn = false;
    private static final BlockingQueue consumerQ;
    HandlerChain handlerChain;
    private ConsumerQProcessor consumerThread;
    private Thread consumer;
    boolean isThreadInitialized = false;
    private boolean enabled = false;

    private AsyncHandlerProducer() {
        this.setupQSizes();
        this.setupHandlerChain();
        this.consumerThread = new ConsumerQProcessor(consumerQ, this.handlerChain);
        this.traceOn = TraceOnHelper.isTraceOn();
    }

    private void setupHandlerChain() {
        this.handlerChain = new HandlerChain();
        this.handlerChain.addHandler(new DbHandler(DbAccessObjectImpl.getInstance()));
    }

    private void setupQSizes() {
        this.qSize = Math.abs(Integer.getInteger(Q_SIZE_PROPERTY, 1000));
        this.containerQSize = Math.abs(Integer.getInteger(CONTAINER_TIME_Q_SIZE_PROPERTY, 2000));
        if (this.containerQSize == this.containerQSize && this.qSize != this.qSize) {
            this.containerQSize = this.qSize * 3;
        }
        this.qSize = this.qSize;
        if (this.traceOn) {
            logger.log(Level.INFO, "Callflow : AsyncHandlerProducer: QSize = " + this.qSize + " Container Time Q Size =" + this.containerQSize);
        }
    }

    private void setupQs() {
        this.rsq = CallflowProducerQueue.getInstance(consumerQ, "RequestStartProducerQ", this.qSize);
        this.req = CallflowProducerQueue.getInstance(consumerQ, "RequestEndProducerQ", this.qSize);
        this.msq = CallflowProducerQueue.getInstance(consumerQ, "MethodStartProducerQ", this.qSize);
        this.meq = CallflowProducerQueue.getInstance(consumerQ, "MethodEndProducerQ", this.qSize);
        this.stq = CallflowProducerQueue.getInstance(consumerQ, "StartTimeProducerQ", this.containerQSize);
        this.etq = CallflowProducerQueue.getInstance(consumerQ, "EndTimeProducerQ", this.containerQSize);
    }

    private void clearQs() {
        this.rsq = null;
        this.req = null;
        this.msq = null;
        this.meq = null;
        this.stq = null;
        this.etq = null;
    }

    public static final AsyncHandlerIntf getInstance() {
        if (_singleton == null) {
            _singleton = new AsyncHandlerProducer();
        }
        return _singleton;
    }

    private Thread createThread() {
        Thread t = new Thread((Runnable)this.consumerThread, "CallFlow Async Consumer");
        t.setDaemon(true);
        return t;
    }

    public synchronized void enable() {
        if (!this.enabled) {
            try {
                if (!this.isThreadInitialized) {
                    this.consumer = null;
                    this.setupQs();
                    this.consumer = this.createThread();
                    this.consumer.start();
                    this.isThreadInitialized = true;
                }
            }
            catch (Exception e) {
                logger.log(Level.INFO, "Callflow - attempting to start asynchronous thread, but it is already on.Restart Server !", e);
            }
        }
        this.enabled = true;
        if (this.traceOn) {
            logger.log(Level.INFO, "Callflow: enable(AsyncProducerQ) Consumer thread started!");
        }
    }

    public synchronized void disable() {
        if (this.enabled) {
            this.flushQs();
            this.consumerThread.stopConsumerThread();
            this.isThreadInitialized = false;
            this.enabled = false;
            this.forceConsumption();
            this.clearQs();
        }
        if (this.traceOn) {
            logger.log(Level.INFO, "Callflow: (disable)AsynchProducerQ Consumer thread stopped!");
        }
    }

    private void forceConsumption() {
        int noOfQueues = consumerQ.size();
        if (noOfQueues == 0) {
            return;
        }
        if (this.traceOn) {
            logger.log(Level.INFO, "Callflow: disable(AsyncHandlerProducer) forcing write of Qs to the handlers");
        }
        Handler[] handler = this.handlerChain.getHandlers();
        for (int i = 0; i < noOfQueues; ++i) {
            TransferObject[] to;
            CallflowProducerQueue q = (CallflowProducerQueue)consumerQ.poll();
            if (q == null) continue;
            if (this.traceOn) {
                logger.log(Level.INFO, "Callflow: AsyncHandlerProducer.processProducerQ QName =" + q.getName());
            }
            if ((to = q.getAndRemoveAll()) == null) continue;
            for (int j = 0; j < handler.length; ++j) {
                handler[j].handle(to);
            }
        }
    }

    private void flushQs() {
        if (this.rsq != null) {
            this.rsq.flush();
        }
        if (this.req != null) {
            this.req.flush();
        }
        if (this.msq != null) {
            this.msq.flush();
        }
        if (this.meq != null) {
            this.meq.flush();
        }
        if (this.stq != null) {
            this.stq.flush();
        }
        if (this.etq != null) {
            this.etq.flush();
        }
    }

    public void handleRequestStart(String requestId, long timeStamp, long timeStampMillis, RequestType requestType, String callerIPAddress, String remoteUser) {
        RequestStartTO rsto = new RequestStartTO();
        rsto.setRequestId(requestId);
        rsto.setTimeStamp(timeStamp);
        rsto.setTimeStampMillis(timeStampMillis);
        rsto.setRequestType(requestType);
        rsto.setIpAddress(callerIPAddress);
        this.rsq.add(rsto);
        if (this.traceOn) {
            logger.log(Level.INFO, "Callflow: RequestStart (AsyncHandlerProducer) id = :" + requestId + " Type =" + requestType.toString());
        }
    }

    public void handleRequestEnd(String requestId, long timeStamp) {
        RequestEndTO reto = new RequestEndTO();
        reto.setRequestId(requestId);
        reto.setTimeStamp(timeStamp);
        this.req.add(reto);
        if (this.traceOn) {
            logger.log(Level.INFO, "Callflow: RequestEnd(AsyncHandlerProducer) id=" + requestId);
        }
    }

    public void handleMethodStart(String requestId, long timeStamp, String methodName, ComponentType componentType, String applicationName, String moduleName, String componentName, String threadId, String transactionId, String securityId) {
        MethodStartTO msto = new MethodStartTO();
        msto.setRequestId(requestId);
        msto.setTimeStamp(timeStamp);
        msto.setMethodName(methodName);
        msto.setComponentType(componentType);
        msto.setAppName(applicationName);
        msto.setModuleName(moduleName);
        msto.setComponentName(componentName);
        msto.setThreadId(threadId);
        msto.setTransactionId(transactionId);
        msto.setSecurityId(securityId);
        this.msq.add(msto);
        if (this.traceOn) {
            logger.log(Level.INFO, "Callflow: MethodStart(AsyncHandlerProducer)  id = " + requestId + " applicationName = " + applicationName);
        }
    }

    public void handleMethodEnd(String requestId, long timeStamp, Throwable exception) {
        MethodEndTO meto = new MethodEndTO();
        meto.setRequestId(requestId);
        meto.setTimeStamp(timeStamp);
        meto.setException(exception == null ? null : exception.toString());
        this.meq.add(meto);
        if (this.traceOn) {
            logger.log(Level.INFO, "Callflow: MethodEnd(AsyncHandlerProducer). id = " + requestId);
        }
    }

    public void handleStartTime(String requestId, long timeStamp, ContainerTypeOrApplicationType type) {
        StartTimeTO stto = new StartTimeTO();
        stto.setRequestId(requestId);
        stto.setTimeStamp(timeStamp);
        stto.setContainerTypeOrApplicationType(type);
        this.stq.add(stto);
        if (this.traceOn) {
            logger.log(Level.INFO, "Callflow: StartTime(AsyncHandlerProducer)id = " + requestId);
        }
    }

    public void handleEndTime(String requestId, long timeStamp, ContainerTypeOrApplicationType type) {
        EndTimeTO etto = new EndTimeTO();
        etto.setRequestId(requestId);
        etto.setTimeStamp(timeStamp);
        etto.setContainerTypeOrApplicationType(type);
        this.etq.add(etto);
        if (this.traceOn) {
            logger.log(Level.INFO, "Callflow: EndTime(AsyncHandlerProducer) id=" + requestId);
        }
    }

    public void flush() {
        this.flushQs();
        this.forceConsumption();
    }

    static {
        consumerQ = new LinkedBlockingQueue(6);
    }
}

