/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt;

import com.sun.enterprise.admin.jmx.remote.https.AsadminTruststore;
import com.sun.enterprise.admin.servermgmt.RepositoryConfig;
import com.sun.enterprise.admin.servermgmt.RepositoryException;
import com.sun.enterprise.admin.servermgmt.pe.PEFileLayout;
import com.sun.enterprise.util.ExecException;
import com.sun.enterprise.util.OS;
import com.sun.enterprise.util.ProcessExecutor;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.util.net.NetUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public class KeystoreManager {
    private static final String KEYTOOL_CMD = System.getProperty("com.sun.aas.javaRoot") + "/bin/keytool";
    private static String CERTIFICATE_DN_PREFIX = "CN=";
    private static String CERTIFICATE_DN_SUFFIX = ",OU=Sun Java System Application Server,O=Sun Microsystems,L=Santa Clara,ST=California,C=US";
    private static String _certificateDN = null;
    public static final String CERTIFICATE_ALIAS = "s1as";
    public static final String DEFAULT_MASTER_PASSWORD = "changeit";
    private static final String SKID_EXTENSION_SYSTEM_PROPERTY = "-J-Dsun.security.internal.keytool.skid";
    protected PEFileLayout _fileLayout = null;
    private static final StringManager _strMgr = StringManager.getManager(KeystoreManager.class);

    protected String getCertificateDN(String domainName) {
        if (_certificateDN == null) {
            String hostName = null;
            try {
                hostName = NetUtils.getCanonicalHostName();
            }
            catch (Exception ex) {
                hostName = "localhost";
            }
            _certificateDN = CERTIFICATE_DN_PREFIX + hostName + CERTIFICATE_DN_SUFFIX;
        }
        return _certificateDN;
    }

    protected PEFileLayout getFileLayout(RepositoryConfig config) {
        if (this._fileLayout == null) {
            this._fileLayout = new PEFileLayout(config);
        }
        return this._fileLayout;
    }

    protected void createSSLCertificateDatabase(RepositoryConfig config, String masterPassword) throws RepositoryException {
        this.createKeyStore(config, masterPassword);
        this.createTrustStore(config, masterPassword);
    }

    protected void createKeyStore(RepositoryConfig config, String masterPassword) throws RepositoryException {
        PEFileLayout layout = this.getFileLayout(config);
        File keystore = layout.getKeyStore();
        String[] keytoolCmd = new String[]{"-genkey", "-keyalg", "RSA", "-keystore", keystore.getAbsolutePath(), "-alias", CERTIFICATE_ALIAS, "-dname", this.getCertificateDN(config.getDisplayName()), "-validity", "3650", "-keypass", masterPassword, "-storepass", masterPassword, SKID_EXTENSION_SYSTEM_PROPERTY};
        KeytoolExecutor p = new KeytoolExecutor(keytoolCmd, 60L);
        p.execute("keystoreNotCreated", keystore);
    }

    protected void addToAsadminTrustStore(RepositoryConfig config, File certFile) throws RepositoryException {
        boolean newTruststore = false;
        PEFileLayout layout = this.getFileLayout(config);
        File asadminTruststore = AsadminTruststore.getAsadminTruststore();
        if (!asadminTruststore.exists()) {
            newTruststore = true;
        }
        String aliasName = layout.getRepositoryDir().getAbsolutePath();
        String[] keytoolCmd = new String[]{"-delete", "-keystore", asadminTruststore.getAbsolutePath(), "-alias", aliasName};
        String[] input = new String[]{AsadminTruststore.getAsadminTruststorePassword(), AsadminTruststore.getAsadminTruststorePassword()};
        KeytoolExecutor p = new KeytoolExecutor(keytoolCmd, 30L, input);
        try {
            p.execute("trustStoreNotCreated", asadminTruststore);
        }
        catch (RepositoryException ex) {
            // empty catch block
        }
        keytoolCmd = new String[]{"-import", "-noprompt", "-keystore", asadminTruststore.getAbsolutePath(), "-alias", aliasName, "-file", certFile.getAbsolutePath()};
        p = new KeytoolExecutor(keytoolCmd, 30L, input);
        p.execute("trustStoreNotCreated", asadminTruststore);
        if (newTruststore) {
            try {
                this.chmod("600", asadminTruststore);
            }
            catch (IOException ex) {
                throw new RepositoryException(_strMgr.getString("trustStoreNotCreated", (Object)asadminTruststore), ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createTrustStore(RepositoryConfig config, String masterPassword) throws RepositoryException {
        PEFileLayout layout = this.getFileLayout(config);
        File src = layout.getTrustStoreTemplate();
        File truststore = layout.getTrustStore();
        File certFile = null;
        try {
            FileUtils.copy(src, truststore);
        }
        catch (IOException ioe) {
            throw new RepositoryException(_strMgr.getString("trustStoreNotCreated", (Object)truststore), ioe);
        }
        try {
            String[] input = new String[]{masterPassword};
            String[] keytoolCmd = null;
            KeytoolExecutor p = null;
            this.changeKeystorePassword(DEFAULT_MASTER_PASSWORD, masterPassword, truststore);
            certFile = new File(layout.getConfigRoot(), "s1as.cer");
            keytoolCmd = new String[]{"-export", "-keystore", layout.getKeyStore().getAbsolutePath(), "-alias", CERTIFICATE_ALIAS, "-file", certFile.getAbsolutePath()};
            p = new KeytoolExecutor(keytoolCmd, 30L, input);
            p.execute("trustStoreNotCreated", truststore);
            keytoolCmd = new String[]{"-import", "-noprompt", "-keystore", truststore.getAbsolutePath(), "-alias", CERTIFICATE_ALIAS, "-file", certFile.getAbsolutePath()};
            p = new KeytoolExecutor(keytoolCmd, 30L, input);
            p.execute("trustStoreNotCreated", truststore);
            this.addToAsadminTrustStore(config, certFile);
            certFile.delete();
            certFile = null;
        }
        finally {
            if (certFile != null) {
                certFile.delete();
            }
        }
    }

    protected void changeKeystorePassword(String oldPassword, String newPassword, File keystore) throws RepositoryException {
        if (!oldPassword.equals(newPassword)) {
            String[] keytoolCmd = new String[]{"-storepasswd", "-keystore", keystore.getAbsolutePath()};
            KeytoolExecutor p = new KeytoolExecutor(keytoolCmd, 30L, new String[]{oldPassword, newPassword, newPassword});
            p.execute("keyStorePasswordNotChanged", keystore);
        }
    }

    protected void changeS1ASAliasPassword(RepositoryConfig config, String storePassword, String oldKeyPassword, String newKeyPassword) throws RepositoryException {
        if (!storePassword.equals(oldKeyPassword) && !oldKeyPassword.equals(newKeyPassword)) {
            PEFileLayout layout = this.getFileLayout(config);
            File src = layout.getTrustStoreTemplate();
            File keystore = layout.getKeyStore();
            String[] keytoolCmd = new String[]{"-list", "-keystore", keystore.getAbsolutePath(), "-alias", CERTIFICATE_ALIAS};
            KeytoolExecutor p = new KeytoolExecutor(keytoolCmd, 30L, new String[]{storePassword});
            try {
                p.execute("s1asKeyPasswordNotChanged", keystore);
            }
            catch (RepositoryException ex) {
                return;
            }
            keytoolCmd = new String[]{"-keypasswd", "-keystore", keystore.getAbsolutePath(), "-alias", CERTIFICATE_ALIAS};
            p = new KeytoolExecutor(keytoolCmd, 30L, new String[]{storePassword, oldKeyPassword, newKeyPassword, newKeyPassword});
            p.execute("s1asKeyPasswordNotChanged", keystore);
        }
    }

    protected void changeSSLCertificateDatabasePassword(RepositoryConfig config, String oldPassword, String newPassword) throws RepositoryException {
        PEFileLayout layout = this.getFileLayout(config);
        File keystore = layout.getKeyStore();
        File truststore = layout.getTrustStore();
        if (keystore.exists()) {
            this.changeKeystorePassword(oldPassword, newPassword, keystore);
            try {
                this.changeS1ASAliasPassword(config, newPassword, oldPassword, newPassword);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (truststore.exists()) {
            this.changeKeystorePassword(oldPassword, newPassword, truststore);
        }
    }

    protected void chmod(String args, File file) throws IOException {
        if (OS.isUNIX()) {
            if (args == null || file == null) {
                throw new IOException(_strMgr.getString("nullArg"));
            }
            if (!file.exists()) {
                throw new IOException(_strMgr.getString("fileNotFound"));
            }
            String[] argsString = args.split(" +");
            ArrayList<String> cmdList = new ArrayList<String>();
            cmdList.add("/bin/chmod");
            for (String arg : argsString) {
                cmdList.add(arg);
            }
            cmdList.add(file.getAbsolutePath());
            new ProcessBuilder(cmdList).start();
        }
    }

    protected class KeytoolExecutor
    extends ProcessExecutor {
        public KeytoolExecutor(String[] args, long timeoutInSeconds) {
            super(args, timeoutInSeconds);
            this.setExecutionRetentionFlag(true);
            this.addKeytoolCommand();
        }

        public KeytoolExecutor(String[] args, long timeoutInSeconds, String[] inputLines) {
            super(args, timeoutInSeconds, inputLines);
            this.setExecutionRetentionFlag(true);
            this.addKeytoolCommand();
        }

        protected String getExceptionMessage() {
            return this.getLatestOutput(this.mOutFile) + " " + this.getFileBuffer(this.mErrFile);
        }

        private void addKeytoolCommand() {
            if (!this.mCmdStrings[0].equals(KEYTOOL_CMD)) {
                String[] newArgs = new String[this.mCmdStrings.length + 1];
                newArgs[0] = KEYTOOL_CMD;
                System.arraycopy(this.mCmdStrings, 0, newArgs, 1, this.mCmdStrings.length);
                this.mCmdStrings = newArgs;
            }
        }

        public void execute(String keystoreErrorMsg, File keystoreName) throws RepositoryException {
            try {
                super.execute();
                if (this.getProcessExitValue() != 0) {
                    throw new RepositoryException(_strMgr.getString(keystoreErrorMsg, (Object)keystoreName) + this.getLastExecutionError() + " " + this.getLastExecutionOutput());
                }
            }
            catch (ExecException ex) {
                throw new RepositoryException(_strMgr.getString(keystoreErrorMsg, (Object)keystoreName) + this.getLastExecutionError() + " " + this.getLastExecutionOutput(), ex);
            }
        }
    }
}

