/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt.launch;

import com.sun.enterprise.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TokenResolver {
    private final Properties props;

    TokenResolver(Properties p) {
        this.props = p;
    }

    void resolve(List<String> list) {
        for (int i = 0; i < list.size(); ++i) {
            String s = list.get(i);
            if (!TokenResolver.hasToken(s)) continue;
            list.set(i, this.resolve(s));
        }
    }

    String resolve(String s) {
        List<Token> tokens = this.getTokens(s);
        String resolved = s;
        for (Token token : tokens) {
            resolved = StringUtils.replace(resolved, token.token, token.value);
        }
        return resolved;
    }

    private List<Token> getTokens(String s) {
        Token token;
        int index = 0;
        ArrayList<Token> tokens = new ArrayList<Token>();
        while ((token = this.getToken(s, index)) != null) {
            tokens.add(token);
            index = token.start + "${".length();
        }
        return tokens;
    }

    private Token getToken(String s, int index) {
        if (s == null || index >= s.length()) {
            return null;
        }
        Token token = new Token();
        token.start = s.indexOf("${", index);
        token.end = s.indexOf("}", token.start + 2);
        if (token.end <= 0 || token.start < 0) {
            return null;
        }
        token.token = s.substring(token.start, token.end + 1);
        token.name = s.substring(token.start + "${".length(), token.end);
        token.value = this.props.getProperty(token.name, token.token);
        return token;
    }

    private static boolean hasToken(String s) {
        return s != null && s.indexOf("${") >= 0;
    }

    private static class Token {
        int start;
        int end;
        String token;
        String name;
        String value;
        static final String TOKEN_START = "${";
        static final String TOKEN_END = "}";

        private Token() {
        }

        public String toString() {
            return "name: " + this.name + ", token: " + this.token + ", value: " + this.value;
        }
    }
}

