/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.config;

import com.sun.appserv.management.base.AMX;
import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.config.ClusterConfig;
import com.sun.appserv.management.config.ServerRefConfig;
import com.sun.appserv.management.util.misc.MapUtil;
import com.sun.enterprise.management.config.ConfigFactoryCallback;
import com.sun.enterprise.management.config.StandaloneServerConfigFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClusteredServerConfigFactory
extends StandaloneServerConfigFactory {
    public ClusteredServerConfigFactory(ConfigFactoryCallback callbacks) {
        super(callbacks);
    }

    private boolean getLBEnabled(ClusterConfig clusterConfig) {
        Map<String, ServerRefConfig> refs = clusterConfig.getServerRefConfigMap();
        boolean enabled = false;
        if (refs.keySet().size() != 0) {
            ServerRefConfig first = refs.values().iterator().next();
            enabled = first.getLBEnabled();
        }
        return enabled;
    }

    @Override
    public ObjectName create(String serverName, String clusterName, String nodeAgentName, Map<String, String> optional) {
        ClusterConfig clusterConfig = this.getDomainConfig().getClusterConfigMap().get(clusterName);
        if (clusterConfig == null) {
            throw new IllegalArgumentException("" + clusterName);
        }
        String configName = clusterConfig.getReferencedConfigName();
        this.debug("creating server:\n" + (optional == null ? "null" : MapUtil.toString(optional)));
        ObjectName serverObjectName = super.create(serverName, nodeAgentName, configName, optional);
        this.debug("created server: " + serverName + " in cluster " + clusterName + "with node agent " + nodeAgentName);
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("Enabled", "true");
        options.put("LBEnabled", "" + this.getLBEnabled(clusterConfig));
        this.debug("creating reference");
        ServerRefConfig refConfig = clusterConfig.createServerRefConfig(serverName, options);
        this.debug("created reference");
        String props = Util.makeRequiredProps("X-ClusteredServerConfig", serverName);
        Set s = null;
        while ((s = this.getQueryMgr().queryPropsSet(props)).size() == 0) {
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        return Util.getObjectName((AMX)s.iterator().next());
    }

    private ClusterConfig findClusterForClusteredServer(String clusteredServerName) {
        ClusterConfig clusterConfig = null;
        Map<String, ClusterConfig> clusters = this.getDomainConfig().getClusterConfigMap();
        for (ClusterConfig cc : clusters.values()) {
            Map<String, ServerRefConfig> servers = cc.getServerRefConfigMap();
            if (!servers.keySet().contains(clusteredServerName)) continue;
            clusterConfig = cc;
            break;
        }
        return clusterConfig;
    }

    @Override
    protected void removeByName(String clusteredServerName) {
        ClusterConfig clusterConfig = this.findClusterForClusteredServer(clusteredServerName);
        if (clusterConfig == null) {
            throw new IllegalArgumentException("" + clusteredServerName);
        }
        super.removeByName(clusteredServerName);
    }
}

