/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.config;

import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.deploy.DeploymentStatus;
import com.sun.appserv.management.deploy.DeploymentSupport;
import com.sun.appserv.management.util.jmx.JMXUtil;
import com.sun.appserv.management.util.misc.GSetUtil;
import com.sun.appserv.management.util.misc.MapUtil;
import com.sun.appserv.management.util.misc.TypeCast;
import com.sun.enterprise.management.config.ConfigFactory;
import com.sun.enterprise.management.config.ConfigFactoryCallback;
import com.sun.enterprise.management.support.oldconfig.OldApplicationsConfigMBean;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.management.AttributeList;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeployedItemRefConfigFactory
extends ConfigFactory {
    private final OldApplicationsConfigMBean mOldApplicationsConfigMBean;
    private final Set<String> LEGAL_OPTIONAL_KEYS = GSetUtil.newUnmodifiableStringSet("Enabled", "VirtualServers", "LBEnabled", "DisableTimeoutInMinutes");

    public DeployedItemRefConfigFactory(ConfigFactoryCallback callbacks) {
        super(callbacks);
        this.mOldApplicationsConfigMBean = this.getOldConfigProxies().getOldApplicationsConfigMBean();
    }

    @Override
    protected Set<String> getLegalOptionalCreateKeys() {
        return this.LEGAL_OPTIONAL_KEYS;
    }

    @Override
    protected Map<String, String> getParamNameOverrides() {
        return MapUtil.newMap("Name", "ref");
    }

    public ObjectName create(String referencedApplicationName, Map<String, String> optional) {
        this.trace("DeployedItemRefConfigFactory.create: creating using: ");
        Map<String, String> params = this.initParams(referencedApplicationName, null, optional);
        this.trace("params as processed: " + this.stringify(params));
        ObjectName amxName = this.createNamedChild(referencedApplicationName, params);
        return amxName;
    }

    public ObjectName create(String referencedApplicationName, boolean enabled, String virtualServers, boolean lbEnabled, int disableTimeoutInMinutes) {
        HashMap<String, String> optionalParams = new HashMap<String, String>();
        DeployedItemRefConfigFactory.putNonNull(optionalParams, "Enabled", Boolean.toString(enabled));
        DeployedItemRefConfigFactory.putNonNull(optionalParams, "VirtualServers", virtualServers);
        DeployedItemRefConfigFactory.putNonNull(optionalParams, "LBEnabled", Boolean.toString(lbEnabled));
        DeployedItemRefConfigFactory.putNonNull(optionalParams, "DisableTimeoutInMinutes", Integer.toString(disableTimeoutInMinutes));
        ObjectName amxName = this.create(referencedApplicationName, optionalParams);
        return amxName;
    }

    public ObjectName create(String referencedApplicationName) {
        return this.create(referencedApplicationName, null);
    }

    @Override
    public void internalRemove(ObjectName objectName) {
        String containerName = this.getFactoryContainer().getName();
        this.mOldApplicationsConfigMBean.deleteApplicationReferenceAndReturnStatusAsMap(containerName, Util.getName(objectName), null);
    }

    @Override
    protected ObjectName createOldChildConfig(AttributeList translatedAttrs) {
        String appRef;
        Map<String, String> attributeMap;
        block4: {
            this.trace("createOldChildConfig: attrs: " + this.stringify(translatedAttrs));
            String REF_KEY = "ref";
            attributeMap = JMXUtil.attributeListToStringMap(translatedAttrs);
            appRef = null;
            try {
                appRef = attributeMap.remove("ref");
            }
            catch (UnsupportedOperationException uoe) {
                if ($assertionsDisabled) break block4;
                throw new AssertionError();
            }
        }
        assert (appRef != null);
        String target = this.getFactoryContainer().getName();
        assert (target != null);
        ObjectName on = this.createApplicationRef(appRef, target, attributeMap);
        return on;
    }

    private ObjectName createApplicationRef(String ref, String target, Map<String, String> optional) {
        Map<String, Serializable> m = TypeCast.checkMap(this.mOldApplicationsConfigMBean.createApplicationReferenceAndReturnStatusAsMap(target, ref, optional), String.class, Serializable.class);
        this.checkDeploymentStatusForExceptions(m);
        String targetJ2EEType = this.getFactoryContainer().getJ2EEType();
        ObjectName on = null;
        if ("X-StandaloneServerConfig".equals(targetJ2EEType)) {
            on = this.getOldConfigProxies().getOldServerMBean(target).getApplicationRefByRef(ref);
        } else if ("X-ClusterConfig".equals(targetJ2EEType)) {
            on = this.getOldConfigProxies().getOldClusterMBean(target).getApplicationRefByRef(ref);
        } else {
            throw new RuntimeException("Application refs can be created only on clusters and standalone servers");
        }
        return on;
    }

    private void checkDeploymentStatusForExceptions(Map<String, Serializable> m) {
        DeploymentStatus status2 = DeploymentSupport.mapToDeploymentStatus(m);
        Throwable t = status2.getStageThrowable();
        Iterator<DeploymentStatus> it = status2.getSubStagesList().iterator();
        while (t == null && it.hasNext()) {
            status2 = it.next();
            t = status2.getThrowable();
        }
        if (null != t) {
            throw new RuntimeException(status2.getStageStatusMessage());
        }
    }
}

