/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.config;

import com.sun.appserv.management.util.misc.GSetUtil;
import com.sun.enterprise.admin.wsmgmt.WebServiceMgrBackEnd;
import com.sun.enterprise.management.config.ConfigFactory;
import com.sun.enterprise.management.config.ConfigFactoryCallback;
import com.sun.enterprise.management.support.oldconfig.OldWebServiceEndpointConfigMBean;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.management.AttributeList;
import javax.management.ObjectName;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TransformationRuleConfigFactory
extends ConfigFactory {
    private final OldWebServiceEndpointConfigMBean mOldWebServiceEndpointConfigMBean;
    private TransformerFactory _tFactory;
    private final Set<String> LEGAL_OPTIONAL_KEYS = GSetUtil.newUnmodifiableStringSet("Enabled", "ApplyTo");
    private static final String CREATE_TRANSFORMATION_RULE = "createTransformationRule";
    private static final String[] CREATE_TRANSFORMATION_RULE_SIG = new String[]{AttributeList.class.getName()};
    private static final String REMOVE_TRANSFORMATION_RULE = "removeTransformationRuleByName";
    private static final String[] REMOVE_TRANSFORMATION_RULE_SIG = new String[]{String.class.getName()};

    public TransformationRuleConfigFactory(ConfigFactoryCallback callbacks) {
        super(callbacks);
        this._tFactory = TransformerFactory.newInstance();
        this.mOldWebServiceEndpointConfigMBean = this.getOldWebServiceEndpointConfigMBean();
    }

    private final OldWebServiceEndpointConfigMBean getOldWebServiceEndpointConfigMBean() {
        String name = this.getFactoryContainer().getName();
        return this.getOldConfigProxies().getOldWebServiceEndpointConfigMBean(name);
    }

    @Override
    protected ObjectName createOldChildConfig(AttributeList translatedAttrs) {
        ObjectName oldObjectName = (ObjectName)this.getCallbacks().getDelegate().invoke(CREATE_TRANSFORMATION_RULE, new Object[]{translatedAttrs}, CREATE_TRANSFORMATION_RULE_SIG);
        return oldObjectName;
    }

    public ObjectName create(String name, String ruleFileLocation, boolean enabled, String applyTo, Map<String, String> reserved) {
        String appId = this.getFactoryContainer().getContainer().getName();
        String finalRuleFileLocation = null;
        try {
            StreamSource stylesource = new StreamSource(new File(ruleFileLocation));
            Transformer transformer = this._tFactory.newTransformer(stylesource);
            finalRuleFileLocation = WebServiceMgrBackEnd.getManager().moveFileToRepository(ruleFileLocation, appId);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        HashMap<String, String> optional = new HashMap<String, String>();
        optional.put("Enabled", Boolean.toString(enabled));
        optional.put("ApplyTo", applyTo);
        String[] requiredParams = new String[]{"RuleFileLocation", finalRuleFileLocation};
        if (reserved != null) {
            optional.putAll(reserved);
        }
        Map<String, String> params = this.initParams(name, requiredParams, optional);
        this.trace("params as processed: " + this.stringify(params));
        ObjectName amxName = this.createChild(params);
        return amxName;
    }

    @Override
    protected final void removeByName(String name) {
        String appId = this.getFactoryContainer().getContainer().getName();
        String epName = this.getFactoryContainer().getName();
        WebServiceMgrBackEnd.getManager().removeFileFromRepository(appId, epName, name);
        this.mOldWebServiceEndpointConfigMBean.removeTransformationRuleByName(name);
    }

    @Override
    protected Set<String> getLegalOptionalCreateKeys() {
        return this.LEGAL_OPTIONAL_KEYS;
    }
}

