/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.ext.lb;

import com.sun.appserv.management.config.LBConfig;
import com.sun.appserv.management.config.LoadBalancerConfig;
import com.sun.appserv.management.ext.lb.LoadBalancer;
import com.sun.enterprise.management.support.AMXImplBase;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.server.pluggable.LBFeatureFactory;
import com.sun.enterprise.server.pluggable.PluggableFeatureFactory;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.logging.Level;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public final class LoadBalancerImpl
extends AMXImplBase
implements LoadBalancer {
    private static final String COMMA = ",";
    private static final String COLON = ":";
    private static final String EQUAL = "=";
    public static final String NAME_PROP_VALUE = "load-balancer";
    public static final String LAST_APPLIED_PROPERTY = "last-applied";
    public static final String LAST_APPLIED_HASH_PROPERTY = "last-applied-message-digest";
    public static final String LAST_EXPORTED_PROPERTY = "last-exported";
    public static final String LOADBALANCER_CONFIG_OBJECT_NAME = "amx:j2eeType=X-LoadBalancerConfig,name=";
    public static final String LBCONFIG_OBJECT_NAME = "amx:j2eeType=X-LBConfig,name=";
    public static final String LOADBALANCER_OBJECT_NAME = "amx:j2eeType=X-LoadBalancer,name=";
    private static final String XML_COMMENT_START = "<!--";
    private static final String MD5 = "MD5";
    private final LBFeatureFactory lbFactory;
    private final LoadBalancerConfig loadBalancerConfig;
    private final MBeanServerConnection mServer;

    public LoadBalancerImpl(MBeanServerConnection server, LoadBalancerConfig loadBalancerConfigIn) {
        if (loadBalancerConfigIn == null) {
            throw new IllegalArgumentException();
        }
        this.mServer = server;
        this.loadBalancerConfig = loadBalancerConfigIn;
        PluggableFeatureFactory featureFactory = ApplicationServer.getServerContext().getPluggableFeatureFactory();
        this.lbFactory = featureFactory.getLBFeatureFactory();
        if (this.lbFactory == null) {
            throw new IllegalStateException();
        }
    }

    public void applyLBChanges() {
        String lbConfigName = this.loadBalancerConfig.getLbConfigName();
        this.lbFactory.applyChanges(lbConfigName, this.getName());
        if (!this.loadBalancerConfig.existsProperty(LAST_APPLIED_PROPERTY)) {
            this.loadBalancerConfig.createProperty(LAST_APPLIED_PROPERTY, String.valueOf(new Date().getTime()));
        } else {
            this.loadBalancerConfig.setPropertyValue(LAST_APPLIED_PROPERTY, String.valueOf(new Date().getTime()));
        }
        String digest = this.getMessageDigest();
        if (!this.loadBalancerConfig.existsProperty(LAST_APPLIED_HASH_PROPERTY)) {
            this.loadBalancerConfig.createProperty(LAST_APPLIED_HASH_PROPERTY, digest);
        } else {
            this.loadBalancerConfig.setPropertyValue(LAST_APPLIED_HASH_PROPERTY, digest);
        }
    }

    public boolean isApplyChangeRequired() {
        boolean isRequired;
        block3: {
            isRequired = true;
            try {
                String digest = this.getMessageDigest();
                String lastDigest = this.getLastAppliedMessageDigest();
                if (lastDigest != null) {
                    isRequired = !digest.equals(lastDigest);
                }
            }
            catch (Throwable t) {
                this.getMBeanLogger().warning(t.getMessage());
                if (!this.getMBeanLogger().isLoggable(Level.FINE)) break block3;
                t.printStackTrace();
            }
        }
        return isRequired;
    }

    public Date getLastApplied() {
        String lbName = this.getName();
        if (this.loadBalancerConfig.existsProperty(LAST_APPLIED_PROPERTY)) {
            return new Date(Long.valueOf(this.loadBalancerConfig.getPropertyValue(LAST_APPLIED_PROPERTY)));
        }
        return null;
    }

    public String getLastAppliedMessageDigest() {
        String lbName = this.getName();
        if (this.loadBalancerConfig.existsProperty(LAST_APPLIED_HASH_PROPERTY)) {
            return this.loadBalancerConfig.getPropertyValue(LAST_APPLIED_HASH_PROPERTY);
        }
        return null;
    }

    public Date getLastExported() {
        String lbName = this.getName();
        String lbConfigName = this.loadBalancerConfig.getLbConfigName();
        LBConfig lbConfig = this.getLBConfig(lbConfigName);
        if (lbConfig.existsProperty(LAST_EXPORTED_PROPERTY)) {
            return new Date(Long.valueOf(lbConfig.getPropertyValue(LAST_EXPORTED_PROPERTY)));
        }
        return null;
    }

    public String getLoadBalancerXML() {
        return this.getLoadBalancerXML(true);
    }

    private LBConfig getLBConfig(String lbConfigName) {
        ObjectName lbConfigObjName = null;
        try {
            lbConfigObjName = new ObjectName(LBCONFIG_OBJECT_NAME + lbConfigName);
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
        }
        LBConfig lbConfig = this.getProxy(lbConfigObjName, LBConfig.class);
        return lbConfig;
    }

    private String getLoadBalancerXML(boolean updateTimeStamp) {
        String lbName = this.getName();
        String lbConfigName = this.loadBalancerConfig.getLbConfigName();
        LBConfig lbConfig = this.getLBConfig(lbConfigName);
        if (updateTimeStamp) {
            if (!lbConfig.existsProperty(LAST_EXPORTED_PROPERTY)) {
                lbConfig.createProperty(LAST_EXPORTED_PROPERTY, String.valueOf(new Date().getTime()));
            } else {
                lbConfig.setPropertyValue(LAST_EXPORTED_PROPERTY, String.valueOf(new Date().getTime()));
            }
        }
        return this.lbFactory.getLoadBalancerXML(lbConfigName, lbName);
    }

    private String getMessageDigest() {
        try {
            String lbxml = this.getLoadBalancerXML(false).split(XML_COMMENT_START)[0];
            MessageDigest md = MessageDigest.getInstance(MD5);
            md.update(lbxml.getBytes());
            String hash = new BigInteger(md.digest()).toString(16);
            return hash;
        }
        catch (NoSuchAlgorithmException e) {
            this.getMBeanLogger().warning(e.getMessage());
            if (this.getMBeanLogger().isLoggable(Level.FINE)) {
                e.printStackTrace();
            }
            return "";
        }
    }

    public Date getLastResetTime() {
        return null;
    }

    public void resetStats() {
        String lbName = this.getName();
        String lbConfigName = this.loadBalancerConfig.getLbConfigName();
        this.lbFactory.resetStats(lbConfigName, lbName);
    }

    public boolean testConnection() {
        String lbName = this.getName();
        String lbConfigName = this.loadBalancerConfig.getLbConfigName();
        return this.lbFactory.testConnection(lbConfigName, lbName);
    }

    public String getStatus(String instanceName) {
        return null;
    }
}

