/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.offline;

import com.sun.enterprise.management.offline.AMXLoader;
import com.sun.enterprise.management.offline.ConfigDelegateFactory;
import com.sun.enterprise.management.offline.OfflineLoaderMBean;
import com.sun.enterprise.management.support.BootUtil;
import com.sun.enterprise.management.support.MBeanImplBase;
import java.io.File;
import java.util.logging.Logger;
import javax.management.MBeanServer;

public final class OfflineLoader
extends MBeanImplBase
implements OfflineLoaderMBean {
    private final File mDomainXML;
    final MBeanServer mServer;
    final ConfigDelegateFactory mDelegateFactory;
    private final AMXLoader mAMXLoader;

    public OfflineLoader(MBeanServer server, File domainXML) {
        this.mServer = server;
        this.mDomainXML = domainXML;
        boolean offline = true;
        BootUtil.init(true);
        try {
            this.mDelegateFactory = ConfigDelegateFactory.getInstance(this.mDomainXML);
            this.mAMXLoader = new AMXLoader(this.mServer, this.mDelegateFactory);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        this.start();
    }

    protected String getDebugID() {
        return "OfflineLoader";
    }

    protected void sdebug(Object o) {
        this.debug(o);
        System.out.println("" + o);
    }

    public String getAMXJMXDomainName() {
        return BootUtil.getInstance().getAMXJMXDomainName();
    }

    public String getAdministrativeDomainName() {
        return BootUtil.getInstance().getAppserverDomainName();
    }

    protected Logger createLogger() {
        return Logger.getLogger(this.getClass().getName());
    }

    private void start() {
        try {
            this.mAMXLoader.loadAll();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        BootUtil.getInstance().setAMXReady(true);
    }
}

