/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.support;

import com.sun.appserv.management.base.DottedNames;
import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.helper.AMXDebugHelper;
import com.sun.appserv.management.util.jmx.JMXUtil;
import com.sun.appserv.management.util.misc.GSetUtil;
import com.sun.appserv.management.util.misc.RunnableBase;
import com.sun.enterprise.management.support.AMXImplBase;
import com.sun.enterprise.util.FeatureAvailability;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import javax.management.ReflectionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DottedNamesBase
extends AMXImplBase
implements DottedNames {
    private static final String DOTTED_NAMES = "com.sun.appserv:name=dotted-name-get-set,type=dotted-name-support";
    protected volatile OldDottedNamesProxy mOldDottedNamesProxy = null;
    private MBeanInfo mMBeanInfo = null;
    private Map<String, Attribute> mAttributes;
    private Set<String> mParentAttributeNames = null;
    protected final AMXDebugHelper mDebugHelper = new AMXDebugHelper("DottedNamesBase");
    private static final String ALL_DOTTED_NAMES = "*";
    protected volatile boolean mRefreshNeeded = false;
    protected final ReentrantLock mRefreshLock = new ReentrantLock();

    protected void debugMsg(Object ... args) {
        this.mDebugHelper.println(args);
    }

    public DottedNamesBase() {
        this.debugMsg("DottedNamesBase: " + this.getClass().getName());
        this.mDebugHelper.setEchoToStdOut(true);
    }

    @Override
    public abstract Object[] dottedNameGet(String[] var1);

    @Override
    public abstract Object dottedNameGet(String var1);

    @Override
    public abstract Object[] dottedNameList(String[] var1);

    @Override
    public abstract Object[] dottedNameSet(String[] var1);

    protected abstract boolean isWriteableDottedName(String var1);

    @Override
    public boolean getMBeanInfoIsInvariant() {
        return false;
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        MBeanInfo mbeanInfo = null;
        this.checkRefresh();
        if (this.getOldDottedNames() != null) {
            this.ensureMBeanInfo();
            mbeanInfo = this.mMBeanInfo;
        } else {
            mbeanInfo = super.getMBeanInfo();
        }
        return mbeanInfo;
    }

    @Override
    public void postRegisterHook(Boolean registrationSucceeded) {
        super.postRegisterHook(registrationSucceeded);
        if (registrationSucceeded.booleanValue()) {
            RunnableBase refresher = new RunnableBase(){

                protected void doRun() {
                    FeatureAvailability.getInstance().waitForFeature("ServerStarted", "DottedNamesBase");
                    DottedNamesBase.this.setupOldDottedNamesProxy();
                    DottedNamesBase.this.mRefreshNeeded = true;
                }
            };
            refresher.submit(RunnableBase.HowToRun.RUN_IN_SEPARATE_THREAD);
        }
    }

    protected void setupOldDottedNamesProxy() {
        this.setupOldDottedNamesProxy(Util.newObjectName(DOTTED_NAMES));
    }

    protected void setupOldDottedNamesProxy(ObjectName target) {
        MBeanServer server = this.getMBeanServer();
        if (server != null && server.isRegistered(target)) {
            this.mOldDottedNamesProxy = MBeanServerInvocationHandler.newProxyInstance(server, target, OldDottedNamesProxy.class, false);
        }
    }

    protected OldDottedNamesProxy getOldDottedNames() {
        if (this.mOldDottedNamesProxy == null) {
            this.setupOldDottedNamesProxy();
        }
        return this.mOldDottedNamesProxy;
    }

    protected final boolean isDottedName(String name) {
        return this.getAttributes().keySet().contains(name);
    }

    protected final boolean isParentAttributeName(String name) {
        return this.mParentAttributeNames.contains(name);
    }

    protected final void filterNames(String[] in, Set<String> dotted, Set<String> parent) {
        for (int i = 0; i < in.length; ++i) {
            String name = in[i];
            if (this.isDottedName(name)) {
                dotted.add(name);
                continue;
            }
            if (!this.isParentAttributeName(name)) continue;
            parent.add(name);
        }
    }

    @Override
    public AttributeList getAttributes(String[] names) {
        this.checkRefresh();
        this.mCoverage.attributesWereRead(names);
        HashSet<String> dotted = new HashSet<String>();
        HashSet<String> parent = new HashSet<String>();
        this.filterNames(names, dotted, parent);
        Object[] dottedResults = this.dottedNameGet(dotted.toArray(new String[dotted.size()]));
        String[] namesForParent = new String[parent.size()];
        AttributeList parentResults = super.getAttributes(parent.toArray(namesForParent));
        AttributeList successList = new AttributeList();
        successList.addAll(parentResults);
        for (int i = 0; i < dottedResults.length; ++i) {
            if (dottedResults[i] instanceof Attribute) {
                successList.add((Attribute)dottedResults[i]);
                continue;
            }
            assert (dottedResults[i] instanceof Exception);
        }
        return successList;
    }

    @Override
    public Object getAttribute(String name) throws AttributeNotFoundException {
        this.checkLegalName(name);
        this.mCoverage.attributeWasRead(name);
        Object result = null;
        if (this.isDottedName(name)) {
            result = this.dottedNameGet(name);
            assert (!(result instanceof Attribute));
        } else if (this.isParentAttributeName(name)) {
            result = super.getAttribute(name);
        } else {
            throw new AttributeNotFoundException(name);
        }
        return result;
    }

    @Override
    public void setAttribute(Attribute attr) throws AttributeNotFoundException, InvalidAttributeValueException {
        String name = attr.getName();
        if (this.isParentAttributeName(name)) {
            super.setAttribute(attr);
        } else {
            this.checkLegalName(name);
            this.mCoverage.attributeWasWritten(name);
            AttributeList inList = new AttributeList();
            inList.add(attr);
            AttributeList result = this.setAttributes(inList);
            if (result.size() != 1) {
                throw new InvalidAttributeValueException(attr.getName());
            }
        }
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        int numAttrsIn = attributes.size();
        ArrayList<String> legalPairs = new ArrayList<String>();
        for (int i = 0; i < numAttrsIn; ++i) {
            Attribute attr = (Attribute)attributes.get(i);
            String name = attr.getName();
            this.mCoverage.attributeWasWritten(name);
            if (!this.isLegalAttributeName(name)) continue;
            legalPairs.add(DottedNamesBase.attributeToNamePair(attr));
        }
        String[] pairs = legalPairs.toArray(new String[legalPairs.size()]);
        Object[] results = this.dottedNameSet(pairs);
        AttributeList attributeList = new AttributeList();
        for (int i = 0; i < results.length; ++i) {
            if (results[i] instanceof Attribute) {
                attributeList.add((Attribute)results[i]);
                continue;
            }
            assert (results[i] instanceof Exception);
        }
        return attributeList;
    }

    @Override
    public Object invokeManually(String operationName, Object[] params, String[] types) throws ReflectionException, MBeanException, NoSuchMethodException, AttributeNotFoundException {
        boolean noParams = params == null || params.length == 0;
        Object result = null;
        if (operationName.equals("refresh") && noParams) {
            this.refresh();
            result = null;
        } else {
            result = super.invokeManually(operationName, params, types);
        }
        return result;
    }

    private synchronized void ensureMBeanInfo() {
        if (this.mMBeanInfo == null) {
            this.refresh();
            assert (this.mMBeanInfo != null);
        }
    }

    protected MBeanAttributeInfo[] buildAttributeInfos(MBeanAttributeInfo[] parentAttributeInfos) {
        String[] parentAttributeNames = JMXUtil.getAttributeNames(parentAttributeInfos);
        this.mParentAttributeNames = GSetUtil.newUnmodifiableStringSet(parentAttributeNames);
        Map<String, Attribute> attributes = this.getAttributes();
        MBeanAttributeInfo[] infos = new MBeanAttributeInfo[attributes.size() + parentAttributeInfos.length];
        int i = 0;
        for (String name : attributes.keySet()) {
            Attribute attr = attributes.get(name);
            Object value = attr.getValue();
            Class<String> theClass = value == null ? String.class : attr.getValue().getClass();
            infos[i] = new MBeanAttributeInfo(name, theClass.getName(), "", true, this.isWriteableDottedName(name), false);
            ++i;
        }
        System.arraycopy(parentAttributeInfos, 0, infos, attributes.size(), parentAttributeInfos.length);
        return infos;
    }

    protected MBeanOperationInfo[] buildOperationInfos(MBeanOperationInfo[] existing) {
        MBeanOperationInfo refreshInfo = new MBeanOperationInfo("refresh", "update MBeanInfo to reflect all available dotted names", null, Void.class.getName(), 1);
        MBeanOperationInfo[] infos = new MBeanOperationInfo[existing.length + 1];
        System.arraycopy(existing, 0, infos, 0, existing.length);
        infos[infos.length - 1] = refreshInfo;
        return infos;
    }

    protected MBeanInfo buildMBeanInfo() {
        MBeanInfo superMBeanInfo = super.getMBeanInfo();
        MBeanAttributeInfo[] attributeInfos = this.buildAttributeInfos(superMBeanInfo.getAttributes());
        MBeanOperationInfo[] operationInfos = this.buildOperationInfos(superMBeanInfo.getOperations());
        MBeanInfo info = new MBeanInfo(this.getClass().getName(), "exposes dotted-names as Attributes", attributeInfos, superMBeanInfo.getConstructors(), operationInfos, superMBeanInfo.getNotifications());
        return info;
    }

    private static Attribute namePairToAttribute(String pair) {
        int delimIndex = pair.indexOf("=");
        assert (delimIndex >= 1);
        String name = pair.substring(0, delimIndex);
        String value = pair.substring(delimIndex + 1, pair.length());
        return new Attribute(name, value);
    }

    private static String attributeToNamePair(Attribute attr) {
        return attr.getName() + "=" + attr.getValue();
    }

    protected final boolean isLegalAttributeName(String name) {
        this.ensureAttributes();
        return this.getAttributes().keySet().contains(name) || this.mParentAttributeNames.contains(name);
    }

    protected final void ensureAttributes() {
        if (this.mAttributes == null) {
            this.refreshAttributes();
        }
    }

    protected final Map<String, Attribute> getAttributes() {
        this.ensureAttributes();
        return this.mAttributes;
    }

    protected final String[] getDottedNamesArray() {
        Map<String, Attribute> map = this.getAttributes();
        Set<String> keySet = map.keySet();
        return keySet.toArray(new String[keySet.size()]);
    }

    private final void checkLegalName(String name) throws AttributeNotFoundException {
        this.checkRefresh();
        if (!this.isLegalAttributeName(name)) {
            throw new AttributeNotFoundException("illegal attribute name: " + name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void refreshAttributes() {
        Object result = null;
        if (this.mRefreshLock.tryLock()) {
            try {
                result = this.dottedNameGet(ALL_DOTTED_NAMES);
                Attribute[] values = (Attribute[])result;
                HashMap<String, Attribute> map = new HashMap<String, Attribute>();
                for (Attribute attr : values) {
                    map.put(attr.getName(), attr);
                }
                this.mAttributes = map;
                this.mMBeanInfo = this.buildMBeanInfo();
                this.mRefreshNeeded = false;
            }
            finally {
                this.mRefreshLock.unlock();
            }
        } else {
            this.mRefreshLock.lock();
            this.mRefreshLock.unlock();
        }
    }

    private void checkRefresh() {
        if (this.mRefreshNeeded) {
            this.refreshAttributes();
        }
    }

    @Override
    public final void refresh() {
        this.refreshAttributes();
    }

    protected static interface OldDottedNamesProxy {
        public Object[] dottedNameGet(String[] var1);

        public Object dottedNameGet(String var1);

        public Object[] dottedNameMonitoringGet(String[] var1);

        public Object dottedNameMonitoringGet(String var1);

        public String[] dottedNameList(String[] var1);

        public String[] dottedNameMonitoringList(String[] var1);

        public Object[] dottedNameSet(String[] var1);
    }
}

