/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.support;

import com.sun.appserv.management.DomainRoot;
import com.sun.appserv.management.base.AMX;
import com.sun.appserv.management.base.AMXRootLogger;
import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.client.ProxyFactory;
import com.sun.appserv.management.config.LoadBalancerConfig;
import com.sun.appserv.management.ext.lb.LoadBalancer;
import com.sun.appserv.management.util.jmx.MBeanRegistrationListener;
import com.sun.enterprise.management.ext.lb.LoadBalancerImpl;
import com.sun.enterprise.management.support.ObjectNames;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadBalancerSupport {
    private final MBeanServer mMBeanServer;
    private final DomainRoot mDomainRoot;
    private final Map<ObjectName, ObjectName> mConfigToLoadBalancers;
    private final LoadBalancerConfigListener mConfigListener;
    private static volatile LoadBalancerSupport INSTANCE = null;

    private LoadBalancerSupport(DomainRoot domainRoot, MBeanServer mbeanServer) throws InstanceNotFoundException, IOException {
        this.mMBeanServer = mbeanServer;
        this.mDomainRoot = domainRoot;
        this.mConfigToLoadBalancers = Collections.synchronizedMap(new HashMap());
        this.mConfigListener = new LoadBalancerConfigListener(this.mMBeanServer);
    }

    public static synchronized LoadBalancerSupport start(ObjectName domainRootObjectName, MBeanServer server) throws InstanceNotFoundException, IOException {
        if (INSTANCE != null) {
            throw new IllegalStateException();
        }
        DomainRoot domainRoot = ProxyFactory.getInstance(server).getProxy(domainRootObjectName, DomainRoot.class);
        INSTANCE = new LoadBalancerSupport(domainRoot, server);
        LoadBalancerSupport.INSTANCE.mConfigListener.startListening();
        return INSTANCE;
    }

    synchronized LoadBalancer registerNewLoadBalancer(ObjectName loadBalancerConfigObjectName) {
        ObjectName domainRootObjName = Util.getObjectName(this.mDomainRoot);
        ObjectNames objectNames = ObjectNames.getInstance("amx");
        String name = loadBalancerConfigObjectName.getKeyProperty("name");
        ObjectName loadBalancerObjName = objectNames.buildContaineeObjectName(domainRootObjName, this.mDomainRoot.getFullType(), "X-LoadBalancer", name);
        LoadBalancerConfig loadBalancerConfig = this.getProxy(loadBalancerConfigObjectName, LoadBalancerConfig.class);
        LoadBalancerImpl loadBalancerImpl = new LoadBalancerImpl(this.mMBeanServer, loadBalancerConfig);
        LoadBalancer loadBalancerProxy = null;
        try {
            ObjectName actualObjectName = this.mMBeanServer.registerMBean(loadBalancerImpl, loadBalancerObjName).getObjectName();
            loadBalancerProxy = this.getProxy(actualObjectName, LoadBalancer.class);
            this.mConfigToLoadBalancers.put(loadBalancerConfigObjectName, actualObjectName);
        }
        catch (JMException ex) {
            this.logWarning("LoadBalancerRegistrationListener registerLoadBalancer failed. Exception = ", ex);
        }
        return loadBalancerProxy;
    }

    synchronized void unregisterLoadBalancer(ObjectName unregisteredLoadBalancerConfig) {
        ObjectName correspondingLoadBalancerObjectName = this.mConfigToLoadBalancers.remove(unregisteredLoadBalancerConfig);
        if (correspondingLoadBalancerObjectName != null) {
            try {
                this.mMBeanServer.unregisterMBean(correspondingLoadBalancerObjectName);
            }
            catch (JMException jMException) {
                // empty catch block
            }
        }
    }

    protected ProxyFactory getProxyFactory() {
        return ProxyFactory.getInstance(this.mMBeanServer);
    }

    protected <T extends AMX> T getProxy(ObjectName objectName, Class<T> theClass) {
        return this.getProxyFactory().getProxy(objectName, theClass);
    }

    protected void logWarning(String prefix, Exception ex) {
        AMXRootLogger.getInstance().warning(prefix + " : " + ex.getMessage());
    }

    private final class LoadBalancerConfigListener
    extends MBeanRegistrationListener {
        private final MBeanServer mServer;

        LoadBalancerConfigListener(MBeanServer mbeanServer) throws InstanceNotFoundException, IOException {
            super("LoadBalancerSupport.LoadBalancerConfigListener", mbeanServer, null);
            this.mServer = mbeanServer;
        }

        private boolean isLoadBalancerConfig(ObjectName o) {
            return "X-LoadBalancerConfig".equals(Util.getJ2EEType(o));
        }

        protected void mbeanRegistered(ObjectName registeredObjectName) {
            if (this.isLoadBalancerConfig(registeredObjectName)) {
                LoadBalancerSupport.this.registerNewLoadBalancer(registeredObjectName);
            }
        }

        protected void mbeanUnregistered(ObjectName unregisteredObjectName) {
            if (this.isLoadBalancerConfig(unregisteredObjectName)) {
                LoadBalancerSupport.this.unregisterLoadBalancer(unregisteredObjectName);
            }
        }
    }
}

