/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.upgrade.common;

import com.sun.enterprise.tools.upgrade.certconversion.ProcessAdaptor;
import com.sun.enterprise.tools.upgrade.common.CommonInfoModel;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.security.KeyStore;

public class PasswordVerifier {
    private static final String NSS_DB_LOCATION_OPTION = "-d";
    private static final String LIST_KEY_ID = "-K";
    private static final String CERT_NSS_PWD_OPTION = "-f";
    private static final String CERT_UTIL_UNIX = "certutil.sh";
    private static final String CERT_UTIL_WIN = "certutil.bat";
    private static final String CONFIG = "config";
    private static final String BIN = "bin";
    private static final String LIB = "lib";
    private static final String UPGRADE = "upgrade";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean verifySourceNSSPassword(CommonInfoModel commonInfo, String configDir) {
        if (commonInfo.getSourceDomainRootFlag() && new File(commonInfo.getSourceDomainRoot()).equals(new File(commonInfo.getTargetDomainRoot()))) {
            return true;
        }
        if (!new File(configDir).exists()) {
            return true;
        }
        String osName = commonInfo.getOSName();
        String libDir = "";
        String binDir = "";
        String certutilLocation = "";
        if (commonInfo.getSourceVersion().equals("7x")) {
            libDir = commonInfo.getSourceInstallDir() + File.separator + LIB;
            binDir = commonInfo.getSourceInstallDir() + File.separator + BIN;
            certutilLocation = commonInfo.getTargetInstallDir() + File.separator + LIB + File.separator + UPGRADE;
        } else {
            libDir = commonInfo.getTargetInstallDir() + File.separator + LIB;
            binDir = commonInfo.getTargetInstallDir() + File.separator + BIN;
            certutilLocation = commonInfo.getTargetInstallDir() + File.separator + LIB;
        }
        String certUtilPath = "";
        certUtilPath = osName.indexOf("Windows") == -1 ? commonInfo.getTargetInstallDir() + File.separator + LIB + File.separator + CERT_UTIL_UNIX : commonInfo.getTargetInstallDir() + File.separator + LIB + File.separator + CERT_UTIL_WIN;
        StringWriter result = new StringWriter();
        String nssPwd = commonInfo.getCertDbPassword();
        String domainRoot = commonInfo.getTargetDomainRoot();
        String nssPwdFile = domainRoot + File.separator + "pwdfile";
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(new FileOutputStream(nssPwdFile));
            pw.println(nssPwd);
            pw.flush();
            pw.close();
        }
        catch (FileNotFoundException fe) {
        }
        finally {
            try {
                if (pw != null) {
                    pw.close();
                }
            }
            catch (Exception e) {}
        }
        String commandString = certUtilPath + " " + LIST_KEY_ID + " " + NSS_DB_LOCATION_OPTION + " " + configDir + " " + CERT_NSS_PWD_OPTION + " " + nssPwdFile + " " + libDir + " " + binDir + " " + certutilLocation;
        int exitVal = ProcessAdaptor.executeProcess(commandString, (Writer)result);
        result.flush();
        String resultString = result.toString();
        File pwdfile = new File(nssPwdFile);
        pwdfile.delete();
        if (exitVal == 0) {
            return PasswordVerifier.parseAndVerify(resultString);
        }
        return exitVal == 255;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean verifyTargetNSSPassword(CommonInfoModel commonInfo, String configDir) {
        if (commonInfo.getSourceDomainRootFlag() && new File(commonInfo.getSourceDomainRoot()).equals(new File(commonInfo.getTargetDomainRoot()))) {
            return true;
        }
        if (!new File(configDir).exists()) {
            return true;
        }
        String osName = commonInfo.getOSName();
        String libDir = "";
        String binDir = "";
        libDir = commonInfo.getTargetInstallDir() + File.separator + LIB;
        binDir = commonInfo.getTargetInstallDir() + File.separator + BIN;
        String certutilLocation = libDir;
        String certUtilPath = "";
        certUtilPath = osName.indexOf("Windows") == -1 ? commonInfo.getTargetInstallDir() + File.separator + LIB + File.separator + CERT_UTIL_UNIX : commonInfo.getTargetInstallDir() + File.separator + LIB + File.separator + CERT_UTIL_WIN;
        StringWriter result = new StringWriter();
        String nssPwd = commonInfo.getTargetCertDbPassword();
        String domainRoot = commonInfo.getTargetDomainRoot();
        String nssPwdFile = domainRoot + File.separator + "pwdfile";
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(new FileOutputStream(nssPwdFile));
            pw.println(nssPwd);
            pw.flush();
            pw.close();
        }
        catch (FileNotFoundException fe) {
        }
        finally {
            try {
                if (pw != null) {
                    pw.close();
                }
            }
            catch (Exception e) {}
        }
        String commandString = certUtilPath + " " + LIST_KEY_ID + " " + NSS_DB_LOCATION_OPTION + " " + configDir + " " + CERT_NSS_PWD_OPTION + " " + nssPwdFile + " " + libDir + " " + binDir + " " + certutilLocation;
        int exitVal = ProcessAdaptor.executeProcess(commandString, (Writer)result);
        result.flush();
        String resultString = result.toString();
        File pwdfile = new File(nssPwdFile);
        pwdfile.delete();
        if (exitVal == 0) {
            return PasswordVerifier.parseAndVerify(resultString);
        }
        return false;
    }

    public static boolean verifySourceNSSPassword(CommonInfoModel commonInfo) {
        if (commonInfo.getSourceDomainRootFlag() && new File(commonInfo.getSourceDomainRoot()).equals(new File(commonInfo.getTargetDomainRoot()))) {
            return true;
        }
        String instanceName = commonInfo.getCurrentSourceInstance();
        String certificateDomainDir = "";
        certificateDomainDir = commonInfo.isEnterpriseEdition(commonInfo.getSourceEdition()) ? commonInfo.getDestinationDomainPath() : commonInfo.getSourceInstancePath();
        String configDir = certificateDomainDir + File.separator + CONFIG;
        return PasswordVerifier.verifySourceNSSPassword(commonInfo, configDir);
    }

    private static boolean parseAndVerify(String input) {
        try {
            BufferedReader reader = new BufferedReader(new StringReader(input));
            String readString = reader.readLine();
            while (readString != null) {
                String marker = readString.substring(0, 1);
                String anotherMarker = readString.substring(2, 3);
                if (!marker.equals("<") || !anotherMarker.equals(">")) {
                    return false;
                }
                readString = reader.readLine();
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean verifyKeystorePassword(String jksPath, String jksKeyStorePassword) {
        File jksfile = new File(jksPath);
        if (!jksfile.exists()) {
            return jksKeyStorePassword.equals("changeit");
        }
        FileInputStream inputStreamJks = null;
        try {
            inputStreamJks = new FileInputStream(jksPath);
            KeyStore jksKeyStore = KeyStore.getInstance("JKS");
            jksKeyStore.load(inputStreamJks, jksKeyStorePassword.toCharArray());
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (inputStreamJks != null) {
                try {
                    ((InputStream)inputStreamJks).close();
                }
                catch (Exception e) {}
            }
        }
        return true;
    }
}

