/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.interceptors;

import com.sun.corba.ee.impl.interceptors.PICurrent;
import com.sun.corba.ee.impl.logging.InterceptorsSystemException;
import com.sun.corba.ee.impl.logging.OMGSystemException;
import com.sun.corba.ee.impl.logging.ORBUtilSystemException;
import com.sun.corba.ee.spi.legacy.interceptor.ORBInitInfoExt;
import com.sun.corba.ee.spi.orb.ORB;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.PolicyError;
import org.omg.IOP.CodecFactory;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.IORInterceptor;
import org.omg.PortableInterceptor.Interceptor;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.omg.PortableInterceptor.ORBInitInfoPackage.DuplicateName;
import org.omg.PortableInterceptor.ORBInitInfoPackage.InvalidName;
import org.omg.PortableInterceptor.PolicyFactory;
import org.omg.PortableInterceptor.ServerRequestInterceptor;

public final class ORBInitInfoImpl
extends LocalObject
implements ORBInitInfo,
ORBInitInfoExt {
    private ORB orb;
    private InterceptorsSystemException wrapper;
    private ORBUtilSystemException orbutilWrapper;
    private OMGSystemException omgWrapper;
    private String[] args;
    private String orbId;
    private CodecFactory codecFactory;
    private int stage = 0;
    public static final int STAGE_PRE_INIT = 0;
    public static final int STAGE_POST_INIT = 1;
    public static final int STAGE_CLOSED = 2;
    private static final String MESSAGE_ORBINITINFO_INVALID = "ORBInitInfo object is only valid during ORB_init";

    ORBInitInfoImpl(ORB orb, String[] args, String orbId, CodecFactory codecFactory) {
        this.orb = orb;
        this.wrapper = orb.getLogWrapperTable().get_RPC_PROTOCOL_Interceptors();
        this.orbutilWrapper = orb.getLogWrapperTable().get_RPC_PROTOCOL_ORBUtil();
        this.omgWrapper = orb.getLogWrapperTable().get_RPC_PROTOCOL_OMG();
        this.args = args;
        this.orbId = orbId;
        this.codecFactory = codecFactory;
    }

    public ORB getORB() {
        return this.orb;
    }

    void setStage(int stage) {
        this.stage = stage;
    }

    private void checkStage() {
        if (this.stage == 2) {
            throw this.wrapper.orbinitinfoInvalid();
        }
    }

    public String[] arguments() {
        this.checkStage();
        return this.args;
    }

    public String orb_id() {
        this.checkStage();
        return this.orbId;
    }

    public CodecFactory codec_factory() {
        this.checkStage();
        return this.codecFactory;
    }

    public void register_initial_reference(String id, Object obj) throws InvalidName {
        this.checkStage();
        if (id == null) {
            this.nullParam();
        }
        if (obj == null) {
            throw this.omgWrapper.rirWithNullObject();
        }
        try {
            this.orb.register_initial_reference(id, obj);
        }
        catch (org.omg.CORBA.ORBPackage.InvalidName e) {
            InvalidName exc = new InvalidName(e.getMessage());
            exc.initCause((Throwable)e);
            throw exc;
        }
    }

    public Object resolve_initial_references(String id) throws InvalidName {
        this.checkStage();
        if (id == null) {
            this.nullParam();
        }
        if (this.stage == 0) {
            throw this.wrapper.rirInvalidPreInit();
        }
        Object objRef = null;
        try {
            objRef = this.orb.resolve_initial_references(id);
        }
        catch (org.omg.CORBA.ORBPackage.InvalidName e) {
            throw new InvalidName();
        }
        return objRef;
    }

    public void add_client_request_interceptor_with_policy(ClientRequestInterceptor interceptor, Policy[] policies) throws DuplicateName {
        this.add_client_request_interceptor(interceptor);
    }

    public void add_client_request_interceptor(ClientRequestInterceptor interceptor) throws DuplicateName {
        this.checkStage();
        if (interceptor == null) {
            this.nullParam();
        }
        this.orb.getPIHandler().register_interceptor((Interceptor)interceptor, 0);
    }

    public void add_server_request_interceptor_with_policy(ServerRequestInterceptor interceptor, Policy[] policies) throws DuplicateName, PolicyError {
        this.add_server_request_interceptor(interceptor);
    }

    public void add_server_request_interceptor(ServerRequestInterceptor interceptor) throws DuplicateName {
        this.checkStage();
        if (interceptor == null) {
            this.nullParam();
        }
        this.orb.getPIHandler().register_interceptor((Interceptor)interceptor, 1);
    }

    public void add_ior_interceptor_with_policy(IORInterceptor interceptor, Policy[] policies) throws DuplicateName, PolicyError {
        this.add_ior_interceptor(interceptor);
    }

    public void add_ior_interceptor(IORInterceptor interceptor) throws DuplicateName {
        this.checkStage();
        if (interceptor == null) {
            this.nullParam();
        }
        this.orb.getPIHandler().register_interceptor((Interceptor)interceptor, 2);
    }

    public int allocate_slot_id() {
        this.checkStage();
        return ((PICurrent)this.orb.getPIHandler().getPICurrent()).allocateSlotId();
    }

    public void register_policy_factory(int type, PolicyFactory policy_factory) {
        this.checkStage();
        if (policy_factory == null) {
            this.nullParam();
        }
        this.orb.getPIHandler().registerPolicyFactory(type, policy_factory);
    }

    private void nullParam() throws BAD_PARAM {
        throw this.orbutilWrapper.nullParam();
    }
}

