/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.orbutil.transport;

import com.sun.corba.ee.impl.orbutil.transport.ConnectionCacheNonBlockingBase;
import com.sun.corba.ee.spi.orbutil.concurrent.ConcurrentQueue;
import com.sun.corba.ee.spi.orbutil.transport.Connection;
import com.sun.corba.ee.spi.orbutil.transport.InboundConnectionCache;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InboundConnectionCacheImpl<C extends Connection>
extends ConnectionCacheNonBlockingBase<C>
implements InboundConnectionCache<C> {
    private final ConcurrentMap<C, ConnectionState<C>> connectionMap = new ConcurrentHashMap<C, ConnectionState<C>>();

    @Override
    protected String thisClassName() {
        return "InboundConnectionCacheImpl";
    }

    public InboundConnectionCacheImpl(String cacheType, int highWaterMark, int numberToReclaim, Logger logger) {
        super(cacheType, highWaterMark, numberToReclaim, logger);
        if (this.debug()) {
            this.dprint(".constructor completed: " + this.getCacheType());
        }
    }

    @Override
    public void requestReceived(C conn) {
        int count;
        ConcurrentQueue.Handle reclaimHandle;
        ConnectionState<C> cs = this.getConnectionState(conn);
        int totalConnections = this.totalBusy.get() + this.totalIdle.get();
        if (totalConnections > this.highWaterMark()) {
            this.reclaim();
        }
        if ((reclaimHandle = cs.reclaimableHandle) != null) {
            reclaimHandle.remove();
        }
        if ((count = cs.busyCount.getAndIncrement()) == 0) {
            this.totalIdle.decrementAndGet();
            this.totalBusy.incrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestProcessed(C conn, int numResponsesExpected) {
        if (this.debug()) {
            this.dprint("->requestProcessed: connection " + conn + " expecting " + numResponsesExpected + " responses");
        }
        try {
            ConnectionState cs = (ConnectionState)this.connectionMap.get(conn);
            if (cs == null) {
                if (this.debug()) {
                    this.dprint(".release: connection " + conn + " was closed");
                }
                return;
            }
            int numResp = cs.expectedResponseCount.addAndGet(numResponsesExpected);
            int numBusy = cs.busyCount.decrementAndGet();
            if (this.debug()) {
                this.dprint(".release: " + numResp + " responses expected");
                this.dprint(".release: " + numBusy + " responses expected");
            }
            if (numBusy == 0) {
                this.totalBusy.decrementAndGet();
                this.totalIdle.incrementAndGet();
                if (numResp == 0) {
                    if (this.debug()) {
                        this.dprint(".release: queuing reclaimable connection " + conn);
                    }
                    cs.reclaimableHandle = this.reclaimableConnections.offer(conn);
                }
            }
        }
        finally {
            if (this.debug()) {
                this.dprint("<-requestProcessed");
            }
        }
    }

    @Override
    public void responseSent(C conn) {
        ConnectionState cs = (ConnectionState)this.connectionMap.get(conn);
        int waitCount = cs.expectedResponseCount.decrementAndGet();
        if (waitCount == 0) {
            cs.reclaimableHandle = this.reclaimableConnections.offer(conn);
        }
    }

    @Override
    public void close(C conn) {
        block5: {
            ConnectionState cs = (ConnectionState)this.connectionMap.remove(conn);
            int count = cs.busyCount.get();
            if (count == 0) {
                this.totalIdle.decrementAndGet();
            } else {
                this.totalBusy.decrementAndGet();
            }
            ConcurrentQueue.Handle rh = cs.reclaimableHandle;
            if (rh != null) {
                rh.remove();
            }
            try {
                conn.close();
            }
            catch (IOException exc) {
                if (!this.debug()) break block5;
                this.dprint(".close: " + conn + " close threw " + exc);
            }
        }
    }

    private ConnectionState<C> getConnectionState(C conn) {
        ConnectionState<C> cs = new ConnectionState<C>(conn);
        ConnectionState<C> result = this.connectionMap.putIfAbsent(conn, cs);
        if (result != null) {
            this.totalIdle.incrementAndGet();
            return result;
        }
        return cs;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ConnectionState<C extends Connection> {
        final C connection;
        final AtomicInteger busyCount;
        final AtomicInteger expectedResponseCount;
        ConcurrentQueue.Handle reclaimableHandle;

        ConnectionState(C conn) {
            this.connection = conn;
            this.busyCount = new AtomicInteger();
            this.expectedResponseCount = new AtomicInteger();
            this.reclaimableHandle = null;
        }
    }
}

