/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.transport;

import com.sun.corba.ee.impl.logging.ORBUtilSystemException;
import com.sun.corba.ee.impl.orbutil.ORBUtility;
import com.sun.corba.ee.pept.transport.Connection;
import com.sun.corba.ee.pept.transport.ConnectionCache;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.transport.CorbaConnectionCache;
import java.util.Collection;
import java.util.Iterator;

public abstract class CorbaConnectionCacheBase
implements ConnectionCache,
CorbaConnectionCache {
    protected ORB orb;
    protected long timestamp = 0L;
    protected String cacheType;
    protected String monitoringName;
    protected ORBUtilSystemException wrapper;

    protected CorbaConnectionCacheBase(ORB orb, String cacheType, String monitoringName) {
        this.orb = orb;
        this.cacheType = cacheType;
        this.monitoringName = monitoringName;
        this.wrapper = orb.getLogWrapperTable().get_RPC_TRANSPORT_ORBUtil();
        this.registerWithMonitoring();
        this.dprintCreation();
    }

    public String getCacheType() {
        return this.cacheType;
    }

    public synchronized void stampTime(Connection c) {
        c.setTimeStamp(this.timestamp++);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long numberOfConnections() {
        Object object = this.backingStore();
        synchronized (object) {
            return this.values().size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long numberOfIdleConnections() {
        long count = 0L;
        Object object = this.backingStore();
        synchronized (object) {
            Iterator connections = this.values().iterator();
            while (connections.hasNext()) {
                if (((Connection)connections.next()).isBusy()) continue;
                ++count;
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long numberOfBusyConnections() {
        long count = 0L;
        Object object = this.backingStore();
        synchronized (object) {
            Iterator connections = this.values().iterator();
            while (connections.hasNext()) {
                if (!((Connection)connections.next()).isBusy()) continue;
                ++count;
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized boolean reclaim() {
        try {
            Object backingStore;
            long numberOfConnections = this.numberOfConnections();
            if (this.orb.transportDebugFlag) {
                this.dprint(".reclaim->: " + numberOfConnections + " (" + this.orb.getORBData().getHighWaterMark() + "/" + this.orb.getORBData().getLowWaterMark() + "/" + this.orb.getORBData().getNumberToReclaim() + ")");
            }
            if (numberOfConnections <= (long)this.orb.getORBData().getHighWaterMark() || numberOfConnections < (long)this.orb.getORBData().getLowWaterMark()) {
                boolean bl = false;
                return bl;
            }
            Object object = backingStore = this.backingStore();
            synchronized (object) {
                for (int i = 0; i < this.orb.getORBData().getNumberToReclaim(); ++i) {
                    Connection toClose = null;
                    long lru = Long.MAX_VALUE;
                    for (Connection c : this.values()) {
                        if (c.isBusy() || c.getTimeStamp() >= lru) continue;
                        toClose = c;
                        lru = c.getTimeStamp();
                    }
                    if (toClose == null) {
                        boolean c = false;
                        return c;
                    }
                    try {
                        if (this.orb.transportDebugFlag) {
                            this.dprint(".reclaim: closing: " + toClose);
                        }
                        toClose.close();
                        continue;
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                if (this.orb.transportDebugFlag) {
                    this.dprint(".reclaim: connections reclaimed (" + (numberOfConnections - this.numberOfConnections()) + ")");
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (this.orb.transportDebugFlag) {
                this.dprint(".reclaim<-: " + this.numberOfConnections());
            }
        }
    }

    public String getMonitoringName() {
        return this.monitoringName;
    }

    public abstract Collection values();

    protected abstract Object backingStore();

    protected abstract void registerWithMonitoring();

    protected void dprintCreation() {
        if (this.orb.transportDebugFlag) {
            this.dprint(".constructor: cacheType: " + this.getCacheType() + " monitoringName: " + this.getMonitoringName());
        }
    }

    protected void dprintStatistics() {
        if (this.orb.transportDebugFlag) {
            this.dprint(".stats: " + this.numberOfConnections() + "/total " + this.numberOfBusyConnections() + "/busy " + this.numberOfIdleConnections() + "/idle" + " (" + this.orb.getORBData().getHighWaterMark() + "/" + this.orb.getORBData().getLowWaterMark() + "/" + this.orb.getORBData().getNumberToReclaim() + ")");
        }
    }

    protected void dprint(String msg) {
        ORBUtility.dprint("CorbaConnectionCacheBase", msg);
    }
}

