/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.base.io;

import com.sun.ejb.base.io.EJBObjectInputStream;
import com.sun.ejb.base.io.EJBObjectOutputStream;
import com.sun.ejb.spi.io.J2EEObjectStreamFactory;
import com.sun.ejb.spi.io.NonSerializableObjectHandler;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.logging.Logger;

public class J2EEObjectStreamFactoryImpl
implements J2EEObjectStreamFactory {
    private static final Logger _ejbLogger = LogDomains.getLogger("javax.enterprise.system.container.ejb");

    public ObjectOutputStream createObjectOutputStream(final OutputStream os, final boolean replaceObject, final NonSerializableObjectHandler handler) throws IOException {
        ObjectOutputStream oos = null;
        if (System.getSecurityManager() == null) {
            oos = new EJBObjectOutputStream(os, replaceObject, handler);
        } else {
            try {
                oos = (ObjectOutputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return new EJBObjectOutputStream(os, replaceObject, handler);
                    }
                });
            }
            catch (PrivilegedActionException ex) {
                throw (IOException)ex.getException();
            }
        }
        return oos;
    }

    public ObjectInputStream createObjectInputStream(final InputStream is, final boolean resolveObject, final ClassLoader loader) throws Exception {
        ObjectInputStream ois = null;
        if (loader != null) {
            if (System.getSecurityManager() == null) {
                ois = new EJBObjectInputStream(is, loader, resolveObject);
            } else {
                try {
                    ois = (ObjectInputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            return new EJBObjectInputStream(is, loader, resolveObject);
                        }
                    });
                }
                catch (PrivilegedActionException ex) {
                    throw (IOException)ex.getException();
                }
            }
        } else {
            ois = new ObjectInputStream(is);
        }
        return ois;
    }
}

