/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers;

import com.sun.ejb.Invocation;
import com.sun.ejb.InvocationInfo;
import com.sun.ejb.containers.EJBObjectImpl;
import com.sun.ejb.containers.InvocationHandlerUtil;
import com.sun.ejb.containers.util.MethodMap;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.Utility;
import com.sun.logging.LogDomains;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJBObject;

public final class EJBObjectInvocationHandler
extends EJBObjectImpl
implements InvocationHandler {
    private static final Logger logger = LogDomains.getLogger("javax.enterprise.system.container.ejb");
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(EJBObjectInvocationHandler.class);
    private MethodMap invocationInfoMap_;
    private Class remoteIntf_;

    public EJBObjectInvocationHandler(MethodMap invocationInfoMap, Class remoteIntf) throws Exception {
        this.invocationInfoMap_ = invocationInfoMap;
        this.remoteIntf_ = remoteIntf;
        this.setIsRemoteHomeView(true);
    }

    public EJBObjectInvocationHandler(MethodMap invocationInfoMap) throws Exception {
        this.invocationInfoMap_ = invocationInfoMap;
        this.setIsRemoteHomeView(false);
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        return this.invoke(this.remoteIntf_, method, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object invoke(Class clientInterface, Method method, Object[] args) throws Throwable {
        Object object;
        block21: {
            InvocationInfo invInfo;
            ClassLoader originalClassLoader;
            block18: {
                Object object2;
                block19: {
                    Class<?> methodClass;
                    block16: {
                        Object object3;
                        block17: {
                            originalClassLoader = null;
                            try {
                                this.container.onEnteringContainer();
                                if (Thread.currentThread().getContextClassLoader() != this.getContainer().getClassLoader()) {
                                    originalClassLoader = Utility.setContextClassLoader(this.getContainer().getClassLoader());
                                }
                                if ((methodClass = method.getDeclaringClass()) != Object.class) break block16;
                                object3 = InvocationHandlerUtil.invokeJavaObjectMethod(this, method, args);
                                if (originalClassLoader == null) break block17;
                            }
                            catch (Throwable throwable) {
                                if (originalClassLoader != null) {
                                    Utility.setContextClassLoader(originalClassLoader);
                                }
                                this.container.onLeavingContainer();
                                throw throwable;
                            }
                            Utility.setContextClassLoader(originalClassLoader);
                        }
                        this.container.onLeavingContainer();
                        return object3;
                    }
                    invInfo = (InvocationInfo)this.invocationInfoMap_.get(method, args != null ? args.length : 0);
                    if (invInfo == null) {
                        throw new RemoteException("Unknown Remote interface method :" + method);
                    }
                    if (methodClass != EJBObject.class && !invInfo.ejbIntfOverride) break block18;
                    object2 = this.invokeEJBObjectMethod(method.getName(), args);
                    if (originalClassLoader == null) break block19;
                    Utility.setContextClassLoader(originalClassLoader);
                }
                this.container.onLeavingContainer();
                return object2;
            }
            if (invInfo.targetMethod1 == null) {
                Object[] params = new Object[]{invInfo.ejbName, "Remote", invInfo.method.toString()};
                String errorMsg = localStrings.getLocalString("ejb.bean_class_method_not_found", "", params);
                logger.log(Level.SEVERE, "ejb.bean_class_method_not_found", params);
                throw new RemoteException(errorMsg);
            }
            Object returnValue = null;
            Invocation inv = new Invocation();
            inv.isLocal = false;
            inv.isHome = false;
            inv.isBusinessInterface = !this.isRemoteHomeView();
            inv.ejbObject = this;
            inv.method = method;
            inv.clientInterface = clientInterface;
            inv.transactionAttribute = invInfo.txAttr;
            inv.securityPermissions = invInfo.securityPermissions;
            inv.invocationInfo = invInfo;
            inv.beanMethod = invInfo.targetMethod1;
            inv.methodParams = args;
            try {
                this.container.preInvoke(inv);
                returnValue = this.container.intercept(inv);
            }
            catch (InvocationTargetException ite) {
                inv.exceptionFromBeanMethod = inv.exception = ite.getCause();
            }
            catch (Throwable t) {
                inv.exception = t;
            }
            finally {
                this.container.postInvoke(inv);
            }
            if (inv.exception != null) {
                InvocationHandlerUtil.throwRemoteException(inv.exception, method.getExceptionTypes());
            }
            object = returnValue;
            if (originalClassLoader == null) break block21;
            Utility.setContextClassLoader(originalClassLoader);
        }
        this.container.onLeavingContainer();
        return object;
    }

    private Object invokeEJBObjectMethod(String methodName, Object[] args) throws Exception {
        Object returnValue = null;
        if (methodName.equals("getEJBHome")) {
            returnValue = super.getEJBHome();
        } else if (methodName.equals("getHandle")) {
            returnValue = super.getHandle();
        } else if (methodName.equals("getPrimaryKey")) {
            returnValue = super.getPrimaryKey();
        } else if (methodName.equals("isIdentical")) {
            EJBObject other = (EJBObject)args[0];
            returnValue = new Boolean(super.isIdentical(other));
        } else if (methodName.equals("remove")) {
            super.remove();
        } else {
            throw new RemoteException("unknown EJBObject method = " + methodName);
        }
        return returnValue;
    }
}

