/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.dottedname;

import com.sun.enterprise.admin.dottedname.DottedName;
import com.sun.enterprise.admin.dottedname.DottedNameStrings;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;

final class ParsedDottedName
implements Serializable {
    public final String mDomain;
    public final String mScope;
    public final List mParts;

    public ParsedDottedName(String domain, String scope, List parts) {
        if (domain.length() != 0) {
            this.checkLegalNamePart(domain);
        }
        this.checkLegalNamePart(scope);
        for (int i = 0; i < parts.size(); ++i) {
            this.checkLegalNamePart((String)parts.get(i));
        }
        this.mDomain = domain;
        this.mScope = scope;
        this.mParts = Collections.unmodifiableList(parts);
    }

    boolean isLegalChar(char theChar) {
        return "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-_./\\*(){}[];<>@$#".indexOf(theChar) >= 0;
    }

    void checkLegalChar(char theChar) {
        if (!this.isLegalChar(theChar)) {
            String msg = DottedNameStrings.getString("IllegalCharacter", "'" + theChar + "'");
            throw new IllegalArgumentException(msg);
        }
    }

    void checkLegalNamePart(String part) {
        int length = part.length();
        if (length == 0) {
            String msg = DottedNameStrings.getString("MissingExpectedNamePart");
            throw new IllegalArgumentException(msg);
        }
        for (int i = 0; i < length; ++i) {
            char theChar = part.charAt(i);
            this.checkLegalChar(theChar);
        }
    }

    public int hashCode() {
        int hashcode = 17;
        hashcode = 37 * hashcode + this.mDomain.hashCode();
        hashcode = 37 * hashcode + this.mScope.hashCode();
        hashcode = 37 * hashcode + ((Object)this.mParts).hashCode();
        return hashcode;
    }

    public boolean equals(Object other) {
        boolean equals = false;
        equals = !(other instanceof ParsedDottedName) ? false : (other == this ? true : this.toString().equals(other.toString()));
        return equals;
    }

    public String toString() {
        return DottedName.toString(this.mDomain, this.mScope, this.mParts);
    }
}

