/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.mbeans;

import com.sun.enterprise.admin.common.MBeanServerFactory;
import com.sun.enterprise.admin.config.BaseConfigMBean;
import com.sun.enterprise.admin.mbeanapi.IConnectorConnectionPoolMBean;
import com.sun.enterprise.admin.target.ConfigTarget;
import com.sun.enterprise.admin.target.Target;
import com.sun.enterprise.config.ConfigBeansFactory;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.serverbeans.BackendPrincipal;
import com.sun.enterprise.config.serverbeans.ConnectorConnectionPool;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.SecurityMap;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class ConnectorConnectionPoolMBean
extends BaseConfigMBean
implements IConnectorConnectionPoolMBean {
    private static final String USER_NAME = "user_name";
    private static final String PASSWORD = "password";
    private static final String NAME = "name";
    private static final String PRINCIPAL = "principal";
    private static final String USER_GROUP = "user_group";
    private static final String POOL_NAME = "pool_name";
    private static final String MAP_NAME = "map_name";
    private static final String VERBOSE = "verbose";
    private static final String ADD_PRINCIPALS = "add_principals";
    private static final String REMOVE_PRINCIPALS = "remove_principals";
    private static final String ADD_USER_GROUPS = "add_user_groups";
    private static final String REMOVE_USER_GROUPS = "remove_user_groups";
    private static final String CREATE_SECURITY_MAP = "createSecurityMap";
    private static final String CREATE_BACKEND_PRINCIPAL = "createBackendPrincipal";
    private static final String GET_SECURITY_MAP = "getSecurityMap";
    private static final String GET_SECURITY_MAP_BY_NAME = "getSecurityMapByName";
    private static final String GET_BACKEND_PRINCIPAL = "getBackendPrincipal";
    private static final String GET_POOL_BY_NAME = "getConnectorConnectionPoolByName";
    private static final String DEFAULT_TARGET = "domain";
    private static final String GET_CONNECTOR_POOLS = "getConnectorConnectionPool";
    private static final String CONFIG = "config";
    private static final String POOL_TYPE = "connector-connection-pool";
    private static final String MAP_TYPE = "security-map";
    private static final String RES_TYPE = "resources";
    private static final String POOL_DOES_NOT_EXISTS = "admin.mbeans.ccpmb.pool_does_not_exists";
    private static final String MAP_DOES_NOT_EXISTS = "admin.mbeans.ccpmb.map_does_not_exists";
    private static final String MAP_NAME_EXISTS = "admin.mbeans.ccpmb.map_name_exists";
    private static final String PRINCIPAL_USERGPS_NULL = "admin.mbeans.ccpmb.principals_usergroups_null";
    private static final String PRINCIPAL_EXISTS = "admin.mbeans.ccpmb.principal_exists";
    private static final String USERGROUP_EXISTS = "admin.mbeans.ccpmb.usergroup_exists";
    private static final String SAME_PRINCIPAL_VALUES = "admin.mbeans.ccpmb.same_principal_values";
    private static final String SAME_USERGROUP_VALUES = "admin.mbeans.ccpmb.same_usergroup_values";
    private static final String PRINCIPAL_DOES_NOT_EXISTS = "admin.mbeans.ccpmb.principal_does_not_exists";
    private static final String USERGROUP_DOES_NOT_EXISTS = "admin.mbeans.ccpmb.usergroup_does_not_exists";
    private static final String OPERATION_NOT_SUPPORTED = "admin.mbeans.ccpmb.operation_not_supported";
    private static final String USER_NAME_NULL = "admin.mbeans.ccpmb.user_name_null";
    private static final String PRINCIPALS_USERGROUPS_NULL = "admin.mbeans.ccpmb.principals_usergroups_will_be_null";
    private static StringManager localStrings = StringManager.getManager(ConnectorConnectionPoolMBean.class);

    public void createSecurityMap(AttributeList attrList) throws Exception {
        String msg = localStrings.getString(OPERATION_NOT_SUPPORTED);
        throw new Exception(msg);
    }

    public ObjectName createSecurityMap(AttributeList attrList, String userName, String password, String tgtName) throws MBeanException {
        ObjectName mbean = null;
        String poolName = null;
        String mapname = null;
        try {
            String msg;
            int i;
            if (tgtName == null || tgtName.equals("")) {
                tgtName = DEFAULT_TARGET;
            }
            MBeanServer server = this.getMBeanServer();
            String[] principals = null;
            String[] usergroups = null;
            if (attrList != null) {
                int s = attrList.size();
                for (i = 0; i < s; ++i) {
                    try {
                        Attribute attribute = (Attribute)attrList.get(i);
                        if (ConnectorConnectionPoolMBean.isAttrNameMatch(attribute, NAME)) {
                            mapname = (String)attribute.getValue();
                            continue;
                        }
                        if (ConnectorConnectionPoolMBean.isAttrNameMatch(attribute, PRINCIPAL)) {
                            principals = (String[])attribute.getValue();
                        }
                        if (ConnectorConnectionPoolMBean.isAttrNameMatch(attribute, USER_GROUP)) {
                            usergroups = (String[])attribute.getValue();
                        }
                        if (!ConnectorConnectionPoolMBean.isAttrNameMatch(attribute, POOL_NAME)) continue;
                        poolName = (String)attribute.getValue();
                        continue;
                    }
                    catch (Exception e) {
                        throw new Exception("failed while getting attributenames and values");
                    }
                }
            }
            if (!this.doesPoolNameExists(poolName)) {
                String msg2 = localStrings.getString(POOL_DOES_NOT_EXISTS, poolName);
                throw new Exception(msg2);
            }
            if (this.doesMapNameExists(poolName, mapname)) {
                String msg3 = localStrings.getString(MAP_NAME_EXISTS, mapname, poolName);
                throw new Exception(msg3);
            }
            if (userName == null) {
                String msg4 = localStrings.getString(USER_NAME_NULL);
                throw new Exception(msg4);
            }
            if (principals == null && usergroups == null) {
                String msg5 = localStrings.getString(PRINCIPAL_USERGPS_NULL);
                throw new Exception(msg5);
            }
            ObjectName[] maps = this.getAllSecurityMapsForPool(poolName);
            if (principals != null) {
                for (i = 0; i < principals.length; ++i) {
                    if (!this.isPrincipalExisting(principals[i], maps)) continue;
                    msg = localStrings.getString(PRINCIPAL_EXISTS, principals[i], poolName);
                    throw new Exception(msg);
                }
            }
            if (usergroups != null) {
                for (i = 0; i < usergroups.length; ++i) {
                    if (!this.isUserGroupExisting(usergroups[i], maps)) continue;
                    msg = localStrings.getString(USERGROUP_EXISTS, usergroups[i], poolName);
                    throw new Exception(msg);
                }
            }
            ConfigContext serverContext = this.getConfigContext();
            Resources resourcesBean = (Resources)ConfigBeansFactory.getConfigBeanByXPath(serverContext, "/domain/resources");
            ConnectorConnectionPool connPool = resourcesBean.getConnectorConnectionPoolByName(poolName);
            BackendPrincipal backEndPrincipal = new BackendPrincipal();
            backEndPrincipal.setUserName(userName);
            if (password != null) {
                backEndPrincipal.setPassword(password);
            }
            SecurityMap securityMap = new SecurityMap();
            if (backEndPrincipal != null) {
                securityMap.setBackendPrincipal(backEndPrincipal);
            }
            if (mapname != null) {
                securityMap.setName(mapname);
            }
            if (principals != null) {
                securityMap.setPrincipal(principals);
            }
            if (usergroups != null) {
                securityMap.setUserGroup(usergroups);
            }
            connPool.addSecurityMap(securityMap);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MBeanException(e);
        }
        return mbean;
    }

    public boolean updateSecurityMap(AttributeList attrList, String tgtName) throws MBeanException {
        String mapname = null;
        String poolname = null;
        String username = null;
        String password = null;
        String[] addPrincipals = null;
        String[] addUserGroups = null;
        String[] removePrincipals = null;
        String[] removeUserGroups = null;
        boolean status = false;
        try {
            String s;
            int i;
            String s2;
            int i2;
            int i3;
            if (tgtName == null || tgtName.equals("")) {
                tgtName = DEFAULT_TARGET;
            }
            if (attrList != null) {
                int s3 = attrList.size();
                for (i3 = 0; i3 < s3; ++i3) {
                    try {
                        Attribute attribute = (Attribute)attrList.get(i3);
                        if (ConnectorConnectionPoolMBean.isAttrNameMatch(attribute, POOL_NAME)) {
                            poolname = (String)attribute.getValue();
                        }
                        if (ConnectorConnectionPoolMBean.isAttrNameMatch(attribute, NAME)) {
                            mapname = (String)attribute.getValue();
                        }
                        if (ConnectorConnectionPoolMBean.isAttrNameMatch(attribute, USER_NAME)) {
                            username = (String)attribute.getValue();
                        }
                        if (ConnectorConnectionPoolMBean.isAttrNameMatch(attribute, PASSWORD)) {
                            password = (String)attribute.getValue();
                        }
                        if (ConnectorConnectionPoolMBean.isAttrNameMatch(attribute, ADD_PRINCIPALS)) {
                            addPrincipals = this.getOptionsList((String)attribute.getValue());
                        }
                        if (ConnectorConnectionPoolMBean.isAttrNameMatch(attribute, ADD_USER_GROUPS)) {
                            addUserGroups = this.getOptionsList((String)attribute.getValue());
                        }
                        if (ConnectorConnectionPoolMBean.isAttrNameMatch(attribute, REMOVE_PRINCIPALS)) {
                            removePrincipals = this.getOptionsList((String)attribute.getValue());
                        }
                        if (!ConnectorConnectionPoolMBean.isAttrNameMatch(attribute, REMOVE_USER_GROUPS)) continue;
                        removeUserGroups = this.getOptionsList((String)attribute.getValue());
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            if (!this.doesPoolNameExists(poolname)) {
                String msg = localStrings.getString(POOL_DOES_NOT_EXISTS, poolname);
                throw new Exception(msg);
            }
            if (!this.doesMapNameExists(poolname, mapname)) {
                String msg = localStrings.getString(MAP_DOES_NOT_EXISTS, mapname, poolname);
                throw new Exception(msg);
            }
            ObjectName[] maps = this.getAllSecurityMapsForPool(poolname);
            if (addPrincipals != null && removePrincipals != null) {
                for (i3 = 0; i3 < addPrincipals.length; ++i3) {
                    for (int j = 0; j < removePrincipals.length; ++j) {
                        if (!removePrincipals[j].equals(addPrincipals[i3])) continue;
                        String msg = localStrings.getString(SAME_PRINCIPAL_VALUES, addPrincipals[i3]);
                        throw new Exception(msg);
                    }
                }
            }
            if (addUserGroups != null && removeUserGroups != null) {
                for (i3 = 0; i3 < addUserGroups.length; ++i3) {
                    for (int j = 0; j < removeUserGroups.length; ++j) {
                        if (!removeUserGroups[j].equals(addUserGroups[i3])) continue;
                        String msg = localStrings.getString(SAME_USERGROUP_VALUES, addUserGroups[i3]);
                        throw new Exception(msg);
                    }
                }
            }
            if (addPrincipals != null) {
                for (i3 = 0; i3 < addPrincipals.length; ++i3) {
                    if (!this.isPrincipalExisting((String)addPrincipals[i3], maps)) continue;
                    String msg = localStrings.getString(PRINCIPAL_EXISTS, addPrincipals[i3], poolname);
                    throw new Exception(msg);
                }
            }
            if (addUserGroups != null) {
                for (i3 = 0; i3 < addUserGroups.length; ++i3) {
                    if (!this.isUserGroupExisting((String)addUserGroups[i3], maps)) continue;
                    String msg = localStrings.getString(USERGROUP_EXISTS, addUserGroups[i3], poolname);
                    throw new Exception(msg);
                }
            }
            MBeanServer server = this.getMBeanServer();
            ObjectName mbean = this.getSecurityMapObjectName(mapname, poolname);
            String[] existingPrincipals = null;
            String[] existingUserGroups = null;
            existingPrincipals = (String[])server.getAttribute(mbean, PRINCIPAL);
            existingUserGroups = (String[])server.getAttribute(mbean, USER_GROUP);
            ArrayList<String> source = null;
            ArrayList<String> source1 = null;
            if (existingPrincipals != null) {
                source = new ArrayList<String>(existingPrincipals.length);
                for (i2 = 0; i2 < existingPrincipals.length; ++i2) {
                    source.add(existingPrincipals[i2]);
                }
            }
            if (existingUserGroups != null) {
                source1 = new ArrayList<String>(existingUserGroups.length);
                for (i2 = 0; i2 < existingUserGroups.length; ++i2) {
                    source1.add(existingUserGroups[i2]);
                }
            }
            if (removePrincipals != null) {
                for (i2 = 0; i2 < removePrincipals.length; ++i2) {
                    s2 = removePrincipals[i2];
                    if (source.contains(s2)) continue;
                    String msg = localStrings.getString(PRINCIPAL_DOES_NOT_EXISTS, s2, poolname);
                    throw new Exception(msg);
                }
            }
            if (removeUserGroups != null) {
                for (i2 = 0; i2 < removeUserGroups.length; ++i2) {
                    s2 = removeUserGroups[i2];
                    if (source1.contains(s2)) continue;
                    String msg = localStrings.getString(USERGROUP_DOES_NOT_EXISTS, s2, poolname);
                    throw new Exception(msg);
                }
            }
            if (addPrincipals == null && addUserGroups == null) {
                boolean principalsEmpty = false;
                boolean userGroupsEmpty = false;
                if (removePrincipals == null && existingPrincipals.length == 0) {
                    principalsEmpty = true;
                }
                if (removeUserGroups == null && existingUserGroups.length == 0) {
                    userGroupsEmpty = true;
                }
                if (removePrincipals != null && removePrincipals.length == existingPrincipals.length) {
                    principalsEmpty = true;
                }
                if (removeUserGroups != null && removeUserGroups.length == existingUserGroups.length) {
                    userGroupsEmpty = true;
                }
                if (userGroupsEmpty && principalsEmpty) {
                    String msg = localStrings.getString(PRINCIPALS_USERGROUPS_NULL);
                    throw new Exception(msg);
                }
            }
            if (addPrincipals != null) {
                for (i2 = 0; i2 < addPrincipals.length; ++i2) {
                    String s4 = addPrincipals[i2];
                    if (source.contains(s4)) {
                        String msg = localStrings.getString(PRINCIPAL_EXISTS, s4, poolname);
                        throw new Exception(msg);
                    }
                    source.add(s4);
                }
            }
            if (removePrincipals != null) {
                for (i2 = 0; i2 < removePrincipals.length; ++i2) {
                    String s5 = removePrincipals[i2];
                    source.remove(s5);
                }
            }
            String[] newPrincipals = new String[source.size()];
            for (i = 0; i < source.size(); ++i) {
                newPrincipals[i] = (String)source.get(i);
            }
            if (addUserGroups != null) {
                for (i = 0; i < addUserGroups.length; ++i) {
                    s = addUserGroups[i];
                    if (source1.contains(s)) {
                        String msg = localStrings.getString(USERGROUP_EXISTS, s, poolname);
                        throw new Exception(msg);
                    }
                    source1.add(s);
                }
            }
            if (removeUserGroups != null) {
                for (i = 0; i < removeUserGroups.length; ++i) {
                    s = removeUserGroups[i];
                    source1.remove(s);
                }
            }
            String[] newUserGroups = new String[source1.size()];
            for (int i4 = 0; i4 < source1.size(); ++i4) {
                newUserGroups[i4] = (String)source1.get(i4);
            }
            Attribute princ = null;
            Attribute ug = null;
            if (newPrincipals != null) {
                princ = new Attribute(PRINCIPAL, newPrincipals);
                server.setAttribute(mbean, princ);
            }
            if (newUserGroups != null) {
                ug = new Attribute(USER_GROUP, newUserGroups);
                server.setAttribute(mbean, ug);
            }
            ObjectName backendPrincipal = (ObjectName)this.getMBeanServer().invoke(mbean, GET_BACKEND_PRINCIPAL, null, null);
            if (username != null && !((String)server.getAttribute(backendPrincipal, USER_NAME)).equals(username)) {
                server.setAttribute(backendPrincipal, new Attribute(USER_NAME, username));
            }
            if (password != null && !((String)server.getAttribute(backendPrincipal, PASSWORD)).equals(password)) {
                server.setAttribute(backendPrincipal, new Attribute(PASSWORD, password));
            }
            status = true;
        }
        catch (Exception e) {
            status = false;
            e.printStackTrace();
            throw new MBeanException(e);
        }
        return status;
    }

    public ArrayList listSecurityMap(String mapName, Boolean verb, String poolName, String tgtName) throws MBeanException {
        Object mbean = null;
        boolean verbose = false;
        ArrayList<String[]> list = new ArrayList<String[]>();
        try {
            if (tgtName == null || tgtName.equals("")) {
                tgtName = DEFAULT_TARGET;
            }
            if (!this.doesPoolNameExists(poolName)) {
                String msg = localStrings.getString(POOL_DOES_NOT_EXISTS, poolName);
                throw new Exception(msg);
            }
            if (mapName != null && !this.doesMapNameExists(poolName, mapName)) {
                String msg = localStrings.getString(MAP_DOES_NOT_EXISTS, mapName, poolName);
                throw new Exception(msg);
            }
            verbose = verb;
            ObjectName[] maps = (ObjectName[])super.invoke(GET_SECURITY_MAP, null, null);
            if (mapName == null && verbose) {
                if (maps != null && maps.length > 0) {
                    for (int i = 0; i < maps.length; ++i) {
                        String map = (String)this.getMBeanServer().getAttribute(maps[i], NAME);
                        ObjectName mapRef = (ObjectName)super.invoke(GET_SECURITY_MAP_BY_NAME, new Object[]{map}, new String[]{"java.lang.String"});
                        list.add(this.createMapInfo(mapRef));
                    }
                }
            } else if (mapName == null && !verbose) {
                if (maps != null && maps.length > 0) {
                    for (int i = 0; i < maps.length; ++i) {
                        String map = (String)this.getMBeanServer().getAttribute(maps[i], NAME);
                        AttributeList attr = new AttributeList();
                        if (map != null) {
                            attr.add(new Attribute(NAME, map));
                        }
                        ObjectName mapRef = (ObjectName)super.invoke(GET_SECURITY_MAP_BY_NAME, new Object[]{map}, new String[]{"java.lang.String"});
                        String mapname = (String)this.getMBeanServer().getAttribute(mapRef, NAME);
                        list.add(new String[]{mapname, null, null, null, null});
                    }
                }
            } else {
                ObjectName mapRef = (ObjectName)super.invoke(GET_SECURITY_MAP_BY_NAME, new Object[]{mapName}, new String[]{"java.lang.String"});
                if (mapRef != null) {
                    if (verbose) {
                        list.add(this.createMapInfo(mapRef));
                    } else {
                        list.add(new String[]{mapName, null, null, null, null});
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MBeanException(e);
        }
        return list;
    }

    public AttributeList getAttributes(String mapName, String poolName) throws Exception {
        ObjectName backEndPrincipal;
        String mapname = null;
        String[] existingPrincipals = null;
        String[] existingUserGroups = null;
        String username = null;
        String password = null;
        if (mapName != null && !this.doesMapNameExists(poolName, mapName)) {
            String msg = localStrings.getString(MAP_DOES_NOT_EXISTS, mapName, poolName);
            throw new Exception(msg);
        }
        ObjectName mapRef = (ObjectName)super.invoke(GET_SECURITY_MAP_BY_NAME, new Object[]{mapName}, new String[]{"java.lang.String"});
        if (mapRef != null) {
            mapname = (String)this.getMBeanServer().getAttribute(mapRef, NAME);
            existingPrincipals = (String[])this.getMBeanServer().getAttribute(mapRef, PRINCIPAL);
            existingUserGroups = (String[])this.getMBeanServer().getAttribute(mapRef, USER_GROUP);
        }
        if ((backEndPrincipal = (ObjectName)this.getMBeanServer().invoke(mapRef, GET_BACKEND_PRINCIPAL, null, null)) != null) {
            username = (String)this.getMBeanServer().getAttribute(backEndPrincipal, USER_NAME);
            password = (String)this.getMBeanServer().getAttribute(backEndPrincipal, PASSWORD);
        }
        AttributeList attributes = new AttributeList();
        if (mapname != null) {
            attributes.add(new Attribute(NAME, mapname));
        }
        if (existingPrincipals != null) {
            attributes.add(new Attribute(PRINCIPAL, existingPrincipals));
        }
        if (existingUserGroups != null) {
            attributes.add(new Attribute(USER_GROUP, existingUserGroups));
        }
        if (username != null) {
            attributes.add(new Attribute(USER_NAME, username));
        }
        if (password != null) {
            attributes.add(new Attribute(PASSWORD, password));
        }
        return attributes;
    }

    private ObjectName getConnectorConnObjectName(String poolName) throws Exception {
        return this.m_registry.getMbeanObjectName(POOL_TYPE, new String[]{this.getDomainName(), poolName, CONFIG});
    }

    private ObjectName getSecurityMapObjectName(String mapName, String poolName) throws Exception {
        return this.m_registry.getMbeanObjectName(MAP_TYPE, new String[]{this.getDomainName(), poolName, mapName, CONFIG});
    }

    private boolean isPrincipalExisting(String principal, ObjectName[] maps) throws Exception {
        boolean exists = false;
        String[] existingPrincipals = null;
        if (maps != null && maps.length > 0) {
            block0: for (int k = 0; k < maps.length && !exists; ++k) {
                existingPrincipals = (String[])this.getMBeanServer().getAttribute(maps[k], PRINCIPAL);
                if (existingPrincipals == null || principal == null) continue;
                for (int i = 0; i < existingPrincipals.length; ++i) {
                    if (!existingPrincipals[i].equals(principal)) continue;
                    exists = true;
                    continue block0;
                }
            }
        }
        return exists;
    }

    private boolean isUserGroupExisting(String usergroup, ObjectName[] maps) throws Exception {
        boolean exists = false;
        String[] existingUserGroups = null;
        if (maps != null && maps.length > 0) {
            block0: for (int k = 0; k < maps.length && !exists; ++k) {
                existingUserGroups = (String[])this.getMBeanServer().getAttribute(maps[k], USER_GROUP);
                if (existingUserGroups == null || usergroup == null) continue;
                for (int i = 0; i < existingUserGroups.length; ++i) {
                    if (!existingUserGroups[i].equals(usergroup)) continue;
                    exists = true;
                    continue block0;
                }
            }
        }
        return exists;
    }

    protected ObjectName getConfigMBean(Target target) throws Exception {
        ConfigTarget ct = target.getConfigTarget();
        return new ObjectName(ct.getTargetObjectName(new String[]{this.getDomainName()}));
    }

    private ObjectName[] getAllSecurityMapsForPool(String poolName) throws Exception {
        ObjectName poolObj = this.getConnectorConnObjectName(poolName);
        return (ObjectName[])this.getMBeanServer().invoke(poolObj, GET_SECURITY_MAP, null, null);
    }

    private boolean doesPoolNameExists(String poolName) throws Exception {
        ObjectName resObj = this.m_registry.getMbeanObjectName(RES_TYPE, new String[]{this.getDomainName(), CONFIG});
        ObjectName[] pools = (ObjectName[])this.getMBeanServer().invoke(resObj, GET_CONNECTOR_POOLS, null, null);
        boolean doesPoolExists = false;
        if (pools != null && pools.length > 0) {
            for (int i = 0; i < pools.length; ++i) {
                String pool = (String)this.getMBeanServer().getAttribute(pools[i], NAME);
                if (!pool.equals(poolName)) continue;
                doesPoolExists = true;
            }
        }
        return doesPoolExists;
    }

    private boolean doesMapNameExists(String poolName, String mapname) throws Exception {
        ObjectName poolObj = this.getConnectorConnObjectName(poolName);
        ObjectName[] maps = (ObjectName[])this.getMBeanServer().invoke(poolObj, GET_SECURITY_MAP, null, null);
        boolean doesMapNameExists = false;
        if (maps != null && maps.length > 0) {
            for (int i = 0; i < maps.length; ++i) {
                String mapName = (String)this.getMBeanServer().getAttribute(maps[i], NAME);
                if (!mapName.equals(mapname)) continue;
                doesMapNameExists = true;
            }
        }
        return doesMapNameExists;
    }

    private String[] createMapInfo(ObjectName mapRef) throws Exception {
        String[] existingPrincipals = null;
        String[] existingUserGroups = null;
        StringBuffer buf1 = new StringBuffer();
        StringBuffer buf2 = new StringBuffer();
        String mapname = null;
        String username = null;
        String password = null;
        if (mapRef != null) {
            ObjectName backEndPrincipal;
            int j;
            mapname = (String)this.getMBeanServer().getAttribute(mapRef, NAME);
            existingPrincipals = (String[])this.getMBeanServer().getAttribute(mapRef, PRINCIPAL);
            existingUserGroups = (String[])this.getMBeanServer().getAttribute(mapRef, USER_GROUP);
            if (existingPrincipals != null) {
                for (j = 0; j < existingPrincipals.length; ++j) {
                    buf1.append(existingPrincipals[j]);
                    buf1.append(",");
                }
            }
            if (existingUserGroups != null) {
                for (j = 0; j < existingUserGroups.length; ++j) {
                    buf2.append(existingUserGroups[j]);
                    buf2.append(",");
                }
            }
            if ((backEndPrincipal = (ObjectName)this.getMBeanServer().invoke(mapRef, GET_BACKEND_PRINCIPAL, null, null)) != null) {
                username = (String)this.getMBeanServer().getAttribute(backEndPrincipal, USER_NAME);
                password = (String)this.getMBeanServer().getAttribute(backEndPrincipal, PASSWORD);
            }
        }
        return new String[]{mapname, buf1.toString(), buf2.toString(), username, password};
    }

    private String[] getOptionsList(Object sOptions) {
        StringTokenizer optionTokenizer = new StringTokenizer((String)sOptions, ",");
        int size = optionTokenizer.countTokens();
        String[] sOptionsList = new String[size];
        for (int ii = 0; ii < size; ++ii) {
            sOptionsList[ii] = optionTokenizer.nextToken();
        }
        return sOptionsList;
    }

    protected MBeanServer getMBeanServer() {
        return MBeanServerFactory.getMBeanServer();
    }

    private static boolean isAttrNameMatch(Attribute attr, String name) {
        return attr.getName().replace('_', '-').equals(name.replace('_', '-'));
    }
}

