/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.mbeans.custom;

import com.sun.enterprise.admin.common.MBeanServerFactory;
import com.sun.enterprise.admin.event.AdminEventListenerException;
import com.sun.enterprise.admin.event.MBeanElementChangeEvent;
import com.sun.enterprise.admin.event.MBeanElementChangeEventListener;
import com.sun.enterprise.admin.mbeans.custom.CMBStrings;
import com.sun.enterprise.admin.mbeans.custom.loading.CustomMBeanRegistrationImpl;
import com.sun.enterprise.admin.mbeans.custom.loading.MBeanAttributeSetter;
import com.sun.enterprise.admin.server.core.CustomMBeanException;
import com.sun.enterprise.config.ConfigAdd;
import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigChange;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigDelete;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.ApplicationHelper;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.config.serverbeans.Mbean;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class InProcessMBeanElementChangeEventListenerImpl
implements MBeanElementChangeEventListener {
    private static final Logger logger = Logger.getLogger("javax.enterprise.system.tools.admin");
    private final MBeanServer mbs = MBeanServerFactory.getMBeanServer();

    public void handleUpdate(MBeanElementChangeEvent event) throws AdminEventListenerException {
        try {
            ConfigContext rcc = event.getConfigContext();
            ArrayList changes = event.getConfigChangeList();
            for (ConfigChange change : changes) {
                this.handleUpdate(rcc, change);
            }
        }
        catch (AdminEventListenerException ae) {
            throw ae;
        }
        catch (Exception e) {
            throw new AdminEventListenerException(e);
        }
    }

    public void handleCreate(MBeanElementChangeEvent event) throws AdminEventListenerException {
        try {
            ConfigContext rcc = event.getConfigContext();
            ArrayList additions = event.getConfigChangeList();
            for (ConfigAdd added : additions) {
                Mbean mb;
                ConfigBean co;
                String xp = added.getXPath();
                if (xp == null || !((co = rcc.exactLookup(xp)) instanceof ApplicationRef) || !((co = ApplicationHelper.findApplication(rcc, ((ApplicationRef)co).getRef())) instanceof Mbean) || !(mb = (Mbean)co).isEnabled()) continue;
                this.register(mb);
            }
        }
        catch (Exception e) {
            throw new AdminEventListenerException(e);
        }
    }

    public void handleDelete(MBeanElementChangeEvent event) throws AdminEventListenerException {
        try {
            ConfigContext occ = event.getOldConfigContext();
            ArrayList deletions = event.getConfigChangeList();
            for (ConfigDelete deleted : deletions) {
                ConfigBean co;
                String xp = deleted.getXPath();
                if (xp == null || !((co = occ.exactLookup(xp)) instanceof ApplicationRef) || !((co = ApplicationHelper.findApplication(occ, ((ApplicationRef)co).getRef())) instanceof Mbean)) continue;
                Mbean mbean = (Mbean)co;
                this.unregister(mbean);
                logger.info(CMBStrings.get("cmb.successfulDelete", mbean.getName()));
            }
        }
        catch (Exception e) {
            throw new AdminEventListenerException(e);
        }
    }

    protected void register(Mbean mbean) throws Exception {
        ObjectName on = CustomMBeanRegistrationImpl.getCascadingAwareObjectName(mbean);
        if (this.mbs.isRegistered(on)) {
            logger.info(CMBStrings.get("cmb.unsuccessfulRegistration", on));
        } else {
            CustomMBeanRegistrationImpl cmr = new CustomMBeanRegistrationImpl(this.mbs);
            cmr.registerMBean(mbean);
            logger.info(CMBStrings.get("cmb.successfulRegistration", mbean.getName()));
        }
    }

    protected void unregister(Mbean mbean) throws Exception {
        ObjectName on = CustomMBeanRegistrationImpl.getCascadingAwareObjectName(mbean);
        if (this.mbs.isRegistered(on)) {
            this.mbs.unregisterMBean(on);
            logger.info(CMBStrings.get("cmb.successfulUnRegistration", on));
        } else {
            logger.info(CMBStrings.get("cmb.unsuccessfulUnRegistration", on));
        }
    }

    private void handleUpdate(ConfigContext rcc, ConfigChange change) throws JMException, ConfigException, AdminEventListenerException, CustomMBeanException {
        String xp = change.getXPath();
        if (xp == null) {
            return;
        }
        logger.fine(CMBStrings.get("cmb.gotConfigChange", xp));
        ConfigBean changedObject = rcc.exactLookup(xp);
        String parentPath = xp.substring(0, xp.lastIndexOf("/"));
        ConfigBean parent = null;
        try {
            parent = rcc.exactLookup(parentPath);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (changedObject instanceof Mbean) {
            this.handleUpdate((Mbean)changedObject);
        } else if (changedObject instanceof ElementProperty) {
            this.handleUpdate(parent, (ElementProperty)changedObject);
        } else if (changedObject instanceof ApplicationRef) {
            this.handleUpdate(rcc, (ApplicationRef)changedObject);
        } else {
            throw new AdminEventListenerException(CMBStrings.get("InternalError", "Can't handle this: ", changedObject.getClass()));
        }
    }

    private void handleUpdate(Mbean mbean) {
        logger.info(CMBStrings.get("cmb.illegalHandleUpdate", mbean.getName()));
    }

    private void handleUpdate(Object parent, ElementProperty ep) throws JMException, CustomMBeanException {
        Mbean mbean = (Mbean)parent;
        if (!mbean.isEnabled()) {
            logger.info(CMBStrings.get("cmb.mbeanIsDisabled", mbean.getName()));
            return;
        }
        ObjectName on = new ObjectName(mbean.getObjectName());
        MBeanAttributeSetter mas = new MBeanAttributeSetter(this.mbs, on);
        mas.setIt(ep.getName(), ep.getValue());
    }

    private void handleUpdate(ConfigContext rcc, ApplicationRef ref) throws JMException, ConfigException, AdminEventListenerException {
        String mbeanName = ref.getRef();
        Mbean mbean = (Mbean)ApplicationHelper.findApplication(rcc, mbeanName);
        try {
            if (ref.isEnabled()) {
                this.register(mbean);
            } else {
                this.unregister(mbean);
            }
        }
        catch (Exception e) {
            throw new AdminEventListenerException(e);
        }
    }
}

