/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.mbeans.custom.loading;

import com.sun.enterprise.admin.mbeans.custom.CMBStrings;
import com.sun.enterprise.admin.mbeans.custom.ObjectNameSelectionAlgorithm;
import com.sun.enterprise.admin.mbeans.custom.loading.MBeanAttributeSetter;
import com.sun.enterprise.admin.mbeans.custom.loading.MBeanClassLoader;
import com.sun.enterprise.admin.server.core.CustomMBeanException;
import com.sun.enterprise.admin.server.core.CustomMBeanRegistration;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.config.serverbeans.Mbean;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CustomMBeanRegistrationImpl
implements CustomMBeanRegistration {
    private final MBeanServer mbs;
    private ClassLoader cl;
    private static final Logger logger = Logger.getLogger("javax.enterprise.system.tools.admin");

    public CustomMBeanRegistrationImpl(MBeanServer mbs) throws CustomMBeanException {
        this.mbs = mbs;
        this.cl = new MBeanClassLoader();
    }

    @Override
    public void registerMBeans(List<Mbean> mbeans, boolean continueReg) throws RuntimeException {
        if (mbeans == null) {
            throw new IllegalArgumentException(CMBStrings.get("InternalError", "registerMBeans() received a null mbeans argument"));
        }
        for (Mbean mbean : mbeans) {
            try {
                this.registerMBean(mbean);
            }
            catch (Throwable t) {
                if (continueReg) {
                    logger.info(CMBStrings.get("cmb.registerError", mbean.getName()));
                    continue;
                }
                throw new RuntimeException(t);
            }
        }
    }

    @Override
    public void registerMBeans(List<Mbean> mbeans) throws RuntimeException {
        this.registerMBeans(mbeans, true);
    }

    @Override
    public void setClassLoader(ClassLoader cl) throws IllegalArgumentException {
        if (cl == null) {
            throw new IllegalArgumentException(CMBStrings.get("InternalError", "setClassLoader() received a null argument"));
        }
        this.cl = cl;
    }

    @Override
    public ObjectName registerMBean(Mbean mbean) throws CustomMBeanException {
        if (mbean == null) {
            throw new CustomMBeanException(CMBStrings.get("InternalError", "registerMBean() received a null argument"));
        }
        ObjectName ron = null;
        try {
            logger.fine(CMBStrings.get("cmb.loadingMBean1", mbean.getName()));
            ObjectName mon = CustomMBeanRegistrationImpl.getCascadingAwareObjectName(mbean);
            logger.fine(CMBStrings.get("cmb.loadingMBean2", mon.toString()));
            Class mc = this.loadIt(mbean);
            Object mo = this.newIt(mc);
            ron = this.registerIt(mo, mon);
            if (!ObjectNameSelectionAlgorithm.implementsMBeanRegistrationInterface(mbean.getImplClassName()) && !mon.equals(ron)) {
                throw new CustomMBeanException(CMBStrings.get("objNameMismatch", mon, ron));
            }
            this.initIt(mbean, ron);
            if (!mbean.isEnabled()) {
                this.unregisterIt(mbean, ron);
            }
            return ron;
        }
        catch (CustomMBeanException cmbe) {
            if (ron != null) {
                try {
                    this.unregisterIt(mbean, ron);
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            throw cmbe;
        }
        catch (Throwable e) {
            if (ron != null) {
                try {
                    this.unregisterIt(mbean, ron);
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            throw new CustomMBeanException(e);
        }
    }

    public static ObjectName getCascadingAwareObjectName(Mbean mbean) throws CustomMBeanException {
        try {
            ObjectName configON = new ObjectName(mbean.getObjectName());
            return CustomMBeanRegistrationImpl.getCascadingAwareObjectName(configON);
        }
        catch (CustomMBeanException cmbe) {
            throw cmbe;
        }
        catch (Exception e) {
            throw new CustomMBeanException(e);
        }
    }

    public static ObjectName getCascadingAwareObjectName(ObjectName configON) throws CustomMBeanException {
        try {
            String serverNameKey = "server";
            String serverNameVal = System.getProperty("com.sun.aas.instanceName");
            Hashtable<String, String> properties = configON.getKeyPropertyList();
            properties.put("server", serverNameVal);
            ObjectName ron = new ObjectName(configON.getDomain(), properties);
            return ron;
        }
        catch (Exception e) {
            throw new CustomMBeanException(e);
        }
    }

    public static ObjectName getCascadingUnawareObjectName(ObjectName cascadeON) throws CustomMBeanException {
        if (cascadeON == null) {
            throw new CustomMBeanException(CMBStrings.get("InternalError", "getCascadingUnawareObjectName() received a null argument"));
        }
        try {
            ObjectName ron = cascadeON;
            String serverNameKey = "server";
            Hashtable<String, String> properties = cascadeON.getKeyPropertyList();
            if (properties.containsKey("server")) {
                Hashtable<String, String> np = new Hashtable<String, String>(properties);
                np.remove("server");
                ron = new ObjectName(cascadeON.getDomain(), np);
            }
            return ron;
        }
        catch (Exception e) {
            throw new CustomMBeanException(e);
        }
    }

    private Class loadIt(Mbean mbean) throws CustomMBeanException {
        String classname = mbean.getImplClassName();
        try {
            Class<?> c = this.cl.loadClass(classname);
            logger.fine(CMBStrings.get("cmb.loadingMBean8", c.getName(), this.cl.getClass().getName(), c.getClassLoader().getClass().getName()));
            return c;
        }
        catch (ClassNotFoundException cnfe) {
            logger.info(CMBStrings.get("cmb.loadingMBean3", mbean.getImplClassName(), this.cl.getClass().getName()));
            throw new CustomMBeanException(cnfe);
        }
        catch (NoClassDefFoundError ncdfe) {
            logger.info(CMBStrings.get("cmb.loadingMBean4", mbean.getImplClassName(), this.cl.getClass().getName()));
            throw new CustomMBeanException(ncdfe);
        }
        catch (Exception e) {
            throw new CustomMBeanException(e);
        }
    }

    private Object newIt(Class c) throws CustomMBeanException {
        String name = null;
        try {
            name = c.getName();
            return c.newInstance();
        }
        catch (InstantiationException ie) {
            logger.info(CMBStrings.get("cmb.loadingMBean5", name));
            throw new CustomMBeanException(ie);
        }
        catch (IllegalAccessException iae) {
            logger.info(CMBStrings.get("cmb.loadingMBean6", name));
            throw new CustomMBeanException(iae);
        }
        catch (ExceptionInInitializerError eie) {
            logger.info(CMBStrings.get("cmb.loadingMBean7", name));
            throw new CustomMBeanException(eie);
        }
        catch (Throwable t) {
            String message = CMBStrings.get("cmb.newingMBean", c.getName(), t);
            logger.warning(message);
            throw new CustomMBeanException(message, t);
        }
    }

    private ObjectName registerIt(Object mo, ObjectName on) throws CustomMBeanException {
        if (mo == null) {
            throw new CustomMBeanException(CMBStrings.get("objNameNull"));
        }
        try {
            ObjectInstance oi = this.mbs.registerMBean(mo, on);
            return oi.getObjectName();
        }
        catch (Exception e) {
            throw new CustomMBeanException(e);
        }
    }

    private void initIt(Mbean mbc, ObjectName on) throws CustomMBeanException {
        try {
            ElementProperty[] ats;
            MBeanAttributeSetter mas = new MBeanAttributeSetter(this.mbs, on);
            for (ElementProperty p : ats = mbc.getElementProperty()) {
                mas.setIt(p.getName(), p.getValue());
                logger.fine(CMBStrings.get("cmb.initMBean", p.getName(), mbc.getName()));
            }
        }
        catch (CustomMBeanException cmbe) {
            throw cmbe;
        }
        catch (Throwable t) {
            throw new CustomMBeanException(t);
        }
    }

    private void unregisterIt(Mbean m, ObjectName ron) {
        try {
            if (this.mbs.isRegistered(ron)) {
                this.mbs.unregisterMBean(ron);
            }
        }
        catch (Exception e) {
            logger.warning(CMBStrings.get("cmb.unloadMBeanError", m.getName()));
        }
    }
}

