/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.selfmanagement.event;

import com.sun.enterprise.admin.common.MBeanServerFactory;
import com.sun.enterprise.admin.selfmanagement.event.Event;
import com.sun.enterprise.admin.selfmanagement.event.LogEventFilter;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotificationFilter;
import javax.management.ObjectName;

public class LogEvent
implements Event {
    private static final StringManager sm = StringManager.getManager(LogEvent.class);
    private static final Logger _logger = LogDomains.getLogger("javax.enterprise.system.core.selfmanagement");
    private static volatile ObjectName objName = null;
    private static final String defaultDescription = sm.getString("selfmgmt_event.log_event_description");
    private final String description;
    private final LogEventFilter notificationFilter;

    public LogEvent(LogEventFilter filter, String descriptionIn) {
        this.notificationFilter = filter;
        this.description = descriptionIn != null ? descriptionIn : defaultDescription;
    }

    public ObjectName getObjectName() {
        return LogEvent.getLogObjectName();
    }

    public String getType() {
        return "log";
    }

    public NotificationFilter getNotificationFilter() {
        return this.notificationFilter;
    }

    public String getDescription() {
        return this.description;
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ObjectName getLogObjectName() {
        if (objName != null) {
            return objName;
        }
        Class<LogEvent> clazz = LogEvent.class;
        synchronized (LogEvent.class) {
            try {
                objName = new ObjectName("amx:j2eeType=X-Logging,name=" + System.getProperty("com.sun.aas.instanceName") + ",X-ServerRootMonitor=" + System.getProperty("com.sun.aas.instanceName"));
                MBeanServer mbeanServer = MBeanServerFactory.getMBeanServer();
                if (mbeanServer.isRegistered(objName)) {
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return objName;
                }
                _logger.log(Level.WARNING, "smgt.internal_error", new Object[]{sm.getString("selfmgmt_event.log_mbean_is_not_available")});
            }
            catch (MalformedObjectNameException mex) {
                _logger.log(Level.WARNING, "smgt.internal_error", mex);
            }
            return objName;
        }
    }
}

