/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.server.core.jmx;

import com.sun.appserv.management.helper.AMXDebugHelper;
import com.sun.appserv.management.util.misc.TypeCast;
import com.sun.enterprise.admin.AdminContext;
import com.sun.enterprise.admin.event.EventStack;
import com.sun.enterprise.admin.server.core.AdminNotificationHelper;
import com.sun.enterprise.admin.server.core.ConfigInterceptor;
import com.sun.enterprise.admin.util.proxy.ProxyFactory;
import com.sun.enterprise.config.ConfigChange;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.interceptor.DynamicInterceptorHook;
import java.util.List;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class FlushConfigHook
implements DynamicInterceptorHook {
    private static final Logger sLogger = Logger.getLogger("javax.enterprise.system.tools.admin");
    private MBeanServer mSuppliedMBeanServer = null;
    private MBeanServer mDelegateMBeanServer = null;
    private AdminContext mAdminContext;
    private AdminNotificationHelper mAdminNotificationHelper;
    private AMXDebugHelper mDebug = new AMXDebugHelper("__FlushConfigHook__");
    static final boolean USE_OLD_CONFIG_INTERCEPTOR = true;
    static final boolean EVENT_STACK_ISNT_POINTLESS = false;
    private static final boolean ENABLED = false;
    private static InheritableThreadLocal sDepth = new InheritableThreadLocal(){

        protected synchronized Object initialValue() {
            return INTEGER_0;
        }
    };
    private static final Integer INTEGER_0 = new Integer(0);
    private static final Integer INTEGER_1 = new Integer(1);
    private static boolean LOG_CONFIG_CHANGES = true;

    public FlushConfigHook(AdminContext adminContext) {
        this.mAdminContext = adminContext;
        this.mAdminNotificationHelper = new AdminNotificationHelper(this.mAdminContext);
        this.mDebug.setEchoToStdOut(false);
        this.debug("FlushConfigHook created OK");
    }

    private void debug(Object ... args) {
        if (this.mDebug.getDebug()) {
            this.mDebug.println(args);
        }
    }

    private AdminNotificationHelper getAdminNotificationHelper() {
        return this.mAdminNotificationHelper;
    }

    public void setDelegateMBeanServer(MBeanServer mbs) {
        if (mbs == null) {
            throw new IllegalArgumentException();
        }
        if (this.mSuppliedMBeanServer != null) {
            throw new IllegalArgumentException("already have an MBeanServer");
        }
        this.mSuppliedMBeanServer = mbs;
        this.debug("FlushConfigHook.setDelegateMBeanServer(): instantiating ConfigInterceptor");
        ConfigInterceptor configInterceptor = new ConfigInterceptor(this.mAdminContext);
        this.mDelegateMBeanServer = (MBeanServer)ProxyFactory.createProxy(MBeanServer.class, this.mSuppliedMBeanServer, configInterceptor);
        this.debug("FlushConfigHook.setDelegateMBeanServer(): instantiated ConfigInterceptor");
    }

    public AdminContext getAdminContext() {
        return this.mAdminContext;
    }

    private final boolean isRelevantInvoke(ObjectName objectName, String operationName) {
        boolean relevant = false;
        String domain = objectName.getDomain();
        return relevant;
    }

    private static Integer getDepth() {
        return (Integer)sDepth.get();
    }

    private static void setDepth(Integer i) {
        sDepth.set(i);
    }

    private void dumpEventStack(EventStack eventStack) {
        if (LOG_CONFIG_CHANGES) {
            List<ConfigChange> changes = TypeCast.asList(eventStack.getConfigChangeList());
            String msg = "CONFIG CHANGES: " + changes.size() + ": \n{";
            for (ConfigChange configChange : changes) {
                msg = msg + configChange.getConfigChangeType() + "=" + configChange.getName() + ": " + configChange.getXPath();
            }
            msg = msg + "}";
            this.debug(msg);
        }
    }

    private EventStack setupEventStack(Integer startDepthInteger) {
        EventStack eventStack = null;
        return eventStack;
    }

    private void checkDepth(Integer startDepthInteger, EventStack eventStack, boolean success) throws ReflectionException {
        FlushConfigHook.setDepth(startDepthInteger);
        if (startDepthInteger == 0 && success) {
            ConfigContext configContext = this.getAdminContext().getAdminConfigContext();
            boolean needFlush = configContext.isChanged();
            if (needFlush) {
                this.debug("FlushConfigHook.checkDepth(): CHANGED, need flush");
                this.dumpEventStack(eventStack);
                this.debug("FlushConfigHook.checkDepth: Config has changed, flushing...");
                try {
                    configContext.flush();
                }
                catch (ConfigException e) {
                    throw new ReflectionException(e);
                }
                this.debug("FlushConfigHook.checkDepth: done flushing changed config, sending Notification");
            } else {
                this.debug("FlushConfigHook.checkDepth(): unchanged, no flush needed");
            }
        }
    }

    public Object invoke(ObjectName objectName, String operationName, Object[] params, String[] signature) throws ReflectionException, InstanceNotFoundException, MBeanException {
        Object result = null;
        this.debug("FlushConfigHook.invoke(): ", objectName, ".", operationName, "{", params, "}", "{", signature, "}");
        result = this.mDelegateMBeanServer.invoke(objectName, operationName, params, signature);
        this.debug("FlushConfigHook.invoke: ", objectName, operationName, "() DONE");
        return result;
    }

    public void setAttribute(ObjectName objectName, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, MBeanException, ReflectionException, InvalidAttributeValueException {
        this.debug("FlushConfigHook.setAttribute(): ", objectName, ", ", attribute.getName(), "=", attribute.getValue());
        this.mDelegateMBeanServer.setAttribute(objectName, attribute);
    }

    public AttributeList setAttributes(ObjectName objectName, AttributeList attributeList) throws InstanceNotFoundException, ReflectionException {
        this.debug("FlushConfigHook.setAttributes(): ", objectName, ", ", attributeList);
        AttributeList result = null;
        result = this.mDelegateMBeanServer.setAttributes(objectName, attributeList);
        return result;
    }

    public Object getAttribute(ObjectName objectName, String attrName) throws InstanceNotFoundException, ReflectionException, MBeanException, AttributeNotFoundException {
        Object result = this.mDelegateMBeanServer.getAttribute(objectName, attrName);
        return result;
    }

    public AttributeList getAttributes(ObjectName objectName, String[] attrNames) throws InstanceNotFoundException, ReflectionException {
        AttributeList result = this.mDelegateMBeanServer.getAttributes(objectName, attrNames);
        return result;
    }

    public ClassLoader getClassLoader(ObjectName objectName) throws InstanceNotFoundException {
        return this.mDelegateMBeanServer.getClassLoader(objectName);
    }

    public ClassLoader getClassLoaderFor(ObjectName objectName) throws InstanceNotFoundException {
        return this.mDelegateMBeanServer.getClassLoaderFor(objectName);
    }

    public MBeanInfo getMBeanInfo(ObjectName objectName) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        return this.mDelegateMBeanServer.getMBeanInfo(objectName);
    }
}

