/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.work.monitor;

import com.sun.enterprise.admin.monitor.stats.ConnectorWorkMgmtStats;
import com.sun.enterprise.admin.monitor.stats.CountStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.GenericStatsImpl;
import com.sun.enterprise.admin.monitor.stats.MutableCountStatistic;
import com.sun.enterprise.admin.monitor.stats.MutableCountStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.RangeStatisticImpl;
import com.sun.enterprise.connectors.ActiveInboundResourceAdapter;
import com.sun.enterprise.connectors.work.monitor.MonitorableWorkManager;
import com.sun.enterprise.resource.monitor.AbstractStatsImpl;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.j2ee.statistics.CountStatistic;
import javax.management.j2ee.statistics.RangeStatistic;

public final class ConnectorWorkMgmtStatsImpl
extends AbstractStatsImpl
implements ConnectorWorkMgmtStats {
    private static final Logger _logger = LogDomains.getLogger("javax.enterprise.resource.resourceadapter");
    private GenericStatsImpl gsImpl;
    private RangeStatistic activeWorkCount;
    private RangeStatistic waitQueueLength;
    private RangeStatistic workRequestWaitTime;
    private MutableCountStatistic submittedWorkCount;
    private MutableCountStatistic rejectedWorkCount;
    private MutableCountStatistic completedWorkCount;
    private MonitorableWorkManager workManager;

    public ConnectorWorkMgmtStatsImpl(ActiveInboundResourceAdapter inboundRA) {
        this.workManager = (MonitorableWorkManager)inboundRA.getBootStrapContext().getWorkManager();
        this.initializeStatistics();
        try {
            this.gsImpl = new GenericStatsImpl(this.getClass().getInterfaces()[0].getName(), (Object)this);
        }
        catch (ClassNotFoundException cnfe) {
            _logger.log(Level.INFO, "workmgmtmon.cnfe", "GenericStatsImpl");
        }
    }

    private void initializeStatistics() {
        long time = System.currentTimeMillis();
        CountStatisticImpl cs = null;
        cs = new CountStatisticImpl(0L, "SubmittedWorkCount", "", "Number of work objects submitted by a connector module for  executionWorkQueue before executing", time, time);
        this.submittedWorkCount = new MutableCountStatisticImpl((CountStatistic)cs);
        cs = new CountStatisticImpl(0L, "RejectedWorkCount", "", "Number of work objects rejected by the application server", time, time);
        this.rejectedWorkCount = new MutableCountStatisticImpl((CountStatistic)cs);
        cs = new CountStatisticImpl(0L, "CompletedWorkCount", "", "Number of work objects completed execution", time, time);
        this.completedWorkCount = new MutableCountStatisticImpl((CountStatistic)cs);
        this.activeWorkCount = new RangeStatisticImpl(0L, 0L, 1L, "ActiveWorkCount", "", "Number of active work objects", time, time);
        this.waitQueueLength = new RangeStatisticImpl(0L, 0L, 1L, "WaitQueueLength", "", "Number of work objects waiting in the queue for execution", time, time);
        this.workRequestWaitTime = new RangeStatisticImpl(0L, 0L, 1L, "workRequestWaitTime", "", "Number of work objects waiting in the queue for execution", time, time);
    }

    public RangeStatistic getActiveWorkCount() {
        this.activeWorkCount = this.getUpdatedRangeStatistic(this.activeWorkCount, this.workManager.getCurrentActiveWorkCount(), this.workManager.getMaxActiveWorkCount(), this.workManager.getMinActiveWorkCount());
        return this.activeWorkCount;
    }

    public RangeStatistic getWaitQueueLength() {
        this.waitQueueLength = this.getUpdatedRangeStatistic(this.waitQueueLength, this.workManager.getWaitQueueLength(), this.workManager.getMaxWaitQueueLength(), this.workManager.getMinWaitQueueLength());
        return this.waitQueueLength;
    }

    public RangeStatistic getWorkRequestWaitTime() {
        this.workRequestWaitTime = this.getUpdatedRangeStatistic(this.workRequestWaitTime, 0L, this.workManager.getMaxWorkRequestWaitTime(), this.workManager.getMinWorkRequestWaitTime());
        return this.workRequestWaitTime;
    }

    public CountStatistic getSubmittedWorkCount() {
        this.submittedWorkCount.setCount(this.workManager.getSubmittedWorkCount());
        return (CountStatistic)this.submittedWorkCount.unmodifiableView();
    }

    public CountStatistic getRejectedWorkCount() {
        this.rejectedWorkCount.setCount(this.workManager.getRejectedWorkCount());
        return (CountStatistic)this.rejectedWorkCount.unmodifiableView();
    }

    public CountStatistic getCompletedWorkCount() {
        this.completedWorkCount.setCount(this.workManager.getCompletedWorkCount());
        return (CountStatistic)this.completedWorkCount.unmodifiableView();
    }
}

