/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.DeploymentExtensionDescriptor;
import com.sun.enterprise.deployment.DynamicAttributesDescriptor;
import com.sun.enterprise.deployment.util.DescriptorVisitor;
import com.sun.enterprise.util.NotificationEvent;
import com.sun.enterprise.util.NotificationListener;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class Descriptor
extends DynamicAttributesDescriptor
implements Serializable {
    public static final String DESCRIPTOR_CHANGED = "Descriptor change";
    public static final String NAME_CHANGED = "NameChanged";
    public static final String DESCRIPTION_CHANGED = "DescriptionChanged";
    public static final String LARGE_ICON_CHANGED = "LargeIconChanged";
    public static final String SMALL_ICON_CHANGED = "SmallIconChanged";
    private static boolean boundsChecking = true;
    protected Vector listeners = new Vector();
    private Map displayNames = null;
    private Map descriptions = null;
    private Map largeIcons = null;
    private Map smallIcons = null;
    public String docType = null;

    public Descriptor() {
        this.listeners = new Vector();
    }

    protected Descriptor(Descriptor other) {
        if (other.displayNames != null) {
            this.displayNames = new HashMap(other.displayNames);
        }
        if (other.descriptions != null) {
            this.descriptions = new HashMap(other.descriptions);
        }
        if (other.largeIcons != null) {
            this.largeIcons = new HashMap(other.largeIcons);
        }
        if (other.smallIcons != null) {
            this.smallIcons = new HashMap(other.smallIcons);
        }
    }

    public Descriptor(String name, String description) {
        this();
        this.setLocalizedDisplayName(null, name);
        this.setLocalizedDescription(null, description);
    }

    public static void setBoundsChecking(boolean b) {
        boundsChecking = b;
    }

    public static boolean isBoundsChecking() {
        return boundsChecking;
    }

    public void setName(String name) {
        this.setLocalizedDisplayName(null, name);
    }

    public String getName() {
        return this.getLocalizedDisplayName(null);
    }

    public void setLocalizedDisplayName(String lang, String displayName) {
        if (lang == null) {
            lang = Locale.getDefault().getLanguage();
        }
        if (this.displayNames == null) {
            this.displayNames = new HashMap();
        }
        this.displayNames.put(lang, displayName);
        this.changed(NAME_CHANGED);
    }

    public String getLocalizedDisplayName(String language) {
        String localizedName;
        if (this.displayNames == null) {
            return "";
        }
        String originalLanguage = language;
        if (language == null) {
            language = Locale.getDefault().getLanguage();
        }
        if ((localizedName = (String)this.displayNames.get(language)) != null) {
            return localizedName;
        }
        if (originalLanguage == null && this.displayNames.size() > 0) {
            return (String)this.displayNames.values().iterator().next();
        }
        return "";
    }

    public Map getLocalizedDisplayNames() {
        return this.displayNames;
    }

    public void setDisplayName(String name) {
        this.setName(name);
    }

    public String getDisplayName() {
        return this.getName();
    }

    public void setDescription(String description) {
        this.setLocalizedDescription(null, description);
    }

    public String getDescription() {
        return this.getLocalizedDescription(null);
    }

    public void setLocalizedDescription(String lang, String description) {
        if (lang == null) {
            lang = Locale.getDefault().getLanguage();
        }
        if (this.descriptions == null) {
            this.descriptions = new HashMap();
        }
        this.descriptions.put(lang, description);
        this.changed(DESCRIPTION_CHANGED);
    }

    public String getLocalizedDescription(String lang) {
        String description;
        if (this.descriptions == null) {
            return "";
        }
        if (lang == null) {
            lang = Locale.getDefault().getLanguage();
        }
        if ((description = (String)this.descriptions.get(lang)) == null) {
            return "";
        }
        return description;
    }

    public Map getLocalizedDescriptions() {
        return this.descriptions;
    }

    public void setLocalizedLargeIconUri(String lang, String uri) {
        if (lang == null) {
            lang = Locale.getDefault().getLanguage();
        }
        if (this.largeIcons == null) {
            this.largeIcons = new HashMap();
        }
        this.largeIcons.put(lang, uri);
        this.changed(LARGE_ICON_CHANGED);
    }

    public String getLocalizedLargeIconUri(String lang) {
        if (this.largeIcons == null) {
            return null;
        }
        if (lang == null) {
            lang = Locale.getDefault().getLanguage();
        }
        return (String)this.largeIcons.get(lang);
    }

    public Map getLocalizedLargeIconUris() {
        return this.largeIcons;
    }

    public void setLocalizedSmallIconUri(String lang, String uri) {
        if (lang == null) {
            lang = Locale.getDefault().getLanguage();
        }
        if (this.smallIcons == null) {
            this.smallIcons = new HashMap();
        }
        this.smallIcons.put(lang, uri);
        this.changed(LARGE_ICON_CHANGED);
    }

    public String getLocalizedSmallIconUri(String lang) {
        if (this.smallIcons == null) {
            return null;
        }
        if (lang == null) {
            lang = Locale.getDefault().getLanguage();
        }
        return (String)this.smallIcons.get(lang);
    }

    public Map getLocalizedSmallIconUris() {
        return this.smallIcons;
    }

    public String getLargeIconUri() {
        return this.getLocalizedLargeIconUri(null);
    }

    public void setLargeIconUri(String largeIconUri) {
        this.setLocalizedLargeIconUri(null, largeIconUri);
    }

    public String getSmallIconUri() {
        return this.getLocalizedSmallIconUri(null);
    }

    public void setSmallIconUri(String smallIconUri) {
        this.setLocalizedSmallIconUri(null, smallIconUri);
    }

    public void addNotificationListener(NotificationListener nl) {
        if (nl != null && !this.listeners.contains(nl)) {
            this.listeners.addElement(nl);
        }
    }

    public void removeNotificationListener(NotificationListener nl) {
        this.listeners.removeElement(nl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getNotificationListeners() {
        Vector listenersClone = null;
        Vector vector = this.listeners;
        synchronized (vector) {
            listenersClone = (Vector)this.listeners.clone();
        }
        return listenersClone;
    }

    public void changed(String attribute) {
        this.changed();
    }

    public void changed() {
        String attribute = "";
        NotificationEvent ne = new NotificationEvent((Object)this, DESCRIPTOR_CHANGED, this, (Object)attribute);
        List listenersClone = this.getNotificationListeners();
        for (NotificationListener nl : listenersClone) {
            nl.notification(ne);
        }
    }

    private static String stripIntegerEndingFrom(String s) {
        return Descriptor.recursiveStripIntegerEndingFrom(s);
    }

    private static String recursiveStripIntegerEndingFrom(String s) {
        if (s.length() > 1) {
            String shorterByOne = s.substring(0, s.length() - 1);
            String lastBit = s.substring(s.length() - 1, s.length());
            try {
                Integer.parseInt(lastBit);
                return Descriptor.recursiveStripIntegerEndingFrom(shorterByOne);
            }
            catch (NumberFormatException nfe) {
                return s;
            }
        }
        return s;
    }

    private static String uniquifyString(String trialName, Vector v, int index) {
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            String next = (String)e.nextElement();
            if (!next.equals(trialName)) continue;
            return Descriptor.uniquifyString(Descriptor.stripIntegerEndingFrom(trialName) + ++index, v, index);
        }
        return trialName;
    }

    public static String createUniqueFilenameAmongst(String trialName, Vector otherNames) {
        int p = trialName.lastIndexOf(".");
        if (p < 0) {
            return Descriptor.uniquifyString(trialName, otherNames, 0);
        }
        String ext = trialName.substring(p);
        String file = trialName.substring(0, p);
        Vector<String> nameList = new Vector<String>();
        Enumeration e = otherNames.elements();
        while (e.hasMoreElements()) {
            String name = e.nextElement().toString();
            if (!name.endsWith(ext)) continue;
            nameList.add(name.substring(0, name.length() - ext.length()));
        }
        String unique = Descriptor.uniquifyString(file, nameList, 0);
        return unique + ext;
    }

    public static String createUniqueNameAmongst(String trialName, Vector otherNames) {
        return Descriptor.uniquifyString(trialName, otherNames, 0);
    }

    public static String createUniqueNameAmongstNamedDescriptors(String trialName, Set descriptors) {
        Vector<String> v = new Vector<String>();
        for (Descriptor next : descriptors) {
            v.addElement(next.getName());
        }
        return Descriptor.createUniqueNameAmongst(trialName, v);
    }

    public void addDeploymentExtension(DeploymentExtensionDescriptor de) {
        Vector<DeploymentExtensionDescriptor> extensions = (Vector<DeploymentExtensionDescriptor>)this.getExtraAttribute("deployment-extension");
        if (extensions == null) {
            extensions = new Vector<DeploymentExtensionDescriptor>();
            this.addExtraAttribute("deployment-extension", extensions);
        }
        extensions.add(de);
    }

    public Iterator getDeploymentExtensions() {
        Vector extensions = (Vector)this.getExtraAttribute("deployment-extension");
        if (extensions != null) {
            return extensions.iterator();
        }
        return null;
    }

    public void addPrefixMapping(String mapping, String uri) {
        HashMap<String, String> prefixMapping = this.getPrefixMapping();
        if (prefixMapping == null) {
            prefixMapping = new HashMap<String, String>();
            this.addExtraAttribute("prefix-mapping", prefixMapping);
        }
        prefixMapping.put(mapping, uri);
    }

    public Map getPrefixMapping() {
        return (Map)this.getExtraAttribute("prefix-mapping");
    }

    public void print(StringBuffer toStringBuffer) {
        Iterator itr;
        Map prefix;
        StringBuffer sb = toStringBuffer;
        if (this.displayNames != null) {
            sb.append("Display Names:");
            this.displayLocalizedMap(sb, this.displayNames);
        }
        if (this.descriptions != null) {
            sb.append("\n Descriptions");
            this.displayLocalizedMap(sb, this.descriptions);
        }
        if (this.smallIcons != null) {
            sb.append("\n SmallIcons");
            this.displayLocalizedMap(sb, this.smallIcons);
        }
        if (this.largeIcons != null) {
            sb.append("\n LargeIcons");
            this.displayLocalizedMap(sb, this.largeIcons);
        }
        if ((prefix = this.getPrefixMapping()) != null) {
            sb.append("\n Prefix Mapping = ").append(prefix);
        }
        if ((itr = this.getDeploymentExtensions()) != null && itr.hasNext()) {
            do {
                sb.append("\n Deployment Extension : ");
                ((Descriptor)itr.next()).print(sb);
            } while (itr.hasNext());
        }
        sb.append("\n");
        super.print(sb);
    }

    private void displayLocalizedMap(StringBuffer sb, Map localizedMap) {
        for (String lang : localizedMap.keySet()) {
            sb.append("\n   lang[" + lang + "]  = " + localizedMap.get(lang));
        }
    }

    public void visit(DescriptorVisitor aVisitor) {
        aVisitor.accept(this);
    }

    private String getDefaultLanguage() {
        return Locale.getDefault().getLanguage();
    }

    public String getDocType() {
        return this.docType;
    }

    public void fillDocType(InputStream in) {
        try {
            BufferedReader inr = new BufferedReader(new InputStreamReader(in));
            String s = inr.readLine();
            while (s != null) {
                if (s.indexOf("DOCTYPE") > -1) {
                    this.docType = s;
                    in.close();
                    return;
                }
                s = inr.readLine();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

