/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.archivist;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.RootDeploymentDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.deploy.shared.AbstractArchive;
import com.sun.enterprise.deployment.deploy.shared.Archive;
import com.sun.enterprise.deployment.io.DeploymentDescriptorFile;
import com.sun.enterprise.deployment.io.WebDeploymentDescriptorFile;
import com.sun.enterprise.deployment.io.runtime.WebRuntimeDDFile;
import com.sun.enterprise.deployment.util.ApplicationValidator;
import com.sun.enterprise.deployment.util.DOLLoadingContextFactory;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.deployment.util.ModuleContentValidator;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import javax.enterprise.deploy.shared.ModuleType;
import org.xml.sax.SAXParseException;

public class WebArchivist
extends Archivist {
    private WebBundleDescriptor descriptor;
    DeploymentDescriptorFile standardDD = new WebDeploymentDescriptorFile();

    public ModuleType getModuleType() {
        return ModuleType.WAR;
    }

    public void setDescriptor(Descriptor descriptor) {
        if (!(descriptor instanceof WebBundleDescriptor)) {
            Set webBundles;
            if (descriptor instanceof Application && (webBundles = ((Application)descriptor).getWebBundleDescriptors()).size() > 0) {
                this.descriptor = (WebBundleDescriptor)webBundles.iterator().next();
                if (this.descriptor.getModuleDescriptor().isStandalone()) {
                    return;
                }
                this.descriptor = null;
            }
            DOLUtils.getDefaultLogger().log(Level.SEVERE, "enterprise.deployment.backend.descriptorFailure", new Object[]{this});
            throw new RuntimeException("Error setting descriptor " + descriptor + " in " + this);
        }
        this.descriptor = (WebBundleDescriptor)descriptor;
    }

    public String getWebServicesDeploymentDescriptorPath() {
        return "WEB-INF/webservices.xml";
    }

    public DeploymentDescriptorFile getStandardDDFile() {
        return this.standardDD;
    }

    public DeploymentDescriptorFile getConfigurationDDFile() {
        return new WebRuntimeDDFile();
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public Descriptor getDefaultBundleDescriptor() {
        WebBundleDescriptor webBundleDesc = DOLLoadingContextFactory.getDefaultWebBundleDescriptor();
        return webBundleDesc;
    }

    protected void postOpen(RootDeploymentDescriptor descriptor, AbstractArchive archive) throws IOException {
        super.postOpen(descriptor, archive);
        WebBundleDescriptor webBundle = (WebBundleDescriptor)descriptor;
        ModuleContentValidator mdv = new ModuleContentValidator(archive);
        webBundle.visit(mdv);
    }

    public void validate(ClassLoader aClassLoader) {
        ClassLoader cl = aClassLoader;
        if (cl == null) {
            cl = this.classLoader;
        }
        if (cl == null) {
            return;
        }
        this.descriptor.setClassLoader(cl);
        this.descriptor.visit(new ApplicationValidator());
    }

    protected boolean postHandles(AbstractArchive abstractArchive) throws IOException {
        return false;
    }

    protected String getArchiveExtension() {
        return ".war";
    }

    public Vector getLibraries(AbstractArchive archive) {
        Enumeration entries = archive.entries();
        if (entries == null) {
            return null;
        }
        Vector<String> libs = new Vector<String>();
        while (entries.hasMoreElements()) {
            String entryName = (String)entries.nextElement();
            if (!entryName.startsWith("WEB-INF/lib") || !entryName.endsWith(".jar")) continue;
            libs.add(entryName);
        }
        return libs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readPersistenceDeploymentDescriptors(AbstractArchive archive, Descriptor descriptor) throws IOException, SAXParseException {
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, "WebArchivist", "readPersistenceDeploymentDescriptors", "archive = {0}", archive.getURI());
        }
        HashMap<String, Archive> subArchives = new HashMap<String, Archive>();
        Enumeration entries = archive.entries();
        String CLASSES_DIR = "WEB-INF/classes/";
        String LIB_DIR = "WEB-INF/lib/";
        String JAR_EXT = ".jar";
        try {
            String pathOfPersistenceXMLInsideClassesDir = "WEB-INF/classes/META-INF/persistence.xml";
            while (entries.hasMoreElements()) {
                String nextEntry = (String)String.class.cast(entries.nextElement());
                if ("WEB-INF/classes/META-INF/persistence.xml".equals(nextEntry)) {
                    subArchives.put("WEB-INF/classes/", archive.getSubArchive("WEB-INF/classes/"));
                    continue;
                }
                if (!nextEntry.startsWith("WEB-INF/lib/") || !nextEntry.endsWith(".jar")) continue;
                String jarFile = nextEntry.substring("WEB-INF/lib/".length(), nextEntry.length() - ".jar".length());
                if (jarFile.indexOf(47) == -1) {
                    subArchives.put(nextEntry, archive.getSubArchive(nextEntry));
                    continue;
                }
                if (!logger.isLoggable(Level.FINE)) continue;
                logger.logp(Level.FINE, "WebArchivist", "readPersistenceDeploymentDescriptors", "skipping {0} as it exists inside a directory in {1}.", new Object[]{nextEntry, "WEB-INF/lib/"});
            }
            for (Map.Entry pathToArchiveEntry : subArchives.entrySet()) {
                this.readPersistenceDeploymentDescriptor((Archive)pathToArchiveEntry.getValue(), (String)pathToArchiveEntry.getKey(), descriptor);
            }
        }
        finally {
            for (Archive subArchive : subArchives.values()) {
                subArchive.close();
            }
        }
    }
}

