/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.backend;

import com.sun.ejb.codegen.IASEJBCTimes;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.backend.Deployer;
import com.sun.enterprise.deployment.backend.DeploymentCommand;
import com.sun.enterprise.deployment.backend.DeploymentEvent;
import com.sun.enterprise.deployment.backend.DeploymentEventInfo;
import com.sun.enterprise.deployment.backend.DeploymentEventManager;
import com.sun.enterprise.deployment.backend.DeploymentRequest;
import com.sun.enterprise.deployment.backend.DeploymentStatus;
import com.sun.enterprise.deployment.backend.EJBCompiler;
import com.sun.enterprise.deployment.backend.IASDeploymentException;
import com.sun.enterprise.deployment.deploy.shared.AbstractArchive;
import com.sun.enterprise.deployment.deploy.shared.FileArchiveFactory;
import com.sun.enterprise.deployment.phasing.DeploymentServiceUtils;
import com.sun.enterprise.instance.BaseManager;
import com.sun.enterprise.instance.InstanceEnvironment;
import com.sun.enterprise.instance.ModuleEnvironment;
import com.sun.enterprise.instance.WebModulesManager;
import com.sun.enterprise.loader.EJBClassPathUtils;
import com.sun.enterprise.tools.verifier.AppVerifier;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.io.FileSource;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.util.zip.ZipItem;
import com.sun.enterprise.webservice.WsUtil;
import java.io.File;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;

public abstract class ModuleDeployer
extends Deployer {
    protected BaseManager modulesMgr = null;
    protected String moduleName = null;
    protected File moduleDir = null;
    protected File stubsDir = null;
    protected File jspDir = null;
    protected File xmlDir = null;
    protected File jwsDir = null;
    protected File originalModuleDir = null;
    protected String originalContextRoot = null;
    protected ModuleEnvironment moduleEnv = null;
    protected boolean isMaybeCMPDropTables = false;
    private boolean isReg = false;
    private boolean shouldRollback = false;
    private boolean moduleDirWasRenamed = false;
    private Application moduleDD = null;
    private DeploymentStatus J2EECPhaseStatus = null;
    private static StringManager localStrings = StringManager.getManager(ModuleDeployer.class);

    protected abstract BaseManager createConfigManager(InstanceEnvironment var1, ModuleEnvironment var2) throws IASDeploymentException, ConfigException;

    protected abstract void preDeploy() throws IASDeploymentException;

    protected abstract void deploy() throws IASDeploymentException, ConfigException;

    protected ModuleDeployer(DeploymentRequest r) throws IASDeploymentException {
        super(r);
    }

    protected boolean needsStubs() {
        return false;
    }

    protected boolean needsJSPs() {
        return false;
    }

    protected final File getModuleDir() {
        return this.moduleDir;
    }

    public void doRequest() throws IASDeploymentException {
        this.doRequestPrepare();
        this.doRequestFinish();
    }

    public void doRequestPrepare() throws IASDeploymentException {
        try {
            this.begin();
        }
        catch (Exception e) {
            if (this.shouldRollback) {
                this.rollback();
            }
            String msg = localStrings.getString("enterprise.deployment.backend.dorequest_exception");
            if (e.getCause() != null) {
                msg = msg + e.getCause().toString();
            }
            this.logger.log(Level.WARNING, msg, e);
            throw new IASDeploymentException(msg, e);
        }
    }

    public void doRequestFinish() throws IASDeploymentException {
        block10: {
            try {
                this.J2EECPhaseStatus = this.request.getCurrentDeploymentStatus();
                if (this.request.isDeploy() || this.request.isReDeploy()) {
                    DeploymentStatus preDeployStatus = new DeploymentStatus(this.J2EECPhaseStatus);
                    this.request.setCurrentDeploymentStatus(preDeployStatus);
                    this.beginFinish();
                    this.preDeploy();
                    DeploymentStatus runEJBCStatus = new DeploymentStatus(this.J2EECPhaseStatus);
                    this.request.setCurrentDeploymentStatus(runEJBCStatus);
                    this.deploy();
                    this.register();
                    DeploymentStatus postDeployStatus = new DeploymentStatus(this.J2EECPhaseStatus);
                    this.request.setCurrentDeploymentStatus(postDeployStatus);
                    this.postDeploy();
                    this.generatePolicy();
                    break block10;
                }
                if (this.request.isUnDeploy()) {
                    this.beginFinish();
                    this.preundeploy();
                    this.undeploy();
                    this.removePolicy();
                    break block10;
                }
                String msg = localStrings.getString("enterprise.deployment.backend.unknown_deployment_command");
                throw new IASDeploymentException(msg);
            }
            catch (Exception e) {
                if (this.shouldRollback) {
                    this.rollback();
                }
                String msg = localStrings.getString("enterprise.deployment.backend.dorequest_exception");
                if (e.getCause() != null) {
                    msg = msg + e.getCause().toString();
                }
                this.logger.log(Level.FINE, msg, e);
                if (e instanceof IASDeploymentException) {
                    throw (IASDeploymentException)e;
                }
                throw new IASDeploymentException(msg, e);
            }
            finally {
                this.finish();
            }
        }
    }

    protected final void begin() throws IASDeploymentException {
        super.begin();
        InstanceEnvironment instanceEnv = this.getInstanceEnv();
        this.moduleEnv = this.request.getModuleEnv();
        this.moduleName = this.request.getName();
        if (this.moduleEnv == null) {
            String msg = localStrings.getString("enterprise.deployment.backend.null_moduleenvironment");
            throw new IASDeploymentException(msg);
        }
        try {
            this.moduleEnv.verify();
            this.modulesMgr = this.createConfigManager(instanceEnv, this.moduleEnv);
            this.isReg = DeploymentServiceUtils.isRegistered(this.moduleName, this.request.getType());
            this.setDeployCommand();
            if (this.request.isReDeploy()) {
                this.moduleDD = this.getManager().getRegisteredDescriptor(this.moduleName);
                if (this.moduleDD == null) {
                    this.moduleDD = this.request.getDescriptor();
                }
                this.originalModuleDir = new File(DeploymentServiceUtils.getLocation(this.moduleName, this.request.getType()));
                this.unregister();
                this.removePolicy();
            }
        }
        catch (Exception e) {
            if (e instanceof IASDeploymentException) {
                throw (IASDeploymentException)e;
            }
            throw new IASDeploymentException(e);
        }
        this.shouldRollback = true;
    }

    private void beginFinish() throws IASDeploymentException {
        this.setDirs();
        if (this.request.isDeploy()) {
            this.liquidate();
        }
        if (this.request.isReDeploy()) {
            DeploymentEventInfo info = new DeploymentEventInfo(this.moduleDir, this.stubsDir, this.moduleDD, this.getRequest());
            DeploymentEvent ev = new DeploymentEvent(1, info);
            DeploymentEventManager.notifyDeploymentEvent(ev);
            this.liquidate();
        }
    }

    private void setDirs() throws IASDeploymentException {
        assert (this.modulesMgr != null);
        assert (this.moduleName != null);
        assert (this.moduleEnv != null);
        if (this.request.isDeploy()) {
            this.setDirsDeploy();
        } else if (this.request.isReDeploy()) {
            this.setDirsReDeploy();
        } else if (this.request.isUnDeploy()) {
            this.setDirsUnDeploy();
        } else {
            String msg = localStrings.getString("enterprise.deployment.backend.deployment_type_error");
            throw new IASDeploymentException(msg);
        }
        this.request.setDeployedDirectory(this.moduleDir);
        this.request.setJSPDirectory(this.jspDir);
        this.request.setStubsDirectory(this.stubsDir);
        this.request.setGeneratedXMLDirectory(this.xmlDir);
    }

    protected List getModuleClasspath(Archivist archivist, AbstractArchive archive) throws IASDeploymentException {
        try {
            String location = this.request.getDeployedDirectory().getAbsolutePath();
            return EJBClassPathUtils.getModuleClasspath(this.request.getName(), location, this.getManager());
        }
        catch (Exception e) {
            throw new IASDeploymentException(e);
        }
    }

    private void setDirsDeploy() throws IASDeploymentException {
        if (this.isReg) {
            String msg = localStrings.getString("enterprise.deployment.backend.deploy_error_module_exists");
            throw new IASDeploymentException(msg);
        }
        this.xmlDir = new File(this.moduleEnv.getModuleGeneratedXMLPath());
        this.jwsDir = new File(this.moduleEnv.getJavaWebStartPath());
        this.stubsDir = this.needsStubs() ? new File(this.moduleEnv.getModuleStubPath()) : null;
        if (this.needsJSPs()) {
            assert (this.modulesMgr instanceof WebModulesManager);
            this.jspDir = new File(this.moduleEnv.getModuleJSPPath());
        }
        if (this.isArchive()) {
            File parent = new File(this.getInstanceEnv().getModuleRepositoryPath());
            this.moduleDir = new File(parent, this.moduleName);
            this.moduleDir.mkdirs();
        } else if (this.isDirectory()) {
            FileSource fileSource = this.request.getFileSource();
            if (fileSource == null || !fileSource.exists()) {
                String msg = localStrings.getString("enterprise.deployment.backend.file_source_does_not_exist", fileSource);
                throw new IASDeploymentException(msg);
            }
            this.moduleDir = fileSource.getFile();
            if (!FileUtils.safeIsDirectory(this.moduleDir)) {
                String msg = localStrings.getString("enterprise.deployment.backend.deployment_directory_does_not_exist", this.moduleDir.getPath());
                throw new IASDeploymentException(msg);
            }
        } else {
            String msg = localStrings.getString("enterprise.deployment.backend.deployment_not_dir_or_archive");
            throw new IASDeploymentException(msg);
        }
    }

    protected Application loadDescriptors() throws IASDeploymentException {
        Application app = super.loadDescriptors();
        new WsUtil().genWSInfo(app, this.request);
        return app;
    }

    private void setDirsUnDeploy() throws IASDeploymentException {
        try {
            if (!this.isReg) {
                String msg = localStrings.getString("enterprise.deployment.backend.undeploy_error_module_not_registered");
                throw new IASDeploymentException(msg);
            }
            this.moduleDir = new File(DeploymentServiceUtils.getLocation(this.moduleName, this.request.getType()));
            this.xmlDir = new File(this.modulesMgr.getGeneratedXMLLocation(this.moduleName));
            this.jwsDir = new File(this.moduleEnv.getJavaWebStartPath());
            this.stubsDir = null;
            this.jspDir = null;
            if (this.needsStubs()) {
                this.stubsDir = new File(this.modulesMgr.getStubLocation(this.moduleName));
            }
            if (this.needsJSPs()) {
                assert (this.modulesMgr instanceof WebModulesManager);
                WebModulesManager mgr = (WebModulesManager)this.modulesMgr;
                this.jspDir = new File(mgr.getJSPLocation(this.moduleName));
            }
        }
        catch (Exception e) {
            String msg = localStrings.getString("enterprise.deployment.backend.error_getting_module_directory", e);
            throw new IASDeploymentException(msg);
        }
    }

    private void setDirsReDeploy() throws IASDeploymentException {
        String msg;
        if (!this.isReg) {
            String msg2 = localStrings.getString("enterprise.deployment.backend.redeploy_error_module_not_registered");
            throw new IASDeploymentException(msg2);
        }
        this.xmlDir = new File(this.modulesMgr.getGeneratedXMLLocation(this.moduleName));
        this.jwsDir = new File(this.moduleEnv.getJavaWebStartPath());
        this.stubsDir = null;
        this.jspDir = null;
        if (this.needsStubs()) {
            this.stubsDir = new File(this.modulesMgr.getStubLocation(this.moduleName));
        }
        if (this.needsJSPs()) {
            assert (this.modulesMgr instanceof WebModulesManager);
            WebModulesManager mgr = (WebModulesManager)this.modulesMgr;
            this.jspDir = new File(mgr.getJSPLocation(this.moduleName));
        }
        if (this.isArchive()) {
            if (!FileUtils.safeIsDirectory(this.originalModuleDir)) {
                msg = localStrings.getString("enterprise.deployment.backend.modulesmanager_error_getting_module_location", this.moduleName);
                throw new IASDeploymentException(msg);
            }
            this.moduleDir = this.originalModuleDir;
        } else if (this.isDirectory()) {
            FileSource fileSource = this.request.getFileSource();
            if (!fileSource.exists()) {
                String msg3 = localStrings.getString("enterprise.deployment.backend.file_source_does_not_exist", fileSource);
                throw new IASDeploymentException(msg3);
            }
            assert (fileSource.isDirectory());
            this.moduleDir = fileSource.getFile();
        } else {
            msg = localStrings.getString("enterprise.deployment.backend.redeployment_not_dir_or_archive");
            throw new IASDeploymentException(msg);
        }
        this.moduleDir.mkdirs();
    }

    public void cleanup_internal() {
        try {
            if (this.request.isUnDeploy()) {
                if (this.isMaybeCMPDropTables) {
                    this.dropTables();
                }
                this.liquidate();
            }
        }
        catch (Exception e) {
            this.logger.warning("Exception caught and ignored in cleanup_internal()");
        }
    }

    protected void preundeploy() throws IASDeploymentException, ConfigException {
        try {
            if (this.getRequest().isMaybeCMPDropTables()) {
                this.isMaybeCMPDropTables = true;
                this.moduleDD = this.getManager().getRegisteredDescriptor(this.moduleName);
                if (this.moduleDD == null) {
                    this.moduleDD = this.request.getDescriptor();
                }
            }
        }
        catch (Throwable t) {
            this.logger.log(Level.WARNING, "enterprise.deployment_pre_undeploy_event_error", t);
        }
    }

    private void undeploy() throws IASDeploymentException, ConfigException {
        try {
            this.unregister();
        }
        catch (ConfigException e) {
            String msg = localStrings.getString("enterprise.deployment.backend.config_exception_on_remove", this.moduleName, e);
            throw new IASDeploymentException(msg, e);
        }
    }

    protected void postDeploy() throws IASDeploymentException, ConfigException {
        String resourceType;
        this.handleUndeletedFiles();
        Properties optionalAttributes = this.request.getOptionalAttributes();
        if (optionalAttributes == null) {
            optionalAttributes = new Properties();
        }
        if ((resourceType = this.getResourceType(this.moduleDir)) != null) {
            optionalAttributes.setProperty("object-type", resourceType);
        }
        this.request.setExternallyManagedApp(this.isExternallyManagedApp(this.moduleDir));
        this.handlePostDeployEvent();
    }

    protected void handlePostDeployEvent() throws IASDeploymentException {
        DeploymentEventInfo info = this.getEventInfo();
        DeploymentEvent ev = new DeploymentEvent(2, info);
        DeploymentEventManager.notifyDeploymentEvent(ev);
    }

    protected DeploymentEventInfo getEventInfo() throws IASDeploymentException {
        return new DeploymentEventInfo(this.moduleDir, this.stubsDir, this.request.getDescriptor(), this.getRequest());
    }

    private void rollback() {
        try {
            this.unregister();
            this.liquidate(true);
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "enterprise.deployment_rollback_error", e);
        }
    }

    protected void register() throws IASDeploymentException, ConfigException {
        this.modulesMgr.registerDescriptor(this.moduleName, this.request.getDescriptor());
    }

    protected void liquidate(boolean isRollback) throws IASDeploymentException {
        if (this.request.isUnDeploy()) {
            if (!DeploymentServiceUtils.isDirectoryDeployed(this.moduleName, this.request.getType()) && !this.request.isReload()) {
                this.cleanAndCheck(this.moduleDir);
            }
        } else if (this.isArchive()) {
            this.cleanAndCheck(this.moduleDir);
        }
        if (isRollback) {
            this.DeleteOrKeepFailedStubs(this.stubsDir);
        } else {
            this.cleanAndCheck(this.stubsDir);
        }
        this.cleanAndCheck(this.jspDir);
        this.cleanAndCheck(this.xmlDir);
        this.cleanAndCheck(this.jwsDir);
        this.liquidateTimeStamp = System.currentTimeMillis();
    }

    protected void liquidate() throws IASDeploymentException {
        this.liquidate(false);
    }

    protected void setShared(boolean what) throws ConfigException {
    }

    protected void unregister() throws ConfigException {
        this.modulesMgr.unregisterDescriptor(this.moduleName);
    }

    protected void runVerifier() throws IASDeploymentException {
        if (this.request.isVerifying()) {
            try {
                String archive = this.request.getDeployedDirectory().getCanonicalPath();
                File jspOutDir = this.request.getPrecompileJSP() ? this.jspDir : null;
                new AppVerifier().verify(this.request.getDescriptor(), new FileArchiveFactory().openArchive(archive), this.request.getCompleteClasspath(), jspOutDir);
            }
            catch (Exception e) {
                String msg = localStrings.getString("enterprise.deployment.backend.verifier_error");
                throw new IASDeploymentException(msg);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setDeployCommand() throws IASDeploymentException {
        if (this.request.isUnDeploy()) {
            if (this.isReg) return;
            String msg = localStrings.getString("enterprise.deployment.backend.undeploy_error_module_not_registered");
            throw new IASDeploymentException(msg);
        }
        if (!this.request.isDeploy()) return;
        if (!this.isReg) {
            this.checkRegisteredAnywhereElse(this.moduleName);
            return;
        }
        if (this.request.isForced()) {
            this.request.setCommand(DeploymentCommand.REDEPLOY);
            return;
        }
        String msg = localStrings.getString("enterprise.deployment.backend.deploy_error_module_exists");
        throw new IASDeploymentException(msg);
    }

    protected ZipItem[] runEJBC() throws IASDeploymentException {
        ZipItem[] clientStubs = null;
        try {
            IASEJBCTimes timing = new IASEJBCTimes();
            EJBCompiler compiler = new EJBCompiler(this.moduleName, this.moduleDir, this.stubsDir, this.getManager(), this.request, timing);
            clientStubs = compiler.compile();
            this.addEJBCTime(timing);
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "enterprise.deployment_ejbc_error", e);
            String msg = localStrings.getString("enterprise.deployment.backend.ejbc_error");
            throw new IASDeploymentException(msg, e);
        }
        return clientStubs;
    }

    protected BaseManager getManager() {
        return this.modulesMgr;
    }

    protected void dropTables() {
        assert (this.isMaybeCMPDropTables);
        try {
            DeploymentEventInfo info = new DeploymentEventInfo(this.moduleDir, this.stubsDir, this.moduleDD, this.request);
            DeploymentEvent ev = new DeploymentEvent(3, info);
            DeploymentEventManager.notifyDeploymentEvent(ev);
        }
        catch (Throwable t) {
            this.logger.log(Level.WARNING, "enterprise.deployment_pre_undeploy_event_error", t);
        }
    }

    public void removePolicy() throws IASDeploymentException {
    }
}

