/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.node.runtime;

import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.types.EjbReference;
import com.sun.enterprise.deployment.types.EjbReferenceContainer;
import com.sun.enterprise.deployment.util.DOLUtils;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EjbRefNode
extends DeploymentDescriptorNode {
    EjbReference descriptor = null;

    public Object getDescriptor() {
        return this.descriptor;
    }

    protected Map getDispatchTable() {
        Map table = super.getDispatchTable();
        table.put("jndi-name", "setJndiName");
        return table;
    }

    public void setElementValue(XMLElement element, String value) {
        if ("ejb-ref-name".equals(element.getQName())) {
            Object parentDesc = this.getParentNode().getDescriptor();
            if (parentDesc instanceof EjbReferenceContainer) {
                try {
                    this.descriptor = ((EjbReferenceContainer)parentDesc).getEjbReference(value);
                    DOLUtils.getDefaultLogger().finer("Applying ref runtime to " + this.descriptor);
                }
                catch (IllegalArgumentException iae) {
                    DOLUtils.getDefaultLogger().warning(iae.getMessage());
                }
            }
            if (this.descriptor == null) {
                DOLUtils.getDefaultLogger().log(Level.SEVERE, "enterprise.deployment.backend.addDescriptorFailure", new Object[]{"ejb-ref", value});
            }
        } else {
            super.setElementValue(element, value);
        }
    }

    public Node writeDescriptor(Node parent, String nodeName, EjbReference ejbRef) {
        Element ejbRefNode = EjbRefNode.appendChild(parent, nodeName);
        EjbRefNode.appendTextChild((Node)ejbRefNode, "ejb-ref-name", ejbRef.getName());
        EjbRefNode.appendTextChild((Node)ejbRefNode, "jndi-name", ejbRef.getJndiName());
        return ejbRefNode;
    }

    public static void writeEjbReferences(Node parent, EjbReferenceContainer descriptor) {
        Iterator ejbRefs = descriptor.getEjbReferenceDescriptors().iterator();
        if (ejbRefs.hasNext()) {
            EjbRefNode refNode = new EjbRefNode();
            while (ejbRefs.hasNext()) {
                EjbReference ejbRef = (EjbReference)ejbRefs.next();
                if (ejbRef.isLocal()) continue;
                refNode.writeDescriptor(parent, "ejb-ref", ejbRef);
            }
        }
    }
}

