/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.iiop;

import com.sun.enterprise.iiop.EJBTargetKeyInfo;
import com.sun.enterprise.iiop.SFSBAbstractInterceptor;
import com.sun.enterprise.iiop.SFSBClientVersionManager;
import com.sun.enterprise.util.Utility;
import java.util.logging.Level;
import org.omg.CORBA.BAD_PARAM;
import org.omg.IOP.Codec;
import org.omg.IOP.ServiceContext;
import org.omg.IOP.TaggedComponent;
import org.omg.PortableInterceptor.ClientRequestInfo;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.ForwardRequest;

public class SFSBClientRequestInterceptor
extends SFSBAbstractInterceptor
implements ClientRequestInterceptor {
    private static final Level TRACE_LEVEL = Level.FINE;
    private static final Level TRACE_LEVEL_FINE = Level.FINE;

    public SFSBClientRequestInterceptor(Codec codec) {
        super("com.sun.enterprise.iiop.SFSBClientRequestInterceptor", codec);
    }

    public void send_request(ClientRequestInfo ri) throws ForwardRequest {
        block5: {
            if (this.doesSFSBVersionPolicyExist(ri)) {
                EJBTargetKeyInfo oidInfo = new EJBTargetKeyInfo(ri.effective_target());
                if (_logger.isLoggable(TRACE_LEVEL_FINE)) {
                    _logger.log(TRACE_LEVEL_FINE, "**SFSBClientInterceptor.send_request...: " + ri.operation() + " " + oidInfo);
                }
                try {
                    long version = SFSBClientVersionManager.getClientVersion(oidInfo.getContainerId(), oidInfo.getInstanceKey());
                    byte[] data = new byte[8];
                    Utility.longToBytes(version, data, 0);
                    ri.add_request_service_context(new ServiceContext(3456, data), false);
                    if (_logger.isLoggable(TRACE_LEVEL)) {
                        _logger.log(TRACE_LEVEL, "SFSBClientInterceptor.send_request. anyData: " + version);
                    }
                }
                catch (Exception e) {
                    if (!_logger.isLoggable(TRACE_LEVEL)) break block5;
                    _logger.log(TRACE_LEVEL, "SFSBClientInterceptor.send_request. Exception", e);
                }
            }
        }
    }

    public void send_poll(ClientRequestInfo ri) {
    }

    private void receiveSFSBVersionNumber(String callName, ClientRequestInfo ri) {
        try {
            if (this.doesSFSBVersionPolicyExist(ri)) {
                EJBTargetKeyInfo oidInfo = new EJBTargetKeyInfo(ri.effective_target());
                ServiceContext ctx = ri.get_reply_service_context(3456);
                if (ctx != null) {
                    long version = Utility.bytesToLong(ctx.context_data, 0);
                    SFSBClientVersionManager.setClientVersion(oidInfo.getContainerId(), oidInfo.getInstanceKey(), version);
                    if (_logger.isLoggable(TRACE_LEVEL)) {
                        _logger.log(TRACE_LEVEL, "SFSBClientInterceptor." + callName + " " + ri.operation() + " " + oidInfo + " version: " + version);
                    }
                }
            }
        }
        catch (Throwable th) {
            _logger.log(Level.FINE, "SFSBClientInterceptor::receiveSFSBVersionNumber Got exception: ", th);
        }
    }

    public void receive_reply(ClientRequestInfo ri) {
        this.receiveSFSBVersionNumber("receive_reply", ri);
    }

    public void receive_exception(ClientRequestInfo ri) throws ForwardRequest {
        this.receiveSFSBVersionNumber("receive_exception", ri);
    }

    public void receive_other(ClientRequestInfo ri) throws ForwardRequest {
        if (this.doesSFSBVersionPolicyExist(ri)) {
            EJBTargetKeyInfo oidInfo = new EJBTargetKeyInfo(ri.effective_target());
            if (_logger.isLoggable(Level.WARNING)) {
                _logger.log(Level.WARNING, "**SFSBClientInterceptor.receive_other...: " + oidInfo);
            }
        }
    }

    public boolean doesSFSBVersionPolicyExist(ClientRequestInfo ri) {
        boolean result = false;
        try {
            TaggedComponent sfsbVersionTag = ri.get_effective_component(1398079614);
            result = sfsbVersionTag != null;
        }
        catch (BAD_PARAM bAD_PARAM) {
            // empty catch block
        }
        return result;
    }
}

