/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.instance;

import com.sun.appserv.server.util.Version;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.instance.BaseManager;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SerializedDescriptorHelper {
    private static final String SERIALIZED_DESCRIPTOR_FILE_NAME = "appDescr.dat";
    private static final String SERIALIZATION_ENABLED_PROPERTY = "com.sun.aas.deployment.serializeDescriptors";
    private static final String SERIALIZATION_ENABLED_DEFAULT = "true";
    private static final boolean isSerializedDescriptorIOEnabled = Boolean.parseBoolean(System.getProperty("com.sun.aas.deployment.serializeDescriptors", "true"));
    private static final Logger logger = LogDomains.getLogger("javax.enterprise.system.core");

    public static Loader load(String moduleID, BaseManager manager) {
        Loader loader = new Loader(moduleID, manager);
        loader.loadSerializedDescriptor();
        return loader;
    }

    public static void store(String moduleID, BaseManager manager, Application application) {
        File file = SerializedDescriptorHelper.getSerializedDescriptorFile(moduleID, manager);
        SerializedDescriptorHelper.store(moduleID, manager, application, file);
    }

    private static void store(String moduleID, BaseManager manager, Application application, File serializedFile) {
        if (SerializedDescriptorHelper.isSerializedDescriptorIOEnabled() && !SerializedDescriptorHelper.storeSerializedDescriptor(application, serializedFile, moduleID)) {
            SerializedDescriptorHelper.storeSerializedDescriptor(new Exception(SerializedDescriptorHelper.getCurrentSoftwareVersion()), serializedFile, moduleID);
        }
    }

    private static boolean isSerializedDescriptorIOEnabled() {
        return isSerializedDescriptorIOEnabled;
    }

    private static String getCurrentSoftwareVersion() {
        return Version.getMajorVersion() + "." + Version.getMinorVersion() + "-" + Version.getBuildVersion();
    }

    private static File getSerializedDescriptorFile(String moduleID, BaseManager manager) {
        return new File(manager.getGeneratedXMLLocation(moduleID), SERIALIZED_DESCRIPTOR_FILE_NAME);
    }

    private static void log(Level level, String messageKey, Throwable t, Object ... args) {
        String msg = logger.getResourceBundle().getString(messageKey);
        String formattedMsg = MessageFormat.format(msg, args);
        logger.log(level, formattedMsg, t);
    }

    private static void log(Level level, String messageKey, Object ... args) {
        logger.log(level, messageKey, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean storeSerializedDescriptor(Object obj, File file, String moduleID) {
        if (!SerializedDescriptorHelper.isSerializedDescriptorIOEnabled()) {
            return false;
        }
        if (!file.getParentFile().exists()) {
            return false;
        }
        ObjectOutputStream oos = null;
        oos = new ObjectOutputStream(new FileOutputStream(file));
        oos.writeObject(obj);
        boolean result = true;
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Serialized application " + moduleID);
        }
        if (oos == null) return result;
        try {
            oos.close();
            return result;
        }
        catch (IOException ioe) {
            SerializedDescriptorHelper.log(Level.WARNING, "core.error_ser_descr", ioe, moduleID);
        }
        return result;
        catch (Throwable t) {
            try {
                result = false;
                SerializedDescriptorHelper.log(Level.WARNING, "core.error_ser_descr", t, moduleID);
                if (oos == null) return result;
            }
            catch (Throwable throwable) {
                if (oos == null) throw throwable;
                try {
                    oos.close();
                    throw throwable;
                }
                catch (IOException ioe) {
                    SerializedDescriptorHelper.log(Level.WARNING, "core.error_ser_descr", ioe, moduleID);
                }
                throw throwable;
            }
            try {
                oos.close();
                return result;
            }
            catch (IOException ioe) {
                SerializedDescriptorHelper.log(Level.WARNING, "core.error_ser_descr", ioe, moduleID);
            }
            return result;
        }
    }

    public static class Loader {
        private Application deserializedApplication;
        private Exception deserializedException;
        private String moduleID;
        private BaseManager manager;
        private File file;

        private Loader(String moduleID, BaseManager manager) {
            this.moduleID = moduleID;
            this.manager = manager;
            this.file = SerializedDescriptorHelper.getSerializedDescriptorFile(moduleID, manager);
        }

        public void store(Application application) {
            boolean tryToWrite;
            if (application == this.deserializedApplication) {
                return;
            }
            boolean bl = tryToWrite = this.deserializedException == null;
            if (this.deserializedException != null && !this.deserializedException.getMessage().equals(SerializedDescriptorHelper.getCurrentSoftwareVersion())) {
                tryToWrite = true;
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Trying to serialize an application that could not be serialized by " + this.deserializedException.getMessage());
                }
            }
            if (tryToWrite) {
                SerializedDescriptorHelper.store(this.moduleID, this.manager, application, this.file);
            }
        }

        public Application getApplication() {
            return this.deserializedApplication;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void loadSerializedDescriptor() {
            boolean fine;
            ObjectInputStream ois;
            block21: {
                if (!SerializedDescriptorHelper.isSerializedDescriptorIOEnabled()) {
                    return;
                }
                this.deserializedApplication = null;
                this.deserializedException = null;
                ois = null;
                fine = logger.isLoggable(Level.FINE);
                if (this.file.exists()) break block21;
                if (fine) {
                    logger.fine("Serialized descriptor for " + this.moduleID + " not found.  Will not try to read serialized file.");
                }
                if (ois == null) return;
                try {
                    ois.close();
                    return;
                }
                catch (IOException ioe) {
                    SerializedDescriptorHelper.log(Level.WARNING, "core.error_deser_descr", new Object[]{this.moduleID, ioe.getLocalizedMessage(), ioe});
                }
                return;
            }
            ois = new ObjectInputStream(new FileInputStream(this.file));
            Object o = ois.readObject();
            if (o instanceof Application) {
                this.deserializedApplication = (Application)o;
                if (fine) {
                    logger.fine("Serialized descriptor for " + this.moduleID + " loaded from " + this.file.getAbsolutePath());
                }
            } else if (o instanceof Exception) {
                this.deserializedException = (Exception)o;
                if (fine) {
                    logger.fine("Serialized descriptor file contained an exception with message \"" + this.deserializedException.getMessage() + "\" " + "because a previous attempt to write it failed.");
                }
            } else {
                SerializedDescriptorHelper.log(Level.WARNING, "core.unexp_deser_type", new Object[]{this.moduleID, o.getClass().getName()});
            }
            if (ois == null) return;
            try {
                ois.close();
                return;
            }
            catch (IOException ioe) {
                SerializedDescriptorHelper.log(Level.WARNING, "core.error_deser_descr", new Object[]{this.moduleID, ioe.getLocalizedMessage(), ioe});
            }
            return;
            catch (Throwable thr) {
                try {
                    SerializedDescriptorHelper.log(Level.WARNING, "core.error_deser_descr", new Object[]{this.moduleID, thr.getLocalizedMessage()});
                    if (ois == null) return;
                }
                catch (Throwable throwable) {
                    if (ois == null) throw throwable;
                    try {
                        ois.close();
                        throw throwable;
                    }
                    catch (IOException ioe) {
                        SerializedDescriptorHelper.log(Level.WARNING, "core.error_deser_descr", new Object[]{this.moduleID, ioe.getLocalizedMessage(), ioe});
                    }
                    throw throwable;
                }
                try {
                    ois.close();
                    return;
                }
                catch (IOException ioe) {
                    SerializedDescriptorHelper.log(Level.WARNING, "core.error_deser_descr", new Object[]{this.moduleID, ioe.getLocalizedMessage(), ioe});
                }
                return;
            }
        }
    }
}

